/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.dat.Tile;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;

public final class TyreTile
extends MmgObj {
    private Tile datObj;
    private boolean ready;
    private MmgBmp img;
    private String imgId;
    private int tmpImageId;
    private boolean pause = false;

    public TyreTile(Tile t) {
        this.SetDatObj(t);
        this.img = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreTile(Tile t, MmgBmp lImg) {
        this.SetDatObj(t);
        this.img = lImg;
        this.ready = true;
    }

    public final boolean GetCanWalk() {
        return this.datObj.canWalk;
    }

    public final int GetImageIndex() {
        return this.datObj.imageIndex;
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final Tile GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(Tile t) {
        this.datObj = t;
        this.imgId = GameSettings.BMP_PREFIX + this.datObj.imageIndex;
    }

    public final String GetImageId() {
        return this.imgId;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    public final void LoadResources() {
        this.pause = true;
        this.tmpImageId = GameSettings.RENDER_GROUND_ALL_GREEN ? DatConstants.ForceNoSnow(this.datObj.imageIndex) : this.datObj.imageIndex;
        this.imgId = GameSettings.BMP_PREFIX + this.tmpImageId + "";
        this.img = TyreDatGameUtils.GetDatCachedBmp(this.tmpImageId, this.imgId);
        this.ready = true;
        this.pause = false;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.img = null;
        this.imgId = null;
        this.ready = false;
    }

    public final TyreTile Clone() {
        TyreTile ret = new TyreTile(this.datObj);
        ret.SetPosition(this.GetPosition());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.GetPosition());
        }
    }

    public final int GetWidth() {
        return this.img.GetWidth();
    }

    public final void SetWidth(int i) {
        this.img.SetWidth(i);
    }

    public final int GetHeight() {
        return this.img.GetHeight();
    }

    public final void SetHeight(int i) {
        this.img.SetHeight(i);
    }
}

