/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreObjects.TyreLinkTable;
import com.middlemindgames.TyreObjects.TyreRoomData;
import com.middlemindgames.dat.Room;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;

public final class TyreRoom
extends MmgObj {
    private Room datObj;
    private boolean ready;
    private MmgBmp img;
    private TyreRoomData[] roomDataInfo;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private int tlen;
    private int ti;
    private CollisionResult tret;
    private int ttlen;
    private int tti;
    private CollisionResult ttret;
    private int clen;
    private int ci;
    private Color dc;
    private boolean pause = false;

    public TyreRoom(Room t) {
        this.SetDatObj(t);
        this.img = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreRoom(Room t, Graphics2D g, BufferedImage lbg) {
        this.bgGraphics = g;
        this.bg = lbg;
        this.SetDatObj(t);
        this.img = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreRoom(Room t, MmgBmp lImg) {
        this.SetDatObj(t);
        this.ready = false;
        this.LoadResources();
        this.img = lImg;
    }

    public final int GetRoomType() {
        return this.datObj.roomType;
    }

    public final CollisionResult CollidesWith(int lx, int ly) {
        this.tret = new CollisionResult(true);
        if (this.roomDataInfo != null && this.roomDataInfo.length > 0) {
            this.tlen = this.roomDataInfo.length;
            this.ti = 0;
            while (this.ti < this.tlen) {
                if (!this.roomDataInfo[this.ti].GetCanWalk()) {
                    this.tret = this.roomDataInfo[this.ti].CollidesWith(lx, ly);
                    if (!this.tret.CanWalk()) break;
                }
                ++this.ti;
            }
        }
        return this.tret;
    }

    public final CollisionResult CollidesWith(int x, int y, int ignore) {
        this.ttret = new CollisionResult(true);
        if (this.roomDataInfo != null && this.roomDataInfo.length > 0) {
            this.ttlen = this.roomDataInfo.length;
            this.tti = 0;
            while (this.tti < this.ttlen) {
                if (this.tti != ignore && !this.roomDataInfo[this.tti].GetCanWalk()) {
                    this.ttret = this.roomDataInfo[this.ti].CollidesWith(x, y);
                    if (!this.ttret.CanWalk()) break;
                }
                ++this.tti;
            }
        }
        return this.ttret;
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final Room GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(Room t) {
        this.datObj = t;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, false);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        this.pause = true;
        if (this.datObj.roomDataInfo != null && this.datObj.roomDataInfo.length > 0) {
            int len = this.datObj.roomDataInfo.length;
            this.roomDataInfo = new TyreRoomData[len];
            for (int i = 0; i < len; ++i) {
                this.roomDataInfo[i] = new TyreRoomData(this.datObj.roomDataInfo[i]);
            }
        } else {
            this.roomDataInfo = null;
        }
        if (this.bgGraphics == null) {
            this.w = MmgHelper.ScaleValue((int)DatConstants.ROOM_WIDTH);
            this.h = MmgHelper.ScaleValue((int)DatConstants.ROOM_HEIGHT);
            this.PrepBuffers(this.w, this.h);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.DrawScreen();
        this.ready = true;
        this.pause = false;
    }

    public final void DrawScreen() {
        this.pause = true;
        if (this.roomDataInfo != null && this.roomDataInfo.length > 0) {
            this.clen = this.roomDataInfo.length;
            this.ci = 0;
            while (this.ci < this.clen) {
                this.roomDataInfo[this.ci].MmgDraw(this.p);
                if (TyreLinkTable.SHOW_COLLISION_BOX && this.roomDataInfo[this.ci] != null && !this.roomDataInfo[this.ci].GetCanWalk()) {
                    this.dc = this.p.GetGraphics().getColor();
                    this.p.GetGraphics().setColor(Color.GREEN);
                    this.p.DrawRect(this.roomDataInfo[this.ci].GetX() - 1, this.roomDataInfo[this.ci].GetY() - 1, this.roomDataInfo[this.ci].GetWidth() + 2, this.roomDataInfo[this.ci].GetHeight() + 2);
                    this.p.GetGraphics().setColor(this.dc);
                }
                ++this.ci;
            }
        }
        this.img = new MmgBmp((Image)this.bg);
        this.pause = false;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.img = null;
        this.roomDataInfo = null;
        this.p = null;
        this.bgGraphics = null;
        this.bg = null;
        this.ready = false;
    }

    public final TyreRoom Clone() {
        TyreRoom ret = new TyreRoom(this.datObj);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.GetPosition());
        }
    }

    public final int GetWidth() {
        return this.img.GetWidth();
    }

    public final void SetWidth(int i) {
        this.img.SetWidth(i);
    }

    public final int GetHeight() {
        return this.img.GetHeight();
    }

    public final void SetHeight(int i) {
        this.img.SetHeight(i);
    }
}

