/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.ControlBgroundStory;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.Mmg9Slice;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFontData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPositionTween;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreOverworldViewRoomText
extends MmgObj {
    private boolean ready;
    private boolean dirty = false;
    private boolean pause = false;
    private boolean lret;
    private MmgBmp img;
    private MmgBmp bground;
    private Mmg9Slice menuBground;
    private MmgVector2 startPos;
    private MmgVector2 finishPos;
    private MmgPositionTween posTween;
    private ControlBgroundStory text;
    private final int paddingX;
    private final int paddingY;
    private final int offsetX;
    private final int offsetY;
    private int posX;
    private int posY;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private ScreenMainGame mainGameScreen;
    private final int lp;
    private String roomText;

    public TyreOverworldViewRoomText(MmgBmp Bground, ScreenMainGame mgs, int PaddingX, int PaddingY, int OffsetX, int OffsetY) {
        this.bground = Bground;
        this.paddingX = PaddingX;
        this.paddingY = PaddingY;
        this.offsetX = OffsetX;
        this.offsetY = OffsetY;
        this.lp = MmgHelper.ScaleValue((int)10);
        this.mainGameScreen = mgs;
        this.ready = false;
        this.LoadResources();
    }

    public String GetRoomText() {
        return this.roomText;
    }

    public void SetRoomText(String r) {
        this.roomText = r;
    }

    public void SetFinishEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetFinishEventId(i);
        }
    }

    public void SetStartEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetStartEventId(i);
        }
    }

    public void SetEventHandler(MmgEventHandler h) {
        if (this.posTween != null) {
            this.posTween.SetOnReachFinish(h);
            this.posTween.SetOnReachStart(h);
        }
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final boolean IsPaused() {
        return this.pause;
    }

    public final void SetPaused(boolean b) {
        this.pause = b;
    }

    public final boolean IsDirty() {
        return this.dirty;
    }

    public final void SetDirty(boolean b) {
        this.dirty = b;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, false);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        this.pause = true;
        int menuWidth = this.paddingY + MmgHelper.ScaleValue((int)DatConstants.DIALOG_ROOM_TEXT_WIDTH) + this.paddingY;
        int menuHeight = this.paddingY + MmgHelper.ScaleValue((int)DatConstants.DIALOG_ROOM_TEXT_HEIGHT) + this.paddingY;
        int totalWidth = this.offsetX + menuWidth + this.offsetX;
        int totalHeight = this.offsetY + menuHeight + this.offsetY;
        int padding = MmgHelper.ScaleValue((int)20);
        this.menuBground = new Mmg9Slice(16, this.bground, totalWidth, totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        this.menuBground.SetWidth(totalWidth);
        this.menuBground.SetHeight(totalHeight);
        MmgHelper.CenterHorAndVert((MmgObj)this.menuBground);
        this.startPos = new MmgVector2(this.menuBground.GetPosition().GetX(), MmgScreenData.GetGameTop() - totalHeight - MmgHelper.ScaleValue((int)10));
        this.finishPos = this.menuBground.GetPosition().Clone();
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        TyreDatGameUtils.wr("OverworldViewRoomText: " + totalWidth + "x" + totalHeight);
        if (this.bgGraphics == null) {
            this.PrepBuffers(this.w, this.h);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.img = new MmgBmp((Image)this.bg);
        TyreDatGameUtils.wr("Found start pos: " + this.startPos.ToString());
        TyreDatGameUtils.wr("Found end pos: " + this.finishPos.ToString());
        this.posTween = new MmgPositionTween((MmgObj)this, DatConstants.ANIMATION_TIME_MS_OVERWORLD_ROOM_TEXT, this.startPos, this.finishPos);
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.text = new ControlBgroundStory();
        this.text.SetLineHeight(MmgFontData.GetTargetPixelHeightScaled() + MmgHelper.ScaleValue((int)2));
        this.text.SetHeight(totalHeight - padding);
        this.text.SetWidth(totalWidth - padding);
        this.text.SetPaddingX(MmgHelper.ScaleValue((int)this.text.GetPaddingX()));
        this.text.SetPaddingY(MmgHelper.ScaleValue((int)this.text.GetPaddingY()));
        this.text.SetPosition(this.startPos);
        this.text.SetColor(MmgColor.GetWhite());
        this.ready = true;
        this.pause = false;
    }

    public final void DrawScreen() {
        this.pause = true;
        this.menuBground.MmgDraw(this.p);
        String msg = this.roomText;
        this.text.PrepLinesInBox(this.text.GetLinesInBox());
        this.text.PrepTextSplit(msg, MmgFontData.GetFontNorm(), MmgFontData.GetFontSize(), this.text.GetWidth());
        this.text.PrepPage(0);
        int diff = this.text.GetLinesInBox() - this.text.GetUsedLineCount();
        for (int i = 0; i < diff; ++i) {
            msg = msg + " [b]";
        }
        msg = msg + " (Press B to Close)";
        TyreDatGameUtils.wr(msg);
        this.text.PrepLinesInBox(this.text.GetLinesInBox());
        this.text.PrepTextSplit(msg, MmgFontData.GetFontNorm(), MmgFontData.GetFontSize(), this.text.GetWidth());
        this.text.PrepPage(0);
        this.pause = false;
    }

    public final void UnloadResources() {
        this.dirty = false;
        this.pause = true;
        this.SetIsVisible(false);
        this.img = null;
        this.bground = null;
        this.menuBground = null;
        this.text = null;
        this.startPos = null;
        this.finishPos = null;
        this.posTween = null;
        this.bg = null;
        this.bgGraphics = null;
        this.p = null;
        this.mainGameScreen = null;
        this.ready = false;
    }

    public final TyreOverworldViewRoomText Clone() {
        TyreOverworldViewRoomText ret = new TyreOverworldViewRoomText(this.bground, this.mainGameScreen, this.paddingX, this.paddingY, this.offsetX, this.offsetY);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.img.GetPosition());
            this.text.MmgDraw(p);
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        if (this.pause) {
            return false;
        }
        this.lret = false;
        if (this.isVisible && this.posTween != null) {
            this.posTween.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame);
        }
        if (this.dirty) {
            this.lret = true;
        }
        if (this.lret) {
            this.DrawScreen();
        }
        return this.lret;
    }

    public final void AnimateInStart() {
        this.posTween.SetDirStartToFinish(true);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void AnimateOutStart() {
        this.posTween.SetDirStartToFinish(false);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void SetPosition(MmgVector2 v) {
        super.SetPosition(v);
        if (this.img != null) {
            this.img.SetPosition(v);
        }
        if (this.text != null) {
            this.text.SetPosition(new MmgVector2(v.GetX() + this.lp, v.GetY() + this.lp));
        }
    }

    public final MmgVector2 GetPosition() {
        if (this.img != null) {
            return this.img.GetPosition();
        }
        return this.GetPosition();
    }

    public final void SetWidth(int i) {
        super.SetWidth(i);
        if (this.img != null) {
            this.img.SetWidth(i);
        }
    }

    public final int GetWidth() {
        if (this.img != null) {
            return this.img.GetWidth();
        }
        return super.GetWidth();
    }

    public final void SetHeight(int i) {
        super.SetHeight(i);
        if (this.img != null) {
            this.img.SetHeight(i);
        }
    }

    public final int GetHeight() {
        if (this.img != null) {
            return this.img.GetHeight();
        }
        return super.GetHeight();
    }
}

