/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.Mmg9Slice;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPositionTween;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreOverworldViewMenu
extends MmgObj {
    public static final int MMG_OVERWORLD_MENU_OPTION_INVESTIGATE_TYPE = 2;
    public static final int MMG_OVERWORLD_MENU_OPTION_INVESTIGATE = 2;
    private final MmgEvent optionInvestigate = new MmgEvent(null, "option_investigate", 2, 2, null, null);
    private MmgEventHandler onOptionInvestigate;
    public static final int MMG_OVERWORLD_MENU_OPTION_TALK_TYPE = 3;
    public static final int MMG_OVERWORLD_MENU_OPTION_TALK = 3;
    private final MmgEvent optionTalk = new MmgEvent(null, "option_read", 3, 3, null, null);
    private MmgEventHandler onOptionTalk;
    public static final int MMG_OVERWORLD_MENU_OPTION_INVENTORY_TYPE = 4;
    public static final int MMG_OVERWORLD_MENU_OPTION_INVENTORY = 4;
    private final MmgEvent optionInventory = new MmgEvent(null, "option_inventory", 4, 4, null, null);
    private MmgEventHandler onOptionInventory;
    public static final int MMG_OVERWORLD_MENU_OPTION_STATS_TYPE = 5;
    public static final int MMG_OVERWORLD_MENU_OPTION_STATS = 5;
    private final MmgEvent optionStats = new MmgEvent(null, "option_stats", 5, 5, null, null);
    private MmgEventHandler onOptionStats;
    public static final int MMG_OVERWORLD_MENU_OPTION_SEARCH_TYPE = 6;
    public static final int MMG_OVERWORLD_MENU_OPTION_SEARCH = 6;
    private final MmgEvent optionSearch = new MmgEvent(null, "option_search", 6, 6, null, null);
    private MmgEventHandler onOptionSearch;
    private boolean ready;
    private boolean dirty = false;
    private boolean pause = false;
    private boolean lret;
    private MmgBmp img;
    private MmgBmp menuOptionSel;
    private MmgBmp[] menuOptions;
    private MmgBmp bground;
    private Mmg9Slice menuBground;
    private MmgVector2 startPos;
    private MmgVector2 finishPos;
    private MmgPositionTween posTween;
    private int paddingX;
    private int paddingY;
    private int offsetX;
    private int offsetY;
    private int selIndex;
    private int minSel;
    private int maxSel;
    private int posX;
    private int posY;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private ScreenMainGame mainGameScreen;

    public TyreOverworldViewMenu(MmgBmp MenuSel, MmgBmp[] MenuOpts, MmgBmp Bground, ScreenMainGame mgs, int PaddingX, int PaddingY, int OffsetX, int OffsetY) {
        this.menuOptionSel = MenuSel;
        this.menuOptions = MenuOpts;
        this.bground = Bground;
        this.paddingX = PaddingX;
        this.paddingY = PaddingY;
        this.offsetX = OffsetX;
        this.offsetY = OffsetY;
        this.mainGameScreen = mgs;
        this.ready = false;
        this.LoadResources();
    }

    public void SetFinishEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetFinishEventId(i);
        }
    }

    public void SetStartEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetStartEventId(i);
        }
    }

    public void SetEventHandler(MmgEventHandler h) {
        if (this.posTween != null) {
            this.posTween.SetOnReachFinish(h);
            this.posTween.SetOnReachStart(h);
        }
        this.onOptionInvestigate = h;
        this.onOptionTalk = h;
        this.onOptionInventory = h;
        this.onOptionStats = h;
        this.onOptionSearch = h;
    }

    public final int GetSelIndex() {
        return this.selIndex;
    }

    public final void SetSelIndex(int i) {
        this.selIndex = i;
    }

    public final int GetMinSel() {
        return this.minSel;
    }

    public final void SetMinSel(int i) {
        this.minSel = i;
    }

    public final int GetMaxSel() {
        return this.minSel;
    }

    public final void SetMaxSel(int i) {
        this.minSel = i;
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final boolean IsPaused() {
        return this.pause;
    }

    public final void SetPaused(boolean b) {
        this.pause = b;
    }

    public final boolean IsDirty() {
        return this.dirty;
    }

    public final void SetDirty(boolean b) {
        this.dirty = b;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    public final void ResetSelIndex() {
        this.selIndex = -1;
        this.dirty = true;
    }

    public final boolean ProcessAClick() {
        int i = this.selIndex;
        TyreDatGameUtils.wr("User keyboard selected option with index: " + i);
        if (i == 0) {
            if (this.onOptionInvestigate != null) {
                this.onOptionInvestigate.MmgHandleEvent(this.optionInvestigate);
            }
            return true;
        }
        if (i == 1) {
            if (this.onOptionTalk != null) {
                this.onOptionTalk.MmgHandleEvent(this.optionTalk);
            }
            return true;
        }
        if (i == 2) {
            if (this.onOptionInventory != null) {
                this.onOptionInventory.MmgHandleEvent(this.optionInventory);
            }
            return true;
        }
        if (i == 3) {
            if (this.onOptionStats != null) {
                this.onOptionStats.MmgHandleEvent(this.optionStats);
            }
            return true;
        }
        if (i == 4) {
            if (this.onOptionSearch != null) {
                this.onOptionSearch.MmgHandleEvent(this.optionSearch);
            }
            return true;
        }
        return false;
    }

    public final boolean ProcessScreenRelease(MmgVector2 v) {
        return this.ProcessScreenRelease(v.GetX(), v.GetY());
    }

    public final boolean ProcessScreenRelease(int x, int y) {
        int nx = x - (this.GetPosition().GetX() - MmgScreenData.GetGameLeft());
        int ny = y - (this.GetPosition().GetY() - MmgScreenData.GetGameTop());
        int len = this.menuOptions.length;
        for (int i = 0; i < len; ++i) {
            if (nx < this.menuOptions[i].GetX() || nx > this.menuOptions[i].GetX() + this.menuOptions[i].GetWidth() || ny < this.menuOptions[i].GetY() || ny > this.menuOptions[i].GetY() + this.menuOptions[i].GetHeight()) continue;
            TyreDatGameUtils.wr("User mouse selected option with index: " + i);
            if (i == 0) {
                this.selIndex = 0;
                this.dirty = true;
                if (this.onOptionInvestigate != null) {
                    this.onOptionInvestigate.MmgHandleEvent(this.optionInvestigate);
                }
                return true;
            }
            if (i == 1) {
                this.selIndex = 1;
                this.dirty = true;
                if (this.onOptionTalk != null) {
                    this.onOptionTalk.MmgHandleEvent(this.optionTalk);
                }
                return true;
            }
            if (i == 2) {
                this.selIndex = 2;
                this.dirty = true;
                if (this.onOptionInventory != null) {
                    this.onOptionInventory.MmgHandleEvent(this.optionInventory);
                }
                return true;
            }
            if (i == 3) {
                this.selIndex = 3;
                this.dirty = true;
                if (this.onOptionStats != null) {
                    this.onOptionStats.MmgHandleEvent(this.optionStats);
                }
                return true;
            }
            if (i == 4) {
                this.selIndex = 4;
                this.dirty = true;
                if (this.onOptionSearch != null) {
                    this.onOptionSearch.MmgHandleEvent(this.optionSearch);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean ProcessDpadRelease(int dir) {
        if (dir == DatConstants.NPC_DIR_LEFT) {
            if (this.selIndex == -1) {
                this.selIndex = this.maxSel;
                this.dirty = true;
            } else if (this.selIndex - 1 >= this.minSel && this.selIndex - 1 <= this.maxSel) {
                --this.selIndex;
                this.dirty = true;
            }
            return true;
        }
        if (dir == DatConstants.NPC_DIR_RIGHT) {
            if (this.selIndex + 1 >= this.minSel && this.selIndex + 1 <= this.maxSel) {
                ++this.selIndex;
                this.dirty = true;
            }
            return true;
        }
        return false;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, false);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        this.pause = true;
        int menuWidth = 0;
        int menuHeight = this.paddingY + this.menuOptions[0].GetHeight() + this.paddingY;
        int len = this.menuOptions.length;
        this.minSel = 0;
        this.maxSel = len - 1;
        this.selIndex = -1;
        for (int i = 0; i < len; ++i) {
            menuWidth += this.paddingX + this.menuOptions[i].GetWidth() + this.paddingX;
        }
        int totalWidth = this.offsetX + menuWidth + this.offsetX;
        int totalHeight = this.offsetY + menuHeight + this.offsetY;
        this.menuBground = new Mmg9Slice(16, this.bground, totalWidth, totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        this.menuBground.SetWidth(totalWidth);
        this.menuBground.SetHeight(totalHeight);
        MmgHelper.CenterHor((MmgObj)this.menuBground);
        this.startPos = new MmgVector2(this.menuBground.GetPosition().GetX(), MmgScreenData.GetGameTop() + MmgScreenData.GetGameHeight() + MmgHelper.ScaleValue((int)10));
        this.finishPos = new MmgVector2(this.menuBground.GetPosition().GetX(), MmgScreenData.GetGameTop() + MmgScreenData.GetGameHeight() - (MmgHelper.ScaleValue((int)10) + totalHeight));
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        TyreDatGameUtils.wr("OverworldViewMenu: " + totalWidth + "x" + totalHeight);
        if (this.bgGraphics == null) {
            this.PrepBuffers(this.w, this.h);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.img = new MmgBmp((Image)this.bg);
        this.DrawScreen();
        TyreDatGameUtils.wr("Found start pos: " + this.startPos.ToString());
        TyreDatGameUtils.wr("Found end pos: " + this.finishPos.ToString());
        this.posTween = new MmgPositionTween((MmgObj)this, DatConstants.ANIMATION_TIME_MS_OVERWORLD_MENU, this.startPos, this.finishPos);
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.ready = true;
        this.pause = false;
    }

    public final void DrawScreen() {
        this.pause = true;
        this.menuBground.MmgDraw(this.p);
        this.posX = this.offsetX + this.paddingX;
        this.posY = this.offsetY + this.paddingY;
        this.p.DrawBmp(this.menuOptions[0], this.posX, this.posY);
        this.menuOptions[0].SetPosition(new MmgVector2(this.posX, this.posY));
        if (this.selIndex == 0) {
            this.p.DrawBmp(this.menuOptionSel, this.posX - (this.menuOptionSel.GetWidth() - this.menuOptions[0].GetWidth()) / 2, this.posY - (this.menuOptionSel.GetHeight() - this.menuOptions[0].GetHeight()) / 2);
        }
        this.posX += this.menuOptions[1].GetWidth() + this.paddingX + this.paddingX;
        this.p.DrawBmp(this.menuOptions[1], this.posX, this.posY);
        this.menuOptions[1].SetPosition(new MmgVector2(this.posX, this.posY));
        if (this.selIndex == 1) {
            this.p.DrawBmp(this.menuOptionSel, this.posX - (this.menuOptionSel.GetWidth() - this.menuOptions[1].GetWidth()) / 2, this.posY - (this.menuOptionSel.GetHeight() - this.menuOptions[1].GetHeight()) / 2);
        }
        this.posX += this.menuOptions[2].GetWidth() + this.paddingX + this.paddingX;
        this.p.DrawBmp(this.menuOptions[2], this.posX, this.posY);
        this.menuOptions[2].SetPosition(new MmgVector2(this.posX, this.posY));
        if (this.selIndex == 2) {
            this.p.DrawBmp(this.menuOptionSel, this.posX - (this.menuOptionSel.GetWidth() - this.menuOptions[2].GetWidth()) / 2, this.posY - (this.menuOptionSel.GetHeight() - this.menuOptions[2].GetHeight()) / 2);
        }
        this.posX += this.menuOptions[3].GetWidth() + this.paddingX + this.paddingX;
        this.p.DrawBmp(this.menuOptions[3], this.posX, this.posY);
        this.menuOptions[3].SetPosition(new MmgVector2(this.posX, this.posY));
        if (this.selIndex == 3) {
            this.p.DrawBmp(this.menuOptionSel, this.posX - (this.menuOptionSel.GetWidth() - this.menuOptions[3].GetWidth()) / 2, this.posY - (this.menuOptionSel.GetHeight() - this.menuOptions[3].GetHeight()) / 2);
        }
        this.posX += this.menuOptions[4].GetWidth() + this.paddingX + this.paddingX;
        this.p.DrawBmp(this.menuOptions[4], this.posX, this.posY);
        this.menuOptions[4].SetPosition(new MmgVector2(this.posX, this.posY));
        if (this.selIndex == 4) {
            this.p.DrawBmp(this.menuOptionSel, this.posX - (this.menuOptionSel.GetWidth() - this.menuOptions[4].GetWidth()) / 2, this.posY - (this.menuOptionSel.GetHeight() - this.menuOptions[4].GetHeight()) / 2);
        }
        this.pause = false;
    }

    public final void UnloadResources() {
        this.dirty = false;
        this.pause = true;
        this.SetIsVisible(false);
        this.onOptionInvestigate = null;
        this.onOptionTalk = null;
        this.onOptionInventory = null;
        this.onOptionStats = null;
        this.onOptionSearch = null;
        this.img = null;
        this.menuOptionSel = null;
        this.menuOptions = null;
        this.bground = null;
        this.menuBground = null;
        this.startPos = null;
        this.finishPos = null;
        this.posTween = null;
        this.bg = null;
        this.bgGraphics = null;
        this.p = null;
        this.mainGameScreen = null;
        this.ready = false;
    }

    public final TyreOverworldViewMenu Clone() {
        TyreOverworldViewMenu ret = new TyreOverworldViewMenu(this.menuOptionSel, this.menuOptions, this.bground, this.mainGameScreen, this.paddingX, this.paddingY, this.offsetX, this.offsetY);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.img.GetPosition());
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        if (this.pause) {
            return false;
        }
        this.lret = false;
        if (this.isVisible && this.posTween != null) {
            this.posTween.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame);
        }
        if (this.dirty) {
            this.lret = true;
        }
        if (this.lret) {
            this.DrawScreen();
        }
        return this.lret;
    }

    public final void AnimateInStart() {
        this.posTween.SetDirStartToFinish(true);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void AnimateOutStart() {
        this.posTween.SetDirStartToFinish(false);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void SetPosition(MmgVector2 v) {
        super.SetPosition(v);
        if (this.img != null) {
            this.img.SetPosition(v);
        }
    }

    public final MmgVector2 GetPosition() {
        if (this.img != null) {
            return this.img.GetPosition();
        }
        return this.GetPosition();
    }

    public final void SetWidth(int i) {
        super.SetWidth(i);
        if (this.img != null) {
            this.img.SetWidth(i);
        }
    }

    public final int GetWidth() {
        if (this.img != null) {
            return this.img.GetWidth();
        }
        return super.GetWidth();
    }

    public final void SetHeight(int i) {
        super.SetHeight(i);
        if (this.img != null) {
            this.img.SetHeight(i);
        }
    }

    public final int GetHeight() {
        if (this.img != null) {
            return this.img.GetHeight();
        }
        return super.GetHeight();
    }
}

