/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.ControlBgroundStory;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreItem;
import com.middlemindgames.TyreObjects.TyreObject;
import com.middlemindgames.TyreObjects.TyreSearchResult;
import com.middlemindgames.dat.ResourceContainer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.Mmg9Slice;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFont;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFontData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPositionTween;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreOverworldViewActionInvestigate
extends MmgObj {
    private boolean ready;
    private boolean dirty = false;
    private boolean pause = false;
    private boolean lret;
    private MmgBmp img;
    private MmgBmp bground;
    private Mmg9Slice menuBground;
    private MmgVector2 startPos;
    private MmgVector2 finishPos;
    private MmgPositionTween posTween;
    private ControlBgroundStory text;
    private final int paddingX;
    private final int paddingY;
    private final int offsetX;
    private final int offsetY;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private ScreenMainGame mainGameScreen;
    private final int lp;
    public static int INVESTIGATE_COUNT_RECENT = 0;
    public static int INVESTIGATE_COUNT_TOTAL = 0;
    public static int[] IRITATION_LEVELS = new int[]{10, 15, 20};
    private String msg;
    private CollisionResult res;
    private TyreObject obj;
    private boolean found;
    private TyreSearchResult sres;
    private TyreItem tItm;

    public TyreOverworldViewActionInvestigate(MmgBmp Bground, ScreenMainGame mgs, int PaddingX, int PaddingY, int OffsetX, int OffsetY) {
        this.bground = Bground;
        this.paddingX = PaddingX;
        this.paddingY = PaddingY;
        this.offsetX = OffsetX;
        this.offsetY = OffsetY;
        this.lp = MmgHelper.ScaleValue((int)10);
        this.mainGameScreen = mgs;
        this.ready = false;
        INVESTIGATE_COUNT_RECENT = 0;
        this.LoadResources();
    }

    public final void SetFinishEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetFinishEventId(i);
        }
    }

    public final void SetStartEventId(int i) {
        if (this.posTween != null) {
            this.posTween.SetStartEventId(i);
        }
    }

    public final void SetEventHandler(MmgEventHandler h) {
        if (this.posTween != null) {
            this.posTween.SetOnReachFinish(h);
            this.posTween.SetOnReachStart(h);
        }
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final boolean IsPaused() {
        return this.pause;
    }

    public final void SetPaused(boolean b) {
        this.pause = b;
    }

    public final boolean IsDirty() {
        return this.dirty;
    }

    public final void SetDirty(boolean b) {
        this.dirty = b;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, false);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        this.pause = true;
        int menuWidth = this.paddingX + MmgHelper.ScaleValue((int)DatConstants.DIALOG_INVESTIGATE_WIDTH) + this.paddingX;
        int menuHeight = this.paddingY + MmgHelper.ScaleValue((int)DatConstants.DIALOG_INVESTIGATE_HEIGHT) + this.paddingY;
        int totalWidth = this.offsetX + menuWidth + this.offsetX;
        int totalHeight = this.offsetY + menuHeight + this.offsetY;
        int padding = MmgHelper.ScaleValue((int)20);
        this.menuBground = new Mmg9Slice(16, this.bground, totalWidth, totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        this.menuBground.SetWidth(totalWidth);
        this.menuBground.SetHeight(totalHeight);
        MmgHelper.CenterHorAndVert((MmgObj)this.menuBground);
        this.startPos = new MmgVector2(this.menuBground.GetPosition().GetX(), MmgScreenData.GetGameTop() - totalHeight - padding);
        this.finishPos = this.menuBground.GetPosition().Clone();
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.menuBground.SetPosition(MmgVector2.GetOriginVec());
        TyreDatGameUtils.wr("OverworldViewActionInvestigate: " + totalWidth + "x" + totalHeight);
        if (this.bgGraphics == null) {
            this.PrepBuffers(this.w, this.h);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.img = new MmgBmp((Image)this.bg);
        TyreDatGameUtils.wr("Found start pos: " + this.startPos.ToString());
        TyreDatGameUtils.wr("Found end pos: " + this.finishPos.ToString());
        this.posTween = new MmgPositionTween((MmgObj)this, DatConstants.ANIMATION_TIME_MS_OVERWORLD_INVESTIGATE, this.startPos, this.finishPos);
        this.SetPosition(this.startPos);
        this.SetWidth(totalWidth);
        this.SetHeight(totalHeight);
        this.text = new ControlBgroundStory();
        this.text.SetLineHeight(MmgFontData.GetTargetPixelHeightScaled() + MmgHelper.ScaleValue((int)2));
        this.text.SetHeight(totalHeight - padding);
        this.text.SetWidth(totalWidth - padding);
        this.text.SetPaddingX(MmgHelper.ScaleValue((int)this.text.GetPaddingX()));
        this.text.SetPaddingY(MmgHelper.ScaleValue((int)this.text.GetPaddingY()));
        this.text.SetPosition(this.startPos);
        this.text.SetColor(MmgColor.GetWhite());
        this.ready = true;
        this.pause = false;
    }

    public final void DrawScreen() {
        this.pause = true;
        this.menuBground.MmgDraw(this.p);
        this.msg = "There's nothing here to investigate.";
        this.res = null;
        this.obj = null;
        this.found = false;
        this.sres = null;
        this.res = this.mainGameScreen.GetOverworldView().GetPcRoomView().CollidesWithForInvestigate(GamePanel.PC.GetInvestigateCollisionRect());
        if (this.res != null) {
            this.obj = this.res.GetCollidedWith();
            if (this.obj != null) {
                if (this.obj.GetType() == DatConstants.OBJECT_TYPE_NPC) {
                    if (this.obj.GetNpc().IsTreeFolk()) {
                        this.msg = "Hmmmmm, after much consideration and deliberation I have decided that this is a tree. Funny, I could have sworn I heard someone chuckle.";
                    } else if (this.obj.GetNpc().IsPiggy()) {
                        this.msg = "After some amount of investigation, some awful smells, and what was overall a fairly embarrassing occurance, I've concluded that this is a pig.";
                    } else {
                        int r = TyreDatGameUtils.GetRandomInt(14);
                        if (r % 13 == 0) {
                            this.sres = GamePanel.PC.GetInventory().PerformGenericSearch();
                            if (this.sres.found) {
                                GamePanel.PC.GetInventory().AddItem(this.sres);
                                this.msg = this.sres.message;
                                this.found = true;
                            }
                        } else {
                            this.msg = "You try to investigate the person in front of you but they start screaming \"Stranger Danger!\", so you stop. Maybe you should try talking to them first.";
                        }
                    }
                } else {
                    int rand;
                    int imgIdx = this.obj.IsAltImage() ? this.obj.GetAltImageIndex() : this.obj.GetImageIndex();
                    this.msg = imgIdx == DatConstants.SPECIAL_OBJECT_SQUARE_BUSH_ALIVE ? (!(DatConstants.IsBadIndex(this.obj.GetStringIndex()) || GameSettings.RENDER_PLANTS_ALL_ALIVE || GameSettings.RENDER_PLANTS_ALL_DEAD) ? ((rand = TyreDatGameUtils.GetRandomInt(10)) % 2 == 0 ? ResourceContainer.strings[this.obj.GetStringIndex()] : "Ok, soooo, that's a bush.") : "Ok, soooo, that's a bush.") : (imgIdx == DatConstants.SPECIAL_OBJECT_SQUARE_BUSH_DEAD ? (!(DatConstants.IsBadIndex(this.obj.GetStringIndex()) || GameSettings.RENDER_PLANTS_ALL_ALIVE || GameSettings.RENDER_PLANTS_ALL_DEAD) ? ((rand = TyreDatGameUtils.GetRandomInt(10)) % 2 == 0 ? ResourceContainer.strings[this.obj.GetStringIndex()] : "Man somebody should've watered this thing. Oh, I mean, that's a dead bush.") : "Man somebody should've watered this thing. Oh, I mean, that's a dead bush.") : (imgIdx == DatConstants.SPECIAL_OBJECT_SQUARE_BUSH_SNOWY_2_ALIVE ? (!(DatConstants.IsBadIndex(this.obj.GetStringIndex()) || GameSettings.RENDER_PLANTS_ALL_ALIVE || GameSettings.RENDER_PLANTS_ALL_DEAD) ? ((rand = TyreDatGameUtils.GetRandomInt(10)) % 2 == 0 ? ResourceContainer.strings[this.obj.GetStringIndex()] : "A snowy little bush. Ugh, this lemon flavored snow tastes terrible.") : "A snowy little bush. Ugh, this lemon flavored snow tastes terrible.") : (imgIdx == DatConstants.SPECIAL_OBJECT_SQUARE_BUSH_SNOWY_1_ALIVE ? (!(DatConstants.IsBadIndex(this.obj.GetStringIndex()) || GameSettings.RENDER_PLANTS_ALL_ALIVE || GameSettings.RENDER_PLANTS_ALL_DEAD) ? ((rand = TyreDatGameUtils.GetRandomInt(10)) % 2 == 0 ? ResourceContainer.strings[this.obj.GetStringIndex()] : "Your typical garden variety 8-bit square bush with a litte snow on top.") : "Your typical garden variety 8-bit square bush with a litte snow on top.") : (!DatConstants.IsBadIndex(this.obj.GetStringIndex()) ? ResourceContainer.strings[this.obj.GetStringIndex()] : "Looks like you found something. Congrats! Image Idx: " + this.obj.GetImageIndex() + " Type: " + this.obj.GetType()))));
                }
                if (!this.found) {
                    if (INVESTIGATE_COUNT_RECENT >= IRITATION_LEVELS[0] && INVESTIGATE_COUNT_RECENT < IRITATION_LEVELS[1]) {
                        this.msg = "Ok, wait, so now you want me to investigate here? Jk.";
                    } else if (INVESTIGATE_COUNT_RECENT >= IRITATION_LEVELS[1] && INVESTIGATE_COUNT_RECENT < IRITATION_LEVELS[2]) {
                        this.msg = "AOL keyword redundant am I right? What you mean what's an AOL keyword?";
                    } else if (INVESTIGATE_COUNT_RECENT >= IRITATION_LEVELS[2]) {
                        this.msg = "If I have to investigate this thing one more time, why I'm gonna just... just... wall I can't think of something right now. But when I do...";
                        INVESTIGATE_COUNT_RECENT = 0;
                    }
                }
                if (this.found) {
                    INVESTIGATE_COUNT_RECENT = 0;
                    MmgFont ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
                    int mw = this.menuBground.GetWidth();
                    int mh = this.menuBground.GetHeight();
                    int offsetX = MmgHelper.ScaleValue((int)4);
                    int offsetY = MmgHelper.ScaleValue((int)4);
                    ++GamePanel.PC.GetState().investigateFindCount;
                    INVESTIGATE_COUNT_RECENT = 0;
                    this.msg = "You've found something!";
                    this.tItm = new TyreItem(ResourceContainer.items[this.sres.itemIndex]);
                    this.tItm.SetMmgColor(MmgColor.GetBlack());
                    MmgBmp item = this.tItm.GetImage();
                    int w = item.GetWidth();
                    int h = item.GetHeight();
                    MmgVector2 tpos = new MmgVector2((mw - w) / 2, (mh - h - offsetY - ftmp.GetHeight() - MmgHelper.ScaleValue((int)60)) / 2);
                    this.p.DrawBmp(item, tpos);
                    int ctmp = ResourceContainer.searches[this.sres.itemIndex].quantity1;
                    ftmp = MmgFontData.CreateDefaultBoldMmgFontSm();
                    ftmp.SetText("+ " + ctmp);
                    ftmp.SetPosition(new MmgVector2(tpos.GetX() + w - ftmp.GetWidth() - offsetX, tpos.GetY() + h + ftmp.GetHeight() + offsetY));
                    this.p.DrawText(ftmp);
                }
            }
        }
        this.text.PrepLinesInBox(this.text.GetLinesInBox());
        this.text.PrepTextSplit(this.msg, MmgFontData.GetFontNorm(), MmgFontData.GetFontSize(), this.text.GetWidth());
        this.text.PrepPage(0);
        int diff = this.text.GetLinesInBox() - this.text.GetUsedLineCount();
        for (int i = 0; i < diff; ++i) {
            this.msg = this.msg + " [b]";
        }
        this.msg = this.msg + " (Press B to Close)";
        TyreDatGameUtils.wr(this.msg);
        this.text.PrepLinesInBox(this.text.GetLinesInBox());
        this.text.PrepTextSplit(this.msg, MmgFontData.GetFontNorm(), MmgFontData.GetFontSize(), this.text.GetWidth());
        this.text.PrepPage(0);
        ++INVESTIGATE_COUNT_RECENT;
        ++INVESTIGATE_COUNT_TOTAL;
        ++GamePanel.PC.GetState().investigateCount;
        this.pause = false;
    }

    public final void UnloadResources() {
        this.dirty = false;
        this.pause = true;
        this.SetIsVisible(false);
        this.img = null;
        this.bground = null;
        this.menuBground = null;
        this.text = null;
        this.startPos = null;
        this.finishPos = null;
        this.posTween = null;
        this.bg = null;
        this.bgGraphics = null;
        this.p = null;
        this.mainGameScreen = null;
        this.ready = false;
    }

    public final TyreOverworldViewActionInvestigate Clone() {
        TyreOverworldViewActionInvestigate ret = new TyreOverworldViewActionInvestigate(this.bground, this.mainGameScreen, this.paddingX, this.paddingY, this.offsetX, this.offsetY);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.img.GetPosition());
            this.text.MmgDraw(p);
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        if (this.pause) {
            return false;
        }
        this.lret = false;
        if (this.isVisible && this.posTween != null) {
            this.posTween.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame);
        }
        if (this.dirty) {
            this.lret = true;
        }
        if (this.lret) {
            this.DrawScreen();
        }
        return this.lret;
    }

    public final void AnimateInStart() {
        this.posTween.SetDirStartToFinish(true);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void AnimateOutStart() {
        this.posTween.SetDirStartToFinish(false);
        this.posTween.SetMsStartMove(System.currentTimeMillis());
        this.posTween.SetMoving(true);
    }

    public final void SetPosition(MmgVector2 v) {
        super.SetPosition(v);
        if (this.img != null) {
            this.img.SetPosition(v);
        }
        if (this.text != null) {
            this.text.SetPosition(new MmgVector2(v.GetX() + this.lp, v.GetY() + this.lp));
        }
    }

    public final MmgVector2 GetPosition() {
        if (this.img != null) {
            return this.img.GetPosition();
        }
        return this.GetPosition();
    }

    public final void SetWidth(int i) {
        super.SetWidth(i);
        if (this.img != null) {
            this.img.SetWidth(i);
        }
    }

    public final int GetWidth() {
        if (this.img != null) {
            return this.img.GetWidth();
        }
        return super.GetWidth();
    }

    public final void SetHeight(int i) {
        super.SetHeight(i);
        if (this.img != null) {
            this.img.SetHeight(i);
        }
    }

    public final int GetHeight() {
        if (this.img != null) {
            return this.img.GetHeight();
        }
        return super.GetHeight();
    }
}

