/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.HandleOverworldViewEvent;
import com.middlemindgames.TyreGame.ScreenMainGame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreLinkTable;
import com.middlemindgames.TyreObjects.TyreNpc;
import com.middlemindgames.TyreObjects.TyrePc;
import com.middlemindgames.dat.ResourceContainer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuItem;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreOverworldView
extends MmgObj {
    public static boolean IGNORE_ROOMS_OUTSIDE_OF_VIEW = true;
    private final int roomWidth;
    private final int roomHeight;
    private final int rooms;
    private TyreLinkTable[] roomViews;
    private TyreLinkTable pcRoomView;
    private boolean[] roomViewsLoaded;
    private MmgVector2[] roomViewsPos;
    private boolean ready;
    private MmgBmp img;
    private int roomViewX;
    private int roomViewY;
    private BufferedImage ow;
    private Graphics2D owGraphics;
    private MmgPen owP;
    private BufferedImage owView;
    private Graphics2D owViewGraphics;
    private MmgPen owViewP;
    private int linkTableIndex;
    private RoomViewIndex startingRoomViewIndex;
    private MmgMenuContainer menu;
    private int menuIdx;
    private boolean menuOn;
    private HandleOverworldViewEvent handleMenuEvent;
    private MmgBmp menuDpadLeft;
    private MmgBmp menuDpadRight;
    private MmgBmp menuDpadUp;
    private MmgBmp menuDpadDown;
    private MmgBmp menuBtnA;
    private MmgBmp menuBtnB;
    private MmgMenuItem menuDpadLeftItm;
    private MmgMenuItem menuDpadRightItm;
    private MmgMenuItem menuDpadUpItm;
    private MmgMenuItem menuDpadDownItm;
    private MmgMenuItem menuBtnAItm;
    private MmgMenuItem menuBtnBItm;
    private int tlen;
    private int ti;
    private int ttlen;
    private int tti;
    private boolean lret;
    private int ci;
    private int dw;
    private int dh;
    private int trvi;
    private int tlrvi;
    private int trrvi;
    private int tfrvi;
    private int tbrvi;
    private RoomViewIndex trv;
    private RoomViewIndex tlrv;
    private RoomViewIndex trrv;
    private RoomViewIndex tfrv;
    private RoomViewIndex tbrv;
    private String tmp;
    private int TW;
    private int TH;
    private int TWE;
    private int THE;
    private int pcX;
    private int pcY;
    private int pcW;
    private int pcH;
    private MmgVector2 offsetCenterTop;
    private MmgVector2 offsetCenterBottom;
    private MmgVector2 offsetRightMiddle;
    private MmgVector2 offsetLeftMiddle;
    private MmgVector2 offsetTopRightDiag;
    private MmgVector2 offsetTopLeftDiag;
    private MmgVector2 offsetBottomRightDiag;
    private MmgVector2 offsetBottomLeftDiag;
    private TyreLinkTable pcR;
    private int[] mirrorRooms;
    private int mc;
    private Hashtable<String, TyreLinkTable> roomViewCache;
    private boolean pause = false;
    private int tmpIdx;
    private boolean loadLeft;
    private int loadLeftIdx;
    private TyreLinkTable loadLeft1;
    private TyreLinkTable loadLeft2;
    private TyreLinkTable loadLeft3;
    private boolean loadRight;
    private int loadRightIdx;
    private TyreLinkTable loadRight1;
    private TyreLinkTable loadRight2;
    private TyreLinkTable loadRight3;
    private boolean loadTop;
    private int loadTopIdx;
    private TyreLinkTable loadTop1;
    private TyreLinkTable loadTop2;
    private TyreLinkTable loadTop3;
    private boolean loadBottom;
    private int loadBottomIdx;
    private TyreLinkTable loadBottom1;
    private TyreLinkTable loadBottom2;
    private TyreLinkTable loadBottom3;
    private ScreenMainGame mainGameScreen;
    private int exitAdj;
    private MmgVector2 irvPos;
    private boolean drawOneFrame;

    public TyreOverworldView(int lti, RoomViewIndex lrvi, int lroomWidth, int lroomHeight, ScreenMainGame mgs) {
        this.roomWidth = lroomWidth;
        this.roomHeight = lroomHeight;
        this.rooms = 9;
        this.linkTableIndex = lti;
        this.startingRoomViewIndex = lrvi;
        this.ready = false;
        this.roomViewCache = new Hashtable();
        this.loadLeft = false;
        this.loadLeftIdx = 0;
        this.loadRight = false;
        this.loadRightIdx = 0;
        this.mainGameScreen = mgs;
        this.exitAdj = MmgHelper.ScaleValue((int)3);
        this.LoadResources();
    }

    public TyreOverworldView(int lti, RoomViewIndex lrvi, MmgBmp lImg, int lroomWidth, int lroomHeight, ScreenMainGame mgs) {
        this.roomWidth = lroomWidth;
        this.roomHeight = lroomHeight;
        this.rooms = 9;
        this.linkTableIndex = lti;
        this.startingRoomViewIndex = lrvi;
        this.ready = false;
        this.roomViewCache = new Hashtable();
        this.loadLeft = false;
        this.loadLeftIdx = 0;
        this.loadRight = false;
        this.loadRightIdx = 0;
        this.mainGameScreen = mgs;
        this.exitAdj = MmgHelper.ScaleValue((int)3);
        this.LoadResources();
        this.img = lImg;
    }

    public final void DrawOneFrame() {
        this.drawOneFrame = true;
        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_ALL);
        this.SetPaused(false);
    }

    public final ScreenMainGame GetMainGameScreen() {
        return this.mainGameScreen;
    }

    public final TyreLinkTable GetPcRoomView() {
        return this.pcRoomView;
    }

    public final boolean ProcessAClick() {
        if (this.menuOn && this.menu != null) {
            this.ProcessMenuItemSel(this.menuBtnAItm, 0);
            return true;
        }
        return false;
    }

    public final boolean ProcessBClick() {
        if (this.menuOn && this.menu != null) {
            this.ProcessMenuItemSel(this.menuBtnBItm, 0);
            return true;
        }
        return false;
    }

    public final boolean ProcessDirClick(int dir) {
        if (this.menuOn && this.menu != null) {
            if (dir == DatConstants.NPC_DIR_BACK) {
                this.ProcessMenuItemSel(this.menuDpadUpItm, 0);
                return true;
            }
            if (dir == DatConstants.NPC_DIR_FRONT) {
                this.ProcessMenuItemSel(this.menuDpadDownItm, 0);
                return true;
            }
            if (dir == DatConstants.NPC_DIR_LEFT) {
                this.ProcessMenuItemSel(this.menuDpadLeftItm, 0);
                return true;
            }
            if (dir == DatConstants.NPC_DIR_RIGHT) {
                this.ProcessMenuItemSel(this.menuDpadRightItm, 0);
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean ProcessDirPress(int dir) {
        if (this.menuOn && this.menu != null) {
            GamePanel.PC.SetCurrentState(DatConstants.NPC_STATE_WALKING);
            GamePanel.PC.SetMsPerFrame(TyrePc.DEFAULT_MS_PER_FRAME_WALKING);
            if (dir == DatConstants.NPC_DIR_BACK && GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_BACK) {
                this.ProcessMenuItemSel(this.menuDpadUpItm, 1);
                return true;
            }
            if (dir == DatConstants.NPC_DIR_FRONT && GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_FRONT) {
                this.ProcessMenuItemSel(this.menuDpadDownItm, 1);
                return true;
            }
            if (dir == DatConstants.NPC_DIR_LEFT && GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_LEFT) {
                this.ProcessMenuItemSel(this.menuDpadLeftItm, 1);
                return true;
            }
            if (dir == DatConstants.NPC_DIR_RIGHT && GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_RIGHT) {
                this.ProcessMenuItemSel(this.menuDpadRightItm, 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean ProcessDirRelease(int dir) {
        if (this.menuOn && this.menu != null) {
            GamePanel.PC.SetCurrentState(DatConstants.NPC_STATE_PACING);
            GamePanel.PC.SetMsPerFrame(TyrePc.DEFAULT_MS_PER_FRAME_PACING);
            if (dir == DatConstants.NPC_DIR_BACK && GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_BACK) {
                return true;
            }
            if (dir == DatConstants.NPC_DIR_FRONT && GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_FRONT) {
                return true;
            }
            if (dir == DatConstants.NPC_DIR_LEFT && GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_LEFT) {
                return true;
            }
            return dir == DatConstants.NPC_DIR_RIGHT && GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_RIGHT;
        }
        return false;
    }

    public boolean ProcessScreenPress(MmgVector2 v) {
        return this.ProcessScreenPress(v.GetX(), v.GetY());
    }

    public final boolean ProcessScreenPress(int x, int y) {
        if (this.menuOn && this.menu != null) {
            Object[] objs = this.menu.GetArray();
            MmgMenuItem item = null;
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    item = (MmgMenuItem)objs[i];
                    if (x < item.GetX() || x > item.GetX() + item.GetWidth() || y < item.GetY() || y > item.GetY() + item.GetHeight()) continue;
                    this.menuIdx = i;
                    if (item.GetEventPress().GetEventId() >= 0 && item.GetEventPress().GetEventId() <= 3) {
                        GamePanel.PC.SetCurrentState(DatConstants.NPC_STATE_WALKING);
                        GamePanel.PC.SetMsPerFrame(TyrePc.DEFAULT_MS_PER_FRAME_WALKING);
                    }
                    this.ProcessMenuItemSel(item, 1);
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean ProcessScreenRelease(MmgVector2 v) {
        return this.ProcessScreenRelease(v.GetX(), v.GetY());
    }

    public final boolean ProcessScreenRelease(int x, int y) {
        if (this.menuOn && this.menu != null) {
            Object[] objs = this.menu.GetArray();
            MmgMenuItem item = null;
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    item = (MmgMenuItem)objs[i];
                    if (x < item.GetX() || x > item.GetX() + item.GetWidth() || y < item.GetY() || y > item.GetY() + item.GetHeight()) continue;
                    this.menuIdx = i;
                    if (item.GetEventPress().GetEventId() >= 0 && item.GetEventPress().GetEventId() <= 3) {
                        GamePanel.PC.SetCurrentState(DatConstants.NPC_STATE_PACING);
                        GamePanel.PC.SetMsPerFrame(TyrePc.DEFAULT_MS_PER_FRAME_PACING);
                    }
                    this.ProcessMenuItemSel(item, 2);
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean ProcessScreenClick(MmgVector2 v) {
        return this.ProcessScreenClick(v.GetX(), v.GetY());
    }

    public final boolean ProcessScreenClick(int x, int y) {
        if (this.menuOn && this.menu != null) {
            Object[] objs = this.menu.GetArray();
            MmgMenuItem item = null;
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    item = (MmgMenuItem)objs[i];
                    if (x < item.GetX() || x > item.GetX() + item.GetWidth() || y < item.GetY() || y > item.GetY() + item.GetHeight()) continue;
                    this.menuIdx = i;
                    this.ProcessMenuItemSel(item, 0);
                    return true;
                }
            }
        }
        return false;
    }

    public final void ProcessMenuItemSel(MmgMenuItem item, int type) {
        MmgEvent me;
        if (item != null && (me = item.GetEventPress()) != null && me.GetTargetEventHandler() != null) {
            if (type == 0) {
                me.SetEventType(0);
            } else if (type == 1) {
                me.SetEventType(1);
            } else if (type == 2) {
                me.SetEventType(2);
            }
            me.GetTargetEventHandler().MmgHandleEvent(me);
        }
    }

    public final void AddRoomViewCache(TyreLinkTable tlt, int index) {
        this.roomViewCache.put(index + "", tlt);
    }

    public final CollisionResult ScrollViewPort(MmgRect inRect) {
        if (this.roomViewsPos[GamePanel.PC.GetRoomViewIndex().getValue()].GetX() + inRect.GetLeft() < 0) {
            return new CollisionResult(false);
        }
        if (this.roomViewsPos[GamePanel.PC.GetRoomViewIndex().getValue()].GetX() + inRect.GetRight() > this.roomWidth * 3) {
            return new CollisionResult(false);
        }
        if (this.roomViewsPos[GamePanel.PC.GetRoomViewIndex().getValue()].GetY() + inRect.GetTop() < 0) {
            return new CollisionResult(false);
        }
        if (this.roomViewsPos[GamePanel.PC.GetRoomViewIndex().getValue()].GetY() + inRect.GetBottom() > this.roomHeight * 3) {
            return new CollisionResult(false);
        }
        if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT && this.roomViewX > 0) {
            if (this.roomViewsPos[GamePanel.PC.GetRoomViewIndex().getValue()].GetX() + inRect.GetLeft() - this.roomViewX <= GamePanel.PC.GetWidth() * 3) {
                this.roomViewX = this.roomViewX - GamePanel.PC.SPEED >= 0 ? (this.roomViewX -= GamePanel.PC.SPEED) : 0;
            }
        } else if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT && this.roomViewX + this.GetWidth() < this.roomWidth * 3) {
            if (this.roomViewX + this.GetWidth() - (this.roomViewsPos[GamePanel.PC.GetRoomViewIndex().getValue()].GetX() + inRect.GetRight()) <= GamePanel.PC.GetWidth() * 3) {
                this.roomViewX = this.roomViewX + GamePanel.PC.SPEED <= this.roomWidth * 3 - this.GetWidth() - 1 ? (this.roomViewX += GamePanel.PC.SPEED) : this.roomWidth * 3 - this.GetWidth() - 1;
            }
        } else if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK && this.roomViewY > 0) {
            if (this.roomViewsPos[GamePanel.PC.GetRoomViewIndex().getValue()].GetY() + inRect.GetTop() - this.roomViewY <= GamePanel.PC.GetHeight() * 1) {
                this.roomViewY = this.roomViewY - GamePanel.PC.SPEED >= 0 ? (this.roomViewY -= GamePanel.PC.SPEED) : 0;
            }
        } else if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT && this.roomViewY + this.GetHeight() < this.roomHeight * 3 && this.roomViewY + this.GetHeight() - (this.roomViewsPos[GamePanel.PC.GetRoomViewIndex().getValue()].GetY() + inRect.GetBottom()) <= GamePanel.PC.GetHeight() * 1) {
            this.roomViewY = this.roomViewY + GamePanel.PC.SPEED <= this.roomHeight * 3 - this.GetHeight() - 1 ? (this.roomViewY += GamePanel.PC.SPEED) : this.roomHeight * 3 - this.GetHeight();
        }
        return new CollisionResult(true);
    }

    public final int GetLinkTableIndex() {
        return this.linkTableIndex;
    }

    public final void SetLinkTableIndex(int i) {
        this.linkTableIndex = i;
    }

    public final RoomViewIndex GetStartingRoomViewIndex() {
        return this.startingRoomViewIndex;
    }

    public final void SetStartingRoomViewIndex(RoomViewIndex v) {
        this.startingRoomViewIndex = v;
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    public final TyreLinkTable[] GetRoomViews() {
        return this.roomViews;
    }

    public final void SetRoomViews(TyreLinkTable[] s) {
        this.roomViews = s;
    }

    private void PrepBuffers(int w, int h) {
        this.ow = this.create(this.roomWidth * 3, this.roomHeight * 3, false);
        this.owGraphics = (Graphics2D)this.ow.getGraphics();
        this.owView = this.create(this.GetWidth(), this.GetHeight(), false);
        this.owViewGraphics = (Graphics2D)this.owView.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        int mainY;
        TyreLinkTable tmp2;
        this.pause = true;
        this.SetHeight(MmgScreenData.GetGameHeight());
        this.SetWidth(MmgScreenData.GetGameWidth());
        this.SetPosition(MmgScreenData.GetPosition());
        int w = this.roomWidth;
        int h = this.roomHeight;
        TyreDatGameUtils.wr("RoomWidth: " + this.roomWidth + ", RoomHeight: " + this.roomHeight);
        TyreLinkTable.NPC_RENDER_MODE = TyreNpc.NpcRenderMode.GAME;
        if (this.owGraphics == null || this.owViewGraphics == null) {
            this.PrepBuffers(w, h);
        }
        this.offsetCenterTop = new MmgVector2(0, this.roomHeight);
        this.offsetCenterBottom = new MmgVector2(0, -this.roomHeight);
        this.offsetRightMiddle = new MmgVector2(-this.roomWidth, 0);
        this.offsetLeftMiddle = new MmgVector2(this.roomWidth, 0);
        this.offsetTopRightDiag = new MmgVector2(-this.roomWidth, this.roomHeight);
        this.offsetTopLeftDiag = new MmgVector2(this.roomWidth, this.roomHeight);
        this.offsetBottomRightDiag = new MmgVector2(-this.roomWidth, -this.roomHeight);
        this.offsetBottomLeftDiag = new MmgVector2(this.roomWidth, -this.roomHeight);
        this.mirrorRooms = new int[9];
        this.owP = new MmgPen((Graphics)this.owGraphics);
        this.owViewP = new MmgPen((Graphics)this.owViewGraphics);
        this.roomViews = new TyreLinkTable[this.rooms];
        this.roomViewsLoaded = new boolean[this.rooms];
        this.roomViewsPos = new MmgVector2[this.rooms];
        for (int i = 0; i < this.rooms; ++i) {
            this.roomViewsLoaded[i] = false;
        }
        this.roomViewsPos[0] = new MmgVector2(0, 0);
        this.roomViewsPos[1] = new MmgVector2(w, 0);
        this.roomViewsPos[2] = new MmgVector2(w * 2, 0);
        this.roomViewsPos[3] = new MmgVector2(0, h);
        this.roomViewsPos[4] = new MmgVector2(w, h);
        this.roomViewsPos[5] = new MmgVector2(w * 2, h);
        this.roomViewsPos[6] = new MmgVector2(0, h * 2);
        this.roomViewsPos[7] = new MmgVector2(w, h * 2);
        this.roomViewsPos[8] = new MmgVector2(w * 2, h * 2);
        this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[this.linkTableIndex], this.linkTableIndex);
        this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE.getValue()].SetPosition(new MmgVector2(w, h));
        this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
        TyreLinkTable tmp = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE.getValue()];
        if (tmp.HasLinkLeft()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp.GetLinkLeft()], tmp.GetLinkLeft());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE.getValue()].SetPosition(new MmgVector2(0, h));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE.getValue()] = true;
        }
        if (tmp.HasLinkTop()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp.GetLinkTop()], tmp.GetLinkTop());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP.getValue()].SetPosition(new MmgVector2(w, 0));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP.getValue()] = true;
        }
        if (tmp.HasLinkRight()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp.GetLinkRight()], tmp.GetLinkRight());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE.getValue()].SetPosition(new MmgVector2(w * 2, h));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE.getValue()] = true;
        }
        if (tmp.HasLinkBottom()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp.GetLinkBottom()], tmp.GetLinkBottom());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM.getValue()].SetPosition(new MmgVector2(w, h * 2));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM.getValue()] = true;
        }
        if (tmp.HasLinkLeft() && !this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()] && this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE.getValue()] && (tmp2 = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE.getValue()]).HasLinkTop()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp2.GetLinkTop()], tmp2.GetLinkTop());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()].SetPosition(new MmgVector2(0, 0));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()] = true;
        }
        if (tmp.HasLinkLeft() && !this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()] && this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE.getValue()] && (tmp2 = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE.getValue()]).HasLinkBottom()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp2.GetLinkBottom()], tmp2.GetLinkBottom());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()].SetPosition(new MmgVector2(0, h * 2));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()] = true;
        }
        if (tmp.HasLinkTop() && !this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()] && this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP.getValue()] && (tmp2 = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP.getValue()]).HasLinkLeft()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp2.GetLinkLeft()], tmp2.GetLinkLeft());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()].SetPosition(new MmgVector2(0, 0));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP.getValue()] = true;
        }
        if (tmp.HasLinkTop() && !this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()] && this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP.getValue()] && (tmp2 = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP.getValue()]).HasLinkRight()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp2.GetLinkRight()], tmp2.GetLinkRight());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()].SetPosition(new MmgVector2(w * 2, 0));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()] = true;
        }
        if (tmp.HasLinkRight() && !this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()] && this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE.getValue()] && (tmp2 = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE.getValue()]).HasLinkTop()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp2.GetLinkTop()], tmp2.GetLinkTop());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()].SetPosition(new MmgVector2(w * 2, 0));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP.getValue()] = true;
        }
        if (tmp.HasLinkRight() && !this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()] && this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE.getValue()] && (tmp2 = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE.getValue()]).HasLinkBottom()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp2.GetLinkBottom()], tmp2.GetLinkBottom());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()].SetPosition(new MmgVector2(w * 2, h * 2));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()] = true;
        }
        if (tmp.HasLinkBottom() && !this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()] && this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM.getValue()] && (tmp2 = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM.getValue()]).HasLinkLeft()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp2.GetLinkLeft()], tmp2.GetLinkLeft());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()].SetPosition(new MmgVector2(0, h * 2));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM.getValue()] = true;
        }
        if (tmp.HasLinkBottom() && !this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()] && this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM.getValue()] && (tmp2 = this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM.getValue()]).HasLinkRight()) {
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()] = new TyreLinkTable(ResourceContainer.linkTables[tmp2.GetLinkRight()], tmp2.GetLinkRight());
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()].SetPosition(new MmgVector2(w * 2, h * 2));
            this.roomViews[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM);
            this.roomViewsLoaded[RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM.getValue()] = true;
        }
        if (this.roomViews != null && this.roomViews.length > 0) {
            this.ci = 0;
            while (this.ci < this.rooms) {
                if (this.roomViews[this.ci] != null) {
                    this.AddRoomViewCache(this.roomViews[this.ci], this.roomViews[this.ci].GetRcIndex());
                }
                ++this.ci;
            }
        }
        TyreDatGameUtils.wr("RoomViewCache Size: " + this.roomViewCache.size());
        this.menu = new MmgMenuContainer();
        this.menu.SetMmgColor(null);
        String imgId = "dpad_left.png";
        MmgBmp lval = null;
        String path = "../cfg/drawable/dpad_left.png";
        this.menuDpadLeft = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "dpad_right.png";
        lval = null;
        path = "../cfg/drawable/dpad_right.png";
        this.menuDpadRight = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "dpad_up.png";
        lval = null;
        path = "../cfg/drawable/dpad_up.png";
        this.menuDpadUp = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "dpad_down.png";
        lval = null;
        path = "../cfg/drawable/dpad_down.png";
        this.menuDpadDown = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "a_btn.png";
        lval = null;
        path = "../cfg/drawable/a_btn.png";
        this.menuBtnA = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "b_btn.png";
        lval = null;
        path = "../cfg/drawable/b_btn.png";
        this.menuBtnB = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        this.handleMenuEvent = new HandleOverworldViewEvent(this);
        if (this.menuDpadLeft != null) {
            mainY = this.GetHeight() - this.menuDpadDown.GetHeight() - this.menuDpadLeft.GetHeight() - MmgHelper.ScaleValue((int)15);
            this.menuDpadLeft.SetX(MmgHelper.ScaleValue((int)30));
            this.menuDpadLeft.SetY(mainY);
            this.menuDpadLeft.SetIsVisible(true);
            this.menuDpadLeftItm = TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Overworld View Dpad Left", 0, -1, this.menuDpadLeft);
            this.menu.Add(this.menuDpadLeftItm);
        }
        TyreDatGameUtils.wr("Left Button Pos: " + this.menuDpadLeft.GetPosition().ToString());
        if (this.menuDpadRight != null) {
            mainY = this.menuDpadLeft.GetY();
            this.menuDpadRight.SetX(this.menuDpadLeft.GetX() + this.menuDpadLeft.GetWidth() + MmgHelper.ScaleValue((int)30));
            this.menuDpadRight.SetY(mainY);
            this.menuDpadRight.SetIsVisible(true);
            this.menuDpadRightItm = TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Overworld View Dpad Right", 1, -1, this.menuDpadRight);
            this.menu.Add(this.menuDpadRightItm);
        }
        if (this.menuDpadDown != null) {
            mainY = this.GetHeight() - this.menuDpadDown.GetHeight() - MmgHelper.ScaleValue((int)30);
            this.menuDpadDown.SetX(this.menuDpadLeft.GetX() + this.menuDpadLeft.GetWidth() - MmgHelper.ScaleValue((int)10));
            this.menuDpadDown.SetY(mainY);
            this.menuDpadDown.SetIsVisible(true);
            this.menuDpadDownItm = TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Overworld View Dpad Down", 3, -1, this.menuDpadDown);
            this.menu.Add(this.menuDpadDownItm);
        }
        if (this.menuDpadUp != null) {
            mainY = this.menuDpadLeft.GetY() - this.menuDpadUp.GetHeight() + MmgHelper.ScaleValue((int)15);
            this.menuDpadUp.SetX(this.menuDpadDown.GetX());
            this.menuDpadUp.SetY(mainY);
            this.menuDpadUp.SetIsVisible(true);
            this.menuDpadUpItm = TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Overworld View Dpad Up", 2, -1, this.menuDpadUp);
            this.menu.Add(this.menuDpadUpItm);
        }
        if (this.menuBtnB != null) {
            mainY = this.menuDpadLeft.GetY() - MmgHelper.ScaleValue((int)8);
            this.menuBtnB.SetX(this.GetWidth() - this.menuBtnB.GetWidth() - MmgHelper.ScaleValue((int)30));
            this.menuBtnB.SetY(mainY);
            this.menuBtnB.SetIsVisible(true);
            this.menuBtnBItm = TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Overworld View B Button", 5, 0, this.menuBtnB);
            this.menu.Add(this.menuBtnBItm);
        }
        if (this.menuBtnA != null) {
            mainY = this.menuDpadLeft.GetY() - MmgHelper.ScaleValue((int)8);
            this.menuBtnA.SetX(this.menuBtnB.GetX() - this.menuBtnB.GetWidth() - MmgHelper.ScaleValue((int)15));
            this.menuBtnA.SetY(mainY);
            this.menuBtnA.SetIsVisible(true);
            this.menuBtnAItm = TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Overworld View A Button", 4, 0, this.menuBtnA);
            this.menu.Add(this.menuBtnAItm);
        }
        this.menuOn = true;
        this.roomViewX = (this.ow.getWidth() - this.GetWidth()) / 2;
        this.roomViewY = (this.ow.getHeight() - this.GetHeight()) / 2;
        this.DrawScreen();
        this.DrawMenu();
        this.ready = true;
        this.pause = false;
    }

    public final boolean IsRoomViewIndexVisible(RoomViewIndex v) {
        return this.IsRoomViewIndexVisible(v.getValue());
    }

    public final boolean IsRoomViewIndexVisible(int v) {
        this.dw = this.GetWidth();
        this.dh = this.GetHeight();
        this.irvPos = this.roomViewsPos[v];
        if (this.irvPos.GetX() + this.roomWidth < this.roomViewX || this.irvPos.GetX() > this.roomViewX + this.dw) {
            return false;
        }
        return this.irvPos.GetY() + this.roomHeight >= this.roomViewY && this.irvPos.GetY() <= this.roomViewY + this.dh;
    }

    public final void DrawScreen() {
        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_ALL);
    }

    public final void DrawScreen(RoomViewIndex v) {
        this.pause = true;
        if (RoomViewIndex.ROOM_VIEW_INDEX_ALL == v) {
            if (this.roomViews != null && this.roomViews.length > 0) {
                this.ci = 0;
                while (this.ci < this.rooms) {
                    if (this.roomViews[this.ci] != null) {
                        this.roomViews[this.ci].MmgDraw(this.owP);
                    }
                    ++this.ci;
                }
            }
        } else if (RoomViewIndex.ROOM_VIEW_INDEX_NONE != v && this.roomViews[v.getValue()] != null) {
            if (IGNORE_ROOMS_OUTSIDE_OF_VIEW) {
                if (this.IsRoomViewIndexVisible(v)) {
                    this.roomViews[v.getValue()].MmgDraw(this.owP);
                } else {
                    TyreDatGameUtils.wr("Skipping drawing room...");
                }
            } else {
                this.roomViews[v.getValue()].MmgDraw(this.owP);
            }
        }
        this.pause = false;
    }

    public final void DrawMenu() {
        this.dw = this.GetWidth();
        this.dh = this.GetHeight();
        this.owViewGraphics.drawImage(this.ow, 0, 0, this.dw, this.dh, this.roomViewX, this.roomViewY, this.roomViewX + this.dw, this.roomViewY + this.dh, null);
        this.menu.MmgDraw(this.owViewP);
        this.img = new MmgBmp((Image)this.owView);
    }

    public final void UnloadResources() {
        this.pause = true;
        this.img = null;
        this.ow = null;
        this.owGraphics = null;
        this.owView = null;
        this.owViewGraphics = null;
        this.owP = null;
        this.owViewP = null;
        if (this.roomViews != null && this.roomViews.length > 0) {
            this.tlen = this.roomViews.length;
            this.ti = 0;
            while (this.ti < this.tlen) {
                this.roomViews[this.ti].UnloadResources();
                ++this.ti;
            }
        }
        this.roomViews = null;
        this.roomViewsLoaded = null;
        this.roomViewsPos = null;
        this.ready = false;
        this.pcRoomView = null;
        this.startingRoomViewIndex = null;
        this.menu = null;
        this.handleMenuEvent = null;
        this.menuDpadLeft = null;
        this.menuDpadRight = null;
        this.menuDpadUp = null;
        this.menuDpadDown = null;
        this.menuBtnA = null;
        this.menuBtnB = null;
        this.menuDpadLeftItm = null;
        this.menuDpadRightItm = null;
        this.menuDpadUpItm = null;
        this.menuDpadDownItm = null;
        this.menuBtnAItm = null;
        this.menuBtnBItm = null;
        this.trv = null;
        this.tlrv = null;
        this.trrv = null;
        this.tfrv = null;
        this.tbrv = null;
        this.tmp = null;
        this.offsetCenterTop = null;
        this.offsetCenterBottom = null;
        this.offsetRightMiddle = null;
        this.offsetLeftMiddle = null;
        this.offsetTopRightDiag = null;
        this.offsetTopLeftDiag = null;
        this.offsetBottomRightDiag = null;
        this.offsetBottomLeftDiag = null;
        this.pcR = null;
        this.mirrorRooms = null;
        this.roomViewCache = null;
        this.loadLeft1 = null;
        this.loadLeft2 = null;
        this.loadLeft3 = null;
        this.loadRight1 = null;
        this.loadRight2 = null;
        this.loadRight3 = null;
        this.loadTop1 = null;
        this.loadTop2 = null;
        this.loadTop3 = null;
        this.loadBottom1 = null;
        this.loadBottom2 = null;
        this.loadBottom3 = null;
        this.mainGameScreen = null;
    }

    public boolean IsPaused() {
        return this.pause;
    }

    public void SetPaused(boolean b) {
        this.pause = b;
    }

    public final TyreOverworldView Clone() {
        TyreOverworldView ret = new TyreOverworldView(this.linkTableIndex, this.startingRoomViewIndex, this.roomWidth, this.roomHeight, this.mainGameScreen);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.GetPosition());
        }
    }

    public final RoomViewIndex GetLeftRoomViewIndex(RoomViewIndex crvi) {
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM;
        }
        return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
    }

    public final RoomViewIndex GetRightRoomViewIndex(RoomViewIndex crvi) {
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
    }

    public final RoomViewIndex GetBackRoomViewIndex(RoomViewIndex crvi) {
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE;
        }
        return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
    }

    public final RoomViewIndex GetFrontRoomViewIndex(RoomViewIndex crvi) {
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
            return RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE) {
            return RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        if (crvi == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
            return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        }
        return RoomViewIndex.ROOM_VIEW_INDEX_NONE;
    }

    public final RoomViewIndex GetLeftFrontRoomViewIndex(RoomViewIndex crvi) {
        return this.GetFrontRoomViewIndex(this.GetLeftRoomViewIndex(crvi));
    }

    public final RoomViewIndex GetRightFrontRoomViewIndex(RoomViewIndex crvi) {
        return this.GetFrontRoomViewIndex(this.GetRightRoomViewIndex(crvi));
    }

    public final RoomViewIndex GetLeftBackRoomViewIndex(RoomViewIndex crvi) {
        return this.GetBackRoomViewIndex(this.GetLeftRoomViewIndex(crvi));
    }

    public final RoomViewIndex GetRightBackRoomViewIndex(RoomViewIndex crvi) {
        return this.GetBackRoomViewIndex(this.GetRightRoomViewIndex(crvi));
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        if (this.pause) {
            return false;
        }
        this.lret = false;
        if (this.isVisible && this.roomViews != null && this.roomViews.length > 0) {
            TyreLinkTable tlt;
            this.ttlen = this.roomViews.length;
            this.tmp = "UNKNOWN ";
            this.pcW = GamePanel.PC.GetWidth();
            this.pcH = GamePanel.PC.GetHeight();
            this.TW = this.pcH / 1;
            this.TH = this.pcH / 1;
            this.TWE = this.pcH / 2 - this.exitAdj;
            this.THE = this.pcH / 2 - this.exitAdj;
            this.pcX = GamePanel.PC.GetX();
            this.pcY = GamePanel.PC.GetY();
            this.trv = GamePanel.PC.GetRoomViewIndex();
            this.trvi = this.trv.getValue();
            this.pcR = this.roomViews[this.trvi];
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT && (GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP || GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE || GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM)) {
                if (this.roomViewX > this.roomWidth && !this.loadRight) {
                    this.loadRight = true;
                    this.loadRightIdx = 0;
                }
            } else if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT && (GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP || GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE || GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM)) {
                if (this.roomViewX + this.GetWidth() < this.roomWidth * 2 && !this.loadLeft) {
                    this.loadLeft = true;
                    this.loadLeftIdx = 0;
                }
            } else if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT && (GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM || GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM || GamePanel.PC.GetRoomViewIndex() == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM)) {
                if (this.roomViewY > this.roomHeight && !this.loadBottom) {
                    this.loadBottom = true;
                    this.loadBottomIdx = 0;
                }
            } else if (!(GamePanel.PC.GetCurrentDir() != DatConstants.NPC_DIR_BACK || GamePanel.PC.GetRoomViewIndex() != RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP && GamePanel.PC.GetRoomViewIndex() != RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP && GamePanel.PC.GetRoomViewIndex() != RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP || this.roomViewY + this.GetHeight() >= this.roomHeight * 2 || this.loadTop)) {
                this.loadTop = true;
                this.loadTopIdx = 0;
            }
            if (this.loadRight && GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT) {
                if (this.loadRightIdx == 0) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight2 = tlt;
                            } else {
                                this.loadRight2 = null;
                            }
                        } else {
                            this.loadRight2 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight1 = tlt;
                            } else {
                                this.loadRight1 = null;
                            }
                        } else {
                            this.loadRight1 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight3 = tlt;
                            } else {
                                this.loadRight3 = null;
                            }
                        } else {
                            this.loadRight3 = null;
                        }
                    }
                    ++this.loadRightIdx;
                } else if (this.loadRightIdx == 1) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE) {
                        if (this.loadRight2 != null) {
                            this.tmpIdx = this.loadRight2.GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight1 = tlt;
                            } else {
                                this.loadRight1 = null;
                            }
                        } else {
                            this.loadRight1 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
                        if (this.loadRight1 != null) {
                            this.tmpIdx = this.loadRight1.GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight2 = tlt;
                            } else {
                                this.loadRight2 = null;
                            }
                        } else {
                            this.loadRight2 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
                        if (this.loadRight3 != null) {
                            this.tmpIdx = this.loadRight3.GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight2 = tlt;
                            } else {
                                this.loadRight2 = null;
                            }
                        } else {
                            this.loadRight2 = null;
                        }
                    }
                    ++this.loadRightIdx;
                } else if (this.loadRightIdx == 2) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE) {
                        if (this.loadRight2 != null) {
                            this.tmpIdx = this.loadRight2.GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight3 = tlt;
                            } else {
                                this.loadRight3 = null;
                            }
                        } else {
                            this.loadRight3 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
                        if (this.loadRight2 != null) {
                            this.tmpIdx = this.loadRight2.GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight3 = tlt;
                            } else {
                                this.loadRight3 = null;
                            }
                        } else {
                            this.loadRight3 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
                        if (this.loadRight2 != null) {
                            this.tmpIdx = this.loadRight2.GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadRight1 = tlt;
                            } else {
                                this.loadRight1 = null;
                            }
                        } else {
                            this.loadRight1 = null;
                        }
                    }
                    ++this.loadRightIdx;
                } else if (this.loadRightIdx == 3) {
                    if (this.loadRight1 != null && this.loadRight2 != null && this.loadRight3 != null) {
                        this.roomViews[0] = this.roomViews[1];
                        if (this.roomViews[0] != null) {
                            this.roomViews[0].SetPosition(this.roomViewsPos[0]);
                            this.roomViews[0].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP);
                            this.roomViewsLoaded[0] = true;
                        } else {
                            this.roomViewsLoaded[0] = false;
                        }
                        this.roomViews[3] = this.roomViews[4];
                        if (this.roomViews[3] != null) {
                            this.roomViews[3].SetPosition(this.roomViewsPos[3]);
                            this.roomViews[3].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
                            this.roomViewsLoaded[3] = true;
                        } else {
                            this.roomViewsLoaded[3] = false;
                        }
                        this.roomViews[6] = this.roomViews[7];
                        if (this.roomViews[6] != null) {
                            this.roomViews[6].SetPosition(this.roomViewsPos[6]);
                            this.roomViews[6].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM);
                            this.roomViewsLoaded[6] = true;
                        } else {
                            this.roomViewsLoaded[6] = false;
                        }
                        this.roomViews[1] = this.roomViews[2];
                        if (this.roomViews[1] != null) {
                            this.roomViews[1].SetPosition(this.roomViewsPos[1]);
                            this.roomViews[1].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
                            this.roomViewsLoaded[1] = true;
                        } else {
                            this.roomViewsLoaded[1] = false;
                        }
                        this.roomViews[4] = this.roomViews[5];
                        if (this.roomViews[4] != null) {
                            this.roomViews[4].SetPosition(this.roomViewsPos[4]);
                            this.roomViews[4].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                            this.roomViewsLoaded[4] = true;
                        } else {
                            this.roomViewsLoaded[4] = false;
                        }
                        this.roomViews[7] = this.roomViews[8];
                        if (this.roomViews[7] != null) {
                            this.roomViews[7].SetPosition(this.roomViewsPos[7]);
                            this.roomViews[7].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
                            this.roomViewsLoaded[7] = true;
                        } else {
                            this.roomViewsLoaded[7] = false;
                        }
                        this.roomViews[2] = this.loadRight1;
                        if (this.roomViews[2] != null) {
                            this.roomViews[2].SetPosition(this.roomViewsPos[2]);
                            this.roomViews[2].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP);
                            this.roomViewsLoaded[2] = true;
                        } else {
                            this.roomViewsLoaded[2] = false;
                        }
                        this.roomViews[5] = this.loadRight2;
                        if (this.roomViews[5] != null) {
                            this.roomViews[5].SetPosition(this.roomViewsPos[5]);
                            this.roomViews[5].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
                            this.roomViewsLoaded[5] = true;
                        } else {
                            this.roomViewsLoaded[5] = false;
                        }
                        this.roomViews[8] = this.loadRight3;
                        if (this.roomViews[8] != null) {
                            this.roomViews[8].SetPosition(this.roomViewsPos[8]);
                            this.roomViews[8].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM);
                            this.roomViewsLoaded[8] = true;
                        } else {
                            this.roomViewsLoaded[8] = false;
                        }
                        if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
                        } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                        } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
                        }
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_ALL);
                        this.roomViewX -= this.roomWidth * 1;
                        this.lret = true;
                    }
                    this.loadRight = false;
                    this.loadRightIdx = 0;
                    this.loadRight1 = null;
                    this.loadRight2 = null;
                    this.loadRight3 = null;
                }
            } else if (this.loadLeft && GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT) {
                if (this.loadLeftIdx == 0) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft2 = tlt;
                            } else {
                                this.loadLeft2 = null;
                            }
                        } else {
                            this.loadLeft2 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft1 = tlt;
                            } else {
                                this.loadLeft1 = null;
                            }
                        } else {
                            this.loadLeft1 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft3 = tlt;
                            } else {
                                this.loadLeft3 = null;
                            }
                        } else {
                            this.loadLeft3 = null;
                        }
                    }
                    ++this.loadLeftIdx;
                } else if (this.loadLeftIdx == 1) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE) {
                        if (this.loadLeft2 != null) {
                            this.tmpIdx = this.loadLeft2.GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft1 = tlt;
                            } else {
                                this.loadLeft1 = null;
                            }
                        } else {
                            this.loadLeft1 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
                        if (this.loadLeft1 != null) {
                            this.tmpIdx = this.loadLeft1.GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft2 = tlt;
                            } else {
                                this.loadLeft2 = null;
                            }
                        } else {
                            this.loadLeft2 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
                        if (this.loadLeft3 != null) {
                            this.tmpIdx = this.loadLeft3.GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft2 = tlt;
                            } else {
                                this.loadLeft2 = null;
                            }
                        } else {
                            this.loadLeft2 = null;
                        }
                    }
                    ++this.loadLeftIdx;
                } else if (this.loadLeftIdx == 2) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE) {
                        if (this.loadLeft2 != null) {
                            this.tmpIdx = this.loadLeft2.GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft3 = tlt;
                            } else {
                                this.loadLeft3 = null;
                            }
                        } else {
                            this.loadLeft3 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
                        if (this.loadLeft2 != null) {
                            this.tmpIdx = this.loadLeft2.GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft3 = tlt;
                            } else {
                                this.loadLeft3 = null;
                            }
                        } else {
                            this.loadLeft3 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
                        if (this.loadLeft2 != null) {
                            this.tmpIdx = this.loadLeft2.GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadLeft1 = tlt;
                            } else {
                                this.loadLeft1 = null;
                            }
                        } else {
                            this.loadLeft1 = null;
                        }
                    }
                    ++this.loadLeftIdx;
                } else if (this.loadLeftIdx == 3) {
                    if (this.loadLeft1 != null && this.loadLeft2 != null && this.loadLeft3 != null) {
                        this.roomViews[2] = this.roomViews[1];
                        if (this.roomViews[2] != null) {
                            this.roomViews[2].SetPosition(this.roomViewsPos[2]);
                            this.roomViews[2].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP);
                            this.roomViewsLoaded[2] = true;
                        } else {
                            this.roomViewsLoaded[2] = false;
                        }
                        this.roomViews[5] = this.roomViews[4];
                        if (this.roomViews[5] != null) {
                            this.roomViews[5].SetPosition(this.roomViewsPos[5]);
                            this.roomViews[5].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
                            this.roomViewsLoaded[5] = true;
                        } else {
                            this.roomViewsLoaded[5] = false;
                        }
                        this.roomViews[8] = this.roomViews[7];
                        if (this.roomViews[8] != null) {
                            this.roomViews[8].SetPosition(this.roomViewsPos[8]);
                            this.roomViews[8].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM);
                            this.roomViewsLoaded[8] = true;
                        } else {
                            this.roomViewsLoaded[8] = false;
                        }
                        this.roomViews[1] = this.roomViews[0];
                        if (this.roomViews[1] != null) {
                            this.roomViews[1].SetPosition(this.roomViewsPos[1]);
                            this.roomViews[1].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
                            this.roomViewsLoaded[1] = true;
                        } else {
                            this.roomViewsLoaded[1] = false;
                        }
                        this.roomViews[4] = this.roomViews[3];
                        if (this.roomViews[4] != null) {
                            this.roomViews[4].SetPosition(this.roomViewsPos[4]);
                            this.roomViews[4].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                            this.roomViewsLoaded[4] = true;
                        } else {
                            this.roomViewsLoaded[4] = false;
                        }
                        this.roomViews[7] = this.roomViews[6];
                        if (this.roomViews[7] != null) {
                            this.roomViews[7].SetPosition(this.roomViewsPos[7]);
                            this.roomViews[7].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
                            this.roomViewsLoaded[7] = true;
                        } else {
                            this.roomViewsLoaded[7] = false;
                        }
                        this.roomViews[0] = this.loadLeft1;
                        if (this.roomViews[0] != null) {
                            this.roomViews[0].SetPosition(this.roomViewsPos[0]);
                            this.roomViews[0].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP);
                            this.roomViewsLoaded[0] = true;
                        } else {
                            this.roomViewsLoaded[0] = false;
                        }
                        this.roomViews[3] = this.loadLeft2;
                        if (this.roomViews[3] != null) {
                            this.roomViews[3].SetPosition(this.roomViewsPos[3]);
                            this.roomViews[3].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
                            this.roomViewsLoaded[3] = true;
                        } else {
                            this.roomViewsLoaded[3] = false;
                        }
                        this.roomViews[6] = this.loadLeft3;
                        if (this.roomViews[6] != null) {
                            this.roomViews[6].SetPosition(this.roomViewsPos[6]);
                            this.roomViews[6].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM);
                            this.roomViewsLoaded[6] = true;
                        } else {
                            this.roomViewsLoaded[6] = false;
                        }
                        if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
                        } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                        } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
                        }
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_ALL);
                        this.roomViewX += this.roomWidth * 1;
                        this.lret = true;
                    }
                    this.loadLeft = false;
                    this.loadLeftIdx = 0;
                    this.loadLeft1 = null;
                    this.loadLeft2 = null;
                    this.loadLeft3 = null;
                }
            } else if (this.loadTop && GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK) {
                if (this.loadTopIdx == 0) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop2 = tlt;
                            } else {
                                this.loadTop2 = null;
                            }
                        } else {
                            this.loadTop2 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop1 = tlt;
                            } else {
                                this.loadTop1 = null;
                            }
                        } else {
                            this.loadTop1 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkTop();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop3 = tlt;
                            } else {
                                this.loadTop3 = null;
                            }
                        } else {
                            this.loadTop3 = null;
                        }
                    }
                    ++this.loadTopIdx;
                } else if (this.loadTopIdx == 1) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP) {
                        if (this.loadTop2 != null) {
                            this.tmpIdx = this.loadTop2.GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop1 = tlt;
                            } else {
                                this.loadTop1 = null;
                            }
                        } else {
                            this.loadTop1 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
                        if (this.loadTop1 != null) {
                            this.tmpIdx = this.loadTop1.GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop2 = tlt;
                            } else {
                                this.loadTop2 = null;
                            }
                        } else {
                            this.loadTop2 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
                        if (this.loadTop3 != null) {
                            this.tmpIdx = this.loadTop3.GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop2 = tlt;
                            } else {
                                this.loadTop2 = null;
                            }
                        } else {
                            this.loadTop2 = null;
                        }
                    }
                    ++this.loadTopIdx;
                } else if (this.loadTopIdx == 2) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP) {
                        if (this.loadTop2 != null) {
                            this.tmpIdx = this.loadTop2.GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop3 = tlt;
                            } else {
                                this.loadTop3 = null;
                            }
                        } else {
                            this.loadTop3 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
                        if (this.loadTop2 != null) {
                            this.tmpIdx = this.loadTop2.GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop3 = tlt;
                            } else {
                                this.loadTop3 = null;
                            }
                        } else {
                            this.loadTop3 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
                        if (this.loadTop2 != null) {
                            this.tmpIdx = this.loadTop2.GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadTop1 = tlt;
                            } else {
                                this.loadTop1 = null;
                            }
                        } else {
                            this.loadTop1 = null;
                        }
                    }
                    ++this.loadTopIdx;
                } else if (this.loadTopIdx == 3) {
                    if (this.loadTop1 != null && this.loadTop2 != null && this.loadTop3 != null) {
                        this.roomViews[6] = this.roomViews[3];
                        if (this.roomViews[6] != null) {
                            this.roomViews[6].SetPosition(this.roomViewsPos[6]);
                            this.roomViews[6].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM);
                            this.roomViewsLoaded[6] = true;
                        } else {
                            this.roomViewsLoaded[6] = false;
                        }
                        this.roomViews[7] = this.roomViews[4];
                        if (this.roomViews[7] != null) {
                            this.roomViews[7].SetPosition(this.roomViewsPos[7]);
                            this.roomViews[7].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
                            this.roomViewsLoaded[7] = true;
                        } else {
                            this.roomViewsLoaded[7] = false;
                        }
                        this.roomViews[8] = this.roomViews[5];
                        if (this.roomViews[8] != null) {
                            this.roomViews[8].SetPosition(this.roomViewsPos[8]);
                            this.roomViews[8].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM);
                            this.roomViewsLoaded[8] = true;
                        } else {
                            this.roomViewsLoaded[8] = false;
                        }
                        this.roomViews[3] = this.roomViews[0];
                        if (this.roomViews[3] != null) {
                            this.roomViews[3].SetPosition(this.roomViewsPos[3]);
                            this.roomViews[3].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
                            this.roomViewsLoaded[3] = true;
                        } else {
                            this.roomViewsLoaded[3] = false;
                        }
                        this.roomViews[4] = this.roomViews[1];
                        if (this.roomViews[4] != null) {
                            this.roomViews[4].SetPosition(this.roomViewsPos[4]);
                            this.roomViews[4].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                            this.roomViewsLoaded[4] = true;
                        } else {
                            this.roomViewsLoaded[4] = false;
                        }
                        this.roomViews[5] = this.roomViews[2];
                        if (this.roomViews[5] != null) {
                            this.roomViews[5].SetPosition(this.roomViewsPos[5]);
                            this.roomViews[5].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
                            this.roomViewsLoaded[5] = true;
                        } else {
                            this.roomViewsLoaded[5] = false;
                        }
                        this.roomViews[0] = this.loadTop1;
                        if (this.roomViews[0] != null) {
                            this.roomViews[0].SetPosition(this.roomViewsPos[0]);
                            this.roomViews[0].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP);
                            this.roomViewsLoaded[0] = true;
                        } else {
                            this.roomViewsLoaded[0] = false;
                        }
                        this.roomViews[1] = this.loadTop2;
                        if (this.roomViews[1] != null) {
                            this.roomViews[1].SetPosition(this.roomViewsPos[1]);
                            this.roomViews[1].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
                            this.roomViewsLoaded[1] = true;
                        } else {
                            this.roomViewsLoaded[1] = false;
                        }
                        this.roomViews[2] = this.loadTop3;
                        if (this.roomViews[2] != null) {
                            this.roomViews[2].SetPosition(this.roomViewsPos[2]);
                            this.roomViews[2].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP);
                            this.roomViewsLoaded[2] = true;
                        } else {
                            this.roomViewsLoaded[2] = false;
                        }
                        if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
                        } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                        } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
                        }
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_ALL);
                        this.roomViewY += this.roomHeight * 1;
                        this.lret = true;
                    }
                    this.loadTop = false;
                    this.loadTopIdx = 0;
                    this.loadTop1 = null;
                    this.loadTop2 = null;
                    this.loadTop3 = null;
                }
            } else if (this.loadBottom && GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT) {
                if (this.loadBottomIdx == 0) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom2 = tlt;
                            } else {
                                this.loadBottom2 = null;
                            }
                        } else {
                            this.loadBottom2 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom1 = tlt;
                            } else {
                                this.loadBottom1 = null;
                            }
                        } else {
                            this.loadBottom1 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
                        if (this.trvi != -1) {
                            this.tmpIdx = this.roomViews[this.trvi].GetLinkBottom();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom3 = tlt;
                            } else {
                                this.loadBottom3 = null;
                            }
                        } else {
                            this.loadBottom3 = null;
                        }
                    }
                    ++this.loadBottomIdx;
                } else if (this.loadBottomIdx == 1) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM) {
                        if (this.loadBottom2 != null) {
                            this.tmpIdx = this.loadBottom2.GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom1 = tlt;
                            } else {
                                this.loadBottom1 = null;
                            }
                        } else {
                            this.loadBottom1 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
                        if (this.loadBottom1 != null) {
                            this.tmpIdx = this.loadBottom1.GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom2 = tlt;
                            } else {
                                this.loadBottom2 = null;
                            }
                        } else {
                            this.loadBottom2 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
                        if (this.loadBottom3 != null) {
                            this.tmpIdx = this.loadBottom3.GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom2 = tlt;
                            } else {
                                this.loadBottom2 = null;
                            }
                        } else {
                            this.loadBottom2 = null;
                        }
                    }
                    ++this.loadBottomIdx;
                } else if (this.loadBottomIdx == 2) {
                    if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM) {
                        if (this.loadBottom2 != null) {
                            this.tmpIdx = this.loadBottom2.GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom3 = tlt;
                            } else {
                                this.loadBottom3 = null;
                            }
                        } else {
                            this.loadBottom3 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
                        if (this.loadBottom2 != null) {
                            this.tmpIdx = this.loadBottom2.GetLinkRight();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom3 = tlt;
                            } else {
                                this.loadBottom3 = null;
                            }
                        } else {
                            this.loadBottom3 = null;
                        }
                    } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
                        if (this.loadBottom2 != null) {
                            this.tmpIdx = this.loadBottom2.GetLinkLeft();
                            if (this.tmpIdx != -1) {
                                tlt = !this.roomViewCache.containsKey(this.tmpIdx + "") ? new TyreLinkTable(ResourceContainer.linkTables[this.tmpIdx], this.tmpIdx) : this.roomViewCache.get(this.tmpIdx + "");
                                this.loadBottom1 = tlt;
                            } else {
                                this.loadBottom1 = null;
                            }
                        } else {
                            this.loadBottom1 = null;
                        }
                    }
                    ++this.loadBottomIdx;
                } else if (this.loadBottomIdx == 3) {
                    if (this.loadBottom1 != null && this.loadBottom2 != null && this.loadBottom3 != null) {
                        this.roomViews[0] = this.roomViews[3];
                        if (this.roomViews[0] != null) {
                            this.roomViews[0].SetPosition(this.roomViewsPos[0]);
                            this.roomViews[0].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP);
                            this.roomViewsLoaded[0] = true;
                        } else {
                            this.roomViewsLoaded[0] = false;
                        }
                        this.roomViews[1] = this.roomViews[4];
                        if (this.roomViews[1] != null) {
                            this.roomViews[1].SetPosition(this.roomViewsPos[1]);
                            this.roomViews[1].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
                            this.roomViewsLoaded[1] = true;
                        } else {
                            this.roomViewsLoaded[1] = false;
                        }
                        this.roomViews[2] = this.roomViews[5];
                        if (this.roomViews[2] != null) {
                            this.roomViews[2].SetPosition(this.roomViewsPos[2]);
                            this.roomViews[2].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP);
                            this.roomViewsLoaded[2] = true;
                        } else {
                            this.roomViewsLoaded[2] = false;
                        }
                        this.roomViews[3] = this.roomViews[6];
                        if (this.roomViews[3] != null) {
                            this.roomViews[3].SetPosition(this.roomViewsPos[3]);
                            this.roomViews[3].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
                            this.roomViewsLoaded[3] = true;
                        } else {
                            this.roomViewsLoaded[3] = false;
                        }
                        this.roomViews[4] = this.roomViews[7];
                        if (this.roomViews[4] != null) {
                            this.roomViews[4].SetPosition(this.roomViewsPos[4]);
                            this.roomViews[4].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                            this.roomViewsLoaded[4] = true;
                        } else {
                            this.roomViewsLoaded[4] = false;
                        }
                        this.roomViews[5] = this.roomViews[8];
                        if (this.roomViews[5] != null) {
                            this.roomViews[5].SetPosition(this.roomViewsPos[5]);
                            this.roomViews[5].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
                            this.roomViewsLoaded[5] = true;
                        } else {
                            this.roomViewsLoaded[5] = false;
                        }
                        this.roomViews[6] = this.loadBottom1;
                        if (this.roomViews[6] != null) {
                            this.roomViews[6].SetPosition(this.roomViewsPos[6]);
                            this.roomViews[6].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM);
                            this.roomViewsLoaded[6] = true;
                        } else {
                            this.roomViewsLoaded[6] = false;
                        }
                        this.roomViews[7] = this.loadBottom2;
                        if (this.roomViews[7] != null) {
                            this.roomViews[7].SetPosition(this.roomViewsPos[7]);
                            this.roomViews[7].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
                            this.roomViewsLoaded[7] = true;
                        } else {
                            this.roomViewsLoaded[7] = false;
                        }
                        this.roomViews[8] = this.loadBottom3;
                        if (this.roomViews[8] != null) {
                            this.roomViews[8].SetPosition(this.roomViewsPos[8]);
                            this.roomViews[8].SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM);
                            this.roomViewsLoaded[8] = true;
                        } else {
                            this.roomViewsLoaded[8] = false;
                        }
                        if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
                        } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                        } else if (this.trv == RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM) {
                            GamePanel.PC.SetRoomViewIndex(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
                        }
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_ALL);
                        this.roomViewY -= this.roomHeight * 1;
                        this.lret = true;
                    }
                    this.loadBottom = false;
                    this.loadBottomIdx = 0;
                    this.loadBottom1 = null;
                    this.loadBottom2 = null;
                    this.loadBottom3 = null;
                }
            } else {
                this.loadLeft = false;
                this.loadLeftIdx = 0;
                this.loadLeft1 = null;
                this.loadLeft2 = null;
                this.loadLeft3 = null;
                this.loadRight = false;
                this.loadRightIdx = 0;
                this.loadRight1 = null;
                this.loadRight2 = null;
                this.loadRight3 = null;
                this.loadTop = false;
                this.loadTopIdx = 0;
                this.loadTop1 = null;
                this.loadTop2 = null;
                this.loadTop3 = null;
                this.loadBottom = false;
                this.loadBottomIdx = 0;
                this.loadBottom1 = null;
                this.loadBottom2 = null;
                this.loadBottom3 = null;
            }
            this.mirrorRooms[0] = -1;
            this.mirrorRooms[1] = -1;
            this.mirrorRooms[2] = -1;
            this.mirrorRooms[3] = -1;
            this.mirrorRooms[4] = -1;
            this.mirrorRooms[5] = -1;
            this.mirrorRooms[6] = -1;
            this.mirrorRooms[7] = -1;
            this.mirrorRooms[8] = -1;
            this.mc = 0;
            GamePanel.VAR2 = "";
            this.tti = 0;
            while (this.tti < this.ttlen) {
                if (this.roomViews[this.tti] != null && this.roomViews[this.tti].MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                    this.lret = true;
                    if (this.roomViews[this.tti].IsMirrorPc()) {
                        GamePanel.VAR2 = GamePanel.VAR2 + this.tti + ", ";
                    }
                    if (this.roomViews[this.tti].IsMirrorPc()) {
                        this.mirrorRooms[this.mc] = this.tti;
                        ++this.mc;
                    } else {
                        if (this.roomViews[this.tti].HasPc()) {
                            this.pcRoomView = this.roomViews[this.tti];
                        }
                        if (this.tti == 0) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP);
                        } else if (this.tti == 1) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
                        } else if (this.tti == 2) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP);
                        } else if (this.tti == 3) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
                        } else if (this.tti == 4) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                        } else if (this.tti == 5) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
                        } else if (this.tti == 6) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM);
                        } else if (this.tti == 7) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
                        } else if (this.tti == 8) {
                            this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM);
                        }
                    }
                }
                ++this.tti;
            }
            this.trv = GamePanel.PC.GetRoomViewIndex();
            this.trvi = this.trv.getValue();
            this.pcR = this.roomViews[this.trvi];
            if (this.pcX > this.TW && this.pcX + this.pcW < this.roomWidth - this.TW && this.pcY > this.TH && this.pcY + this.pcH < this.roomHeight - this.TH) {
                this.tmp = "CENTER MIDDLE ";
                if (!GamePanel.PC.HasReachedRoomCenter() && this.GetMainGameScreen().GetCurrentState() == ScreenMainGame.ScreenMainGameState.OVERWORLD_VIEW) {
                    GamePanel.PC.SetReachedRoomCenter(true);
                    if (!DatConstants.IsBadIndex(this.GetPcRoomView().GetStringIndex())) {
                        this.mainGameScreen.GetOverworldViewRoomText().SetRoomText(ResourceContainer.strings[this.GetPcRoomView().GetStringIndex()]);
                        TyreDatGameUtils.wr("Found room message: " + ResourceContainer.strings[this.GetPcRoomView().GetStringIndex()]);
                        this.mainGameScreen.ChangeState(ScreenMainGame.ScreenMainGameState.OVERWORLD_VIEW_ACTION_ROOM_TEXT_ANIMATE_IN);
                    }
                }
                if (this.roomViews[0] != null) {
                    this.roomViews[0].SetMirrorPc(false);
                }
                if (this.roomViews[1] != null) {
                    this.roomViews[1].SetMirrorPc(false);
                }
                if (this.roomViews[2] != null) {
                    this.roomViews[2].SetMirrorPc(false);
                }
                if (this.roomViews[3] != null) {
                    this.roomViews[3].SetMirrorPc(false);
                }
                if (this.roomViews[4] != null) {
                    this.roomViews[4].SetMirrorPc(false);
                }
                if (this.roomViews[5] != null) {
                    this.roomViews[5].SetMirrorPc(false);
                }
                if (this.roomViews[6] != null) {
                    this.roomViews[6].SetMirrorPc(false);
                }
                if (this.roomViews[7] != null) {
                    this.roomViews[7].SetMirrorPc(false);
                }
                if (this.roomViews[8] != null) {
                    this.roomViews[8].SetMirrorPc(false);
                }
            } else if (this.pcX >= this.TW && this.pcX + this.pcW <= this.roomWidth - this.TW && this.pcY <= this.TH && this.pcY >= -this.THE) {
                this.tmp = "CENTER TOP ";
                if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK && this.pcR.HasLinkTop()) {
                    this.tbrv = this.GetBackRoomViewIndex(this.trv);
                    this.tbrvi = this.tbrv.getValue();
                    if (this.tbrvi != -1) {
                        this.roomViews[this.tbrvi].SetMirrorPc(true);
                        this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetCenterTop);
                    }
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.trv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.tlrv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trrv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.tlrv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trrv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
            } else if (this.pcX > this.TW && this.pcX + this.pcW < this.roomWidth - this.TW && this.pcY > -(this.THE * 2) && this.pcY < -this.THE) {
                this.tmp = "CENTER TOP EXIT ";
                if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK && this.pcR.HasLinkTop()) {
                    this.tbrv = this.GetBackRoomViewIndex(this.trv);
                    this.tbrvi = this.tbrv.getValue();
                    if (this.tbrvi != -1) {
                        this.roomViews[this.tbrvi].SetMirrorPc(false);
                        GamePanel.PC.SetRoomViewIndex(this.tbrv);
                        GamePanel.PC.SetReachedRoomCenter(false);
                        GamePanel.PC.SetY(this.pcY + this.roomHeight);
                        this.roomViews[this.trvi].SetMirrorPc(true);
                        this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetCenterBottom);
                    }
                }
            } else if (this.pcX >= this.TW && this.pcX + this.pcW <= this.roomWidth - this.TW && this.pcY + this.pcH >= this.roomHeight - this.TH && this.pcY + this.pcH <= this.roomHeight + this.THE) {
                this.tmp = "CENTER BOTTOM ";
                if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT && this.pcR.HasLinkBottom()) {
                    this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                    this.tfrvi = this.tfrv.getValue();
                    if (this.tfrvi != -1) {
                        this.roomViews[this.tfrvi].SetMirrorPc(true);
                        this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetCenterBottom);
                    }
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.trv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.tlrv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trrv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.tlrv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trrv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
            } else if (this.pcX > this.TW && this.pcX + this.pcW < this.roomWidth - this.TW && this.pcY + this.pcH < this.roomHeight + this.THE * 2 && this.pcY + this.pcH > this.roomHeight + this.THE) {
                this.tmp = "CENTER BOTTOM EXIT ";
                if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT && this.pcR.HasLinkBottom()) {
                    this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                    this.tfrvi = this.tfrv.getValue();
                    if (this.tfrvi != -1) {
                        this.roomViews[this.tfrvi].SetMirrorPc(false);
                        GamePanel.PC.SetRoomViewIndex(this.tfrv);
                        GamePanel.PC.SetReachedRoomCenter(false);
                        GamePanel.PC.SetY(this.pcY - this.roomHeight);
                        this.roomViews[this.trvi].SetMirrorPc(true);
                        this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetCenterTop);
                    }
                }
            } else if (this.pcX <= this.TW && this.pcX >= -this.TWE && this.pcY >= this.TH && this.pcY + this.pcH <= this.roomHeight - this.TH) {
                this.tmp = "LEFT MIDDLE ";
                if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT && this.pcR.HasLinkLeft()) {
                    this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                    this.tlrvi = this.tlrv.getValue();
                    if (this.tlrvi != -1) {
                        this.roomViews[this.tlrvi].SetMirrorPc(true);
                        this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                    }
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.trv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
            } else if (this.pcX > -(this.TWE * 2) && this.pcX < -this.TWE && this.pcY > this.TH && this.pcY + this.pcH < this.roomHeight - this.TH) {
                this.tmp = "LEFT MIDDLE EXIT ";
                if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT && this.pcR.HasLinkLeft()) {
                    this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                    this.tlrvi = this.tlrv.getValue();
                    if (this.tlrvi != -1) {
                        this.roomViews[this.tlrvi].SetMirrorPc(false);
                        GamePanel.PC.SetRoomViewIndex(this.tlrv);
                        GamePanel.PC.SetReachedRoomCenter(false);
                        GamePanel.PC.SetX(this.pcX + this.roomWidth);
                        this.roomViews[this.trvi].SetMirrorPc(true);
                        this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetRightMiddle);
                    }
                }
            } else if (this.pcX + this.pcW >= this.roomWidth - this.TW && this.pcX + this.pcW <= this.roomWidth + this.TWE && this.pcY >= this.TH && this.pcY + this.pcH <= this.roomHeight - this.TH) {
                this.tmp = "RIGHT MIDDLE ";
                if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT && this.pcR.HasLinkRight()) {
                    this.trrv = this.GetRightRoomViewIndex(this.trv);
                    this.trrvi = this.trrv.getValue();
                    if (this.trrvi != -1) {
                        this.roomViews[this.trrvi].SetMirrorPc(true);
                        this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetRightMiddle);
                    }
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
            } else if (this.pcX + this.pcW > this.roomWidth + this.TWE && this.pcX + this.pcW < this.roomWidth + this.TWE * 2 && this.pcY > this.TH && this.pcY + this.pcH < this.roomHeight - this.TH) {
                this.tmp = "RIGHT MIDDLE EXIT ";
                if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT && this.pcR.HasLinkRight()) {
                    this.trrv = this.GetRightRoomViewIndex(this.trv);
                    this.trrvi = this.trrv.getValue();
                    if (this.trrvi != -1) {
                        this.roomViews[this.trrvi].SetMirrorPc(false);
                        GamePanel.PC.SetRoomViewIndex(this.trrv);
                        GamePanel.PC.SetReachedRoomCenter(false);
                        GamePanel.PC.SetX(this.pcX - this.roomWidth);
                        this.roomViews[this.trvi].SetMirrorPc(true);
                        this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                    }
                }
            } else if (this.pcX <= this.TW && this.pcX >= -this.TWE && this.pcY <= this.TH && this.pcY >= -this.THE) {
                this.tmp = "LEFT TOP ";
                if (this.pcR.HasLinkLeft() || this.pcR.HasLinkTop()) {
                    this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                    this.tlrvi = this.tlrv.getValue();
                    if (this.tlrvi != -1) {
                        this.roomViews[this.tlrvi].SetMirrorPc(true);
                        this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                    }
                    this.tbrv = this.GetBackRoomViewIndex(this.tlrv);
                    this.tbrvi = this.tbrv.getValue();
                    if (this.tbrvi != -1) {
                        this.roomViews[this.tbrvi].SetMirrorPc(true);
                        this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetTopLeftDiag);
                    }
                    this.tbrv = this.GetBackRoomViewIndex(this.trv);
                    this.tbrvi = this.tbrv.getValue();
                    if (this.tbrvi != -1) {
                        this.roomViews[this.tbrvi].SetMirrorPc(true);
                        this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetCenterTop);
                    }
                    this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                    this.tlrvi = this.tlrv.getValue();
                    if (this.tlrvi != -1) {
                        this.roomViews[this.tlrvi].SetMirrorPc(true);
                        this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetTopLeftDiag);
                    }
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    // empty if block
                }
                this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    // empty if block
                }
                this.trrv = this.GetRightRoomViewIndex(this.trv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    // empty if block
                }
            } else if (this.pcX > -(this.TWE * 2) && this.pcX < this.TW && this.pcY < this.TH && this.pcY > -(this.THE * 2)) {
                if (this.pcX > -(this.TWE * 2) && this.pcX < -this.TWE && this.pcY < this.TH && this.pcY > -(this.THE * 2)) {
                    this.tmp = "LEFT TOP EXIT 1 ";
                    if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT && this.pcR.HasLinkLeft()) {
                        this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                        this.tlrvi = this.tlrv.getValue();
                        if (this.tlrvi != -1) {
                            this.roomViews[this.tlrvi].SetMirrorPc(false);
                            GamePanel.PC.SetRoomViewIndex(this.tlrv);
                            GamePanel.PC.SetReachedRoomCenter(false);
                            GamePanel.PC.SetX(this.pcX + this.roomWidth);
                            this.roomViews[this.trvi].SetMirrorPc(true);
                            this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetRightMiddle);
                        }
                        this.tbrv = this.GetBackRoomViewIndex(this.tlrv);
                        this.tbrvi = this.tbrv.getValue();
                        if (this.tbrvi != -1) {
                            this.roomViews[this.tbrvi].SetMirrorPc(true);
                            this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetCenterTop);
                        }
                        this.tbrv = this.GetBackRoomViewIndex(this.trv);
                        this.tbrvi = this.tbrv.getValue();
                        if (this.tbrvi != -1) {
                            this.roomViews[this.tbrvi].SetMirrorPc(true);
                            this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetTopRightDiag);
                        }
                        this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                        this.tlrvi = this.tlrv.getValue();
                        if (this.tlrvi != -1) {
                            this.roomViews[this.tlrvi].SetMirrorPc(true);
                            this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetCenterTop);
                        }
                    }
                } else if (this.pcX > -(this.TWE * 2) && this.pcX < this.TW && this.pcY < -this.THE && this.pcY > -(this.THE * 2)) {
                    this.tmp = "LEFT TOP EXIT 3 ";
                    if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK && this.pcR.HasLinkTop()) {
                        this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                        this.tlrvi = this.tlrv.getValue();
                        if (this.tlrvi != -1) {
                            this.roomViews[this.tlrvi].SetMirrorPc(true);
                            this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetBottomLeftDiag);
                        }
                        this.tbrv = this.GetBackRoomViewIndex(this.tlrv);
                        this.tbrvi = this.tbrv.getValue();
                        if (this.tbrvi != -1) {
                            this.roomViews[this.tbrvi].SetMirrorPc(true);
                            this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                        }
                        this.tbrv = this.GetBackRoomViewIndex(this.trv);
                        this.tbrvi = this.tbrv.getValue();
                        if (this.tbrvi != -1) {
                            this.roomViews[this.tbrvi].SetMirrorPc(false);
                            GamePanel.PC.SetRoomViewIndex(this.tbrv);
                            GamePanel.PC.SetReachedRoomCenter(false);
                            GamePanel.PC.SetY(this.pcY + this.roomHeight);
                            this.roomViews[this.trvi].SetMirrorPc(true);
                            this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetCenterBottom);
                        }
                        this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                        this.tlrvi = this.tlrv.getValue();
                        if (this.tlrvi != -1) {
                            this.roomViews[this.tlrvi].SetMirrorPc(true);
                            this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                        }
                    }
                }
            } else if (this.pcX <= this.TW && this.pcX >= -this.TWE && this.pcY + this.pcH >= this.roomHeight - this.TH && this.pcY + this.pcH <= this.roomHeight + this.THE) {
                this.tmp = "LEFT BOTTOM ";
                if (this.pcR.HasLinkLeft() || this.pcR.HasLinkBottom()) {
                    this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                    this.tlrvi = this.tlrv.getValue();
                    if (this.tlrvi != -1) {
                        this.roomViews[this.tlrvi].SetMirrorPc(true);
                        this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                    }
                    this.tfrv = this.GetFrontRoomViewIndex(this.tlrv);
                    this.tfrvi = this.tfrv.getValue();
                    if (this.tfrvi != -1) {
                        this.roomViews[this.tfrvi].SetMirrorPc(true);
                        this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetBottomLeftDiag);
                    }
                    this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                    this.tfrvi = this.tfrv.getValue();
                    if (this.tfrvi != -1) {
                        this.roomViews[this.tfrvi].SetMirrorPc(true);
                        this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetCenterBottom);
                    }
                    this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                    this.tlrvi = this.tlrv.getValue();
                    if (this.tlrvi != -1) {
                        this.roomViews[this.tlrvi].SetMirrorPc(true);
                        this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetBottomLeftDiag);
                    }
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    // empty if block
                }
                this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    // empty if block
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.trv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    // empty if block
                }
            } else if (this.pcX > -(this.TWE * 2) && this.pcX < this.TW && this.pcY + this.pcH > this.roomHeight - this.TH && this.pcY + this.pcH < this.roomHeight + this.THE * 2) {
                if (this.pcX > -(this.TWE * 2) && this.pcX < -this.TWE && this.pcY + this.pcH > this.roomHeight - this.TH && this.pcY + this.pcH < this.roomHeight + this.THE) {
                    this.tmp = "LEFT BOTTOM EXIT 1 ";
                    if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT && this.pcR.HasLinkLeft()) {
                        this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                        this.tlrvi = this.tlrv.getValue();
                        if (this.tlrvi != -1) {
                            this.roomViews[this.tlrvi].SetMirrorPc(false);
                            GamePanel.PC.SetRoomViewIndex(this.tlrv);
                            GamePanel.PC.SetReachedRoomCenter(false);
                            GamePanel.PC.SetX(this.pcX + this.roomWidth);
                            this.roomViews[this.trvi].SetMirrorPc(true);
                            this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetRightMiddle);
                        }
                        this.tfrv = this.GetFrontRoomViewIndex(this.tlrv);
                        this.tfrvi = this.tfrv.getValue();
                        if (this.tfrvi != -1) {
                            this.roomViews[this.tfrvi].SetMirrorPc(true);
                            this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetCenterBottom);
                        }
                        this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                        this.tfrvi = this.tfrv.getValue();
                        if (this.tfrvi != -1) {
                            this.roomViews[this.tfrvi].SetMirrorPc(true);
                            this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetBottomRightDiag);
                        }
                        this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                        this.tlrvi = this.tlrv.getValue();
                        if (this.tlrvi != -1) {
                            this.roomViews[this.tlrvi].SetMirrorPc(true);
                            this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetCenterBottom);
                        }
                    }
                } else if (this.pcX > -(this.TWE * 2) && this.pcX < this.TW && this.pcY + this.pcH > this.roomHeight + this.THE && this.pcY + this.pcH < this.roomHeight + this.THE * 2) {
                    this.tmp = "LEFT BOTTOM EXIT 3 ";
                    if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT && this.pcR.HasLinkBottom()) {
                        this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                        this.tlrvi = this.tlrv.getValue();
                        if (this.tlrvi != -1) {
                            this.roomViews[this.tlrvi].SetMirrorPc(true);
                            this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetTopRightDiag);
                        }
                        this.tfrv = this.GetFrontRoomViewIndex(this.tlrv);
                        this.tfrvi = this.tfrv.getValue();
                        if (this.tfrvi != -1) {
                            this.roomViews[this.tfrvi].SetMirrorPc(true);
                            this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                        }
                        this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                        this.tfrvi = this.tfrv.getValue();
                        if (this.tfrvi != -1) {
                            this.roomViews[this.tfrvi].SetMirrorPc(false);
                            GamePanel.PC.SetRoomViewIndex(this.tfrv);
                            GamePanel.PC.SetReachedRoomCenter(false);
                            GamePanel.PC.SetY(this.pcY - this.roomHeight);
                            this.roomViews[this.trvi].SetMirrorPc(true);
                            this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetCenterTop);
                        }
                        this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                        this.tlrvi = this.tlrv.getValue();
                        if (this.tlrvi != -1) {
                            this.roomViews[this.tlrvi].SetMirrorPc(true);
                            this.roomViews[this.tlrvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                        }
                    }
                }
            } else if (this.pcX + this.pcW >= this.roomWidth - this.TW && this.pcX + this.pcW <= this.roomWidth + this.TWE && this.pcY <= this.TH && this.pcY >= -this.THE) {
                this.tmp = "RIGHT TOP ";
                if (this.pcR.HasLinkRight() || this.pcR.HasLinkTop()) {
                    this.trrv = this.GetRightRoomViewIndex(this.trv);
                    this.trrvi = this.trrv.getValue();
                    if (this.trrvi != -1) {
                        this.roomViews[this.trrvi].SetMirrorPc(true);
                        this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetRightMiddle);
                    }
                    this.tbrv = this.GetBackRoomViewIndex(this.trrv);
                    this.tbrvi = this.tbrv.getValue();
                    if (this.tbrvi != -1) {
                        this.roomViews[this.tbrvi].SetMirrorPc(true);
                        this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetTopRightDiag);
                    }
                    this.tbrv = this.GetBackRoomViewIndex(this.trv);
                    this.tbrvi = this.tbrv.getValue();
                    if (this.tbrvi != -1) {
                        this.roomViews[this.tbrvi].SetMirrorPc(true);
                        this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetCenterTop);
                    }
                    this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                    this.trrvi = this.trrv.getValue();
                    if (this.trrvi != -1) {
                        this.roomViews[this.trrvi].SetMirrorPc(true);
                        this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetTopRightDiag);
                    }
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    this.roomViews[this.tfrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    // empty if block
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    // empty if block
                }
                this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    // empty if block
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.trv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    // empty if block
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
            } else if (this.pcX + this.pcW > this.roomWidth - this.TW && this.pcX + this.pcW < this.roomWidth + this.TWE * 2 && this.pcY < this.TH && this.pcY > -(this.THE * 2)) {
                if (this.pcX + this.pcW > this.roomWidth + this.TWE && this.pcX + this.pcW < this.roomWidth + this.TWE * 2 && this.pcY < this.TH && this.pcY > -(this.THE * 2)) {
                    this.tmp = "RIGHT TOP EXIT 1 ";
                    if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT && this.pcR.HasLinkRight()) {
                        this.trrv = this.GetRightRoomViewIndex(this.trv);
                        this.trrvi = this.trrv.getValue();
                        if (this.trrvi != -1) {
                            this.roomViews[this.trrvi].SetMirrorPc(false);
                            GamePanel.PC.SetRoomViewIndex(this.trrv);
                            GamePanel.PC.SetReachedRoomCenter(false);
                            GamePanel.PC.SetX(this.pcX - this.roomWidth);
                            this.roomViews[this.trvi].SetMirrorPc(true);
                            this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                        }
                        this.tbrv = this.GetBackRoomViewIndex(this.trrv);
                        this.tbrvi = this.tbrv.getValue();
                        if (this.tbrvi != -1) {
                            this.roomViews[this.tbrvi].SetMirrorPc(true);
                            this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetCenterTop);
                        }
                        this.tbrv = this.GetBackRoomViewIndex(this.trv);
                        this.tbrvi = this.tbrv.getValue();
                        if (this.tbrvi != -1) {
                            this.roomViews[this.tbrvi].SetMirrorPc(true);
                            this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetTopLeftDiag);
                        }
                        this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                        this.trrvi = this.trrv.getValue();
                        if (this.trrvi != -1) {
                            this.roomViews[this.trrvi].SetMirrorPc(true);
                            this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetCenterTop);
                        }
                    }
                } else if (this.pcX + this.pcW > this.roomWidth - this.TW && this.pcX + this.pcW < this.roomWidth + this.TWE * 2 && this.pcY < -this.THE && this.pcY > -(this.THE * 2)) {
                    this.tmp = "RIGHT TOP EXIT 3 ";
                    if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK && this.pcR.HasLinkTop()) {
                        this.trrv = this.GetRightRoomViewIndex(this.trv);
                        this.trrvi = this.trrv.getValue();
                        if (this.trrvi != -1) {
                            this.roomViews[this.trrvi].SetMirrorPc(true);
                            this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetBottomRightDiag);
                        }
                        this.tbrv = this.GetBackRoomViewIndex(this.trrv);
                        this.tbrvi = this.tbrv.getValue();
                        if (this.tbrvi != -1) {
                            this.roomViews[this.tbrvi].SetMirrorPc(true);
                            this.roomViews[this.tbrvi].SetMirrorPcOffset(this.offsetRightMiddle);
                        }
                        this.tbrv = this.GetBackRoomViewIndex(this.trv);
                        this.tbrvi = this.tbrv.getValue();
                        if (this.tbrvi != -1) {
                            this.roomViews[this.tbrvi].SetMirrorPc(false);
                            GamePanel.PC.SetRoomViewIndex(this.tbrv);
                            GamePanel.PC.SetReachedRoomCenter(false);
                            GamePanel.PC.SetY(this.pcY + this.roomHeight);
                            this.roomViews[this.trvi].SetMirrorPc(true);
                            this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetCenterBottom);
                        }
                        this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                        this.trrvi = this.trrv.getValue();
                        if (this.trrvi != -1) {
                            this.roomViews[this.trrvi].SetMirrorPc(true);
                            this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetRightMiddle);
                        }
                    }
                }
            } else if (this.pcX + this.pcW >= this.roomWidth - this.TW && this.pcX + this.pcW <= this.roomWidth + this.TWE && this.pcY + this.pcH >= this.roomHeight - this.TH && this.pcY + this.pcH <= this.roomHeight + this.THE) {
                this.tmp = "RIGHT BOTTOM ";
                if (this.pcR.HasLinkRight() || this.pcR.HasLinkBottom()) {
                    this.trrv = this.GetRightRoomViewIndex(this.trv);
                    this.trrvi = this.trrv.getValue();
                    if (this.trrvi != -1) {
                        this.roomViews[this.trrvi].SetMirrorPc(true);
                        this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetRightMiddle);
                    }
                    this.tfrv = this.GetFrontRoomViewIndex(this.trrv);
                    this.tfrvi = this.tfrv.getValue();
                    if (this.tfrvi != -1) {
                        this.roomViews[this.tfrvi].SetMirrorPc(true);
                        this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetBottomRightDiag);
                    }
                    this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                    this.tfrvi = this.tfrv.getValue();
                    if (this.tfrvi != -1) {
                        this.roomViews[this.tfrvi].SetMirrorPc(true);
                        this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetCenterBottom);
                    }
                    this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                    this.trrvi = this.trrv.getValue();
                    if (this.trrvi != -1) {
                        this.roomViews[this.trrvi].SetMirrorPc(true);
                        this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetBottomRightDiag);
                    }
                }
                this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                this.tfrvi = this.tfrv.getValue();
                if (this.tfrvi != -1) {
                    // empty if block
                }
                this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    // empty if block
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tfrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.tbrv = this.GetBackRoomViewIndex(this.trv);
                this.tbrvi = this.tbrv.getValue();
                if (this.tbrvi != -1) {
                    this.roomViews[this.tbrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.tbrv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    this.roomViews[this.trrvi].SetMirrorPc(false);
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.tbrv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
                this.trrv = this.GetRightRoomViewIndex(this.trv);
                this.trrvi = this.trrv.getValue();
                if (this.trrvi != -1) {
                    // empty if block
                }
                this.tlrv = this.GetLeftRoomViewIndex(this.trv);
                this.tlrvi = this.tlrv.getValue();
                if (this.tlrvi != -1) {
                    this.roomViews[this.tlrvi].SetMirrorPc(false);
                }
            } else if (this.pcX + this.pcW > this.roomWidth - this.TW && this.pcX + this.pcW < this.roomWidth + this.TWE * 2 && this.pcY + this.pcH > this.roomHeight - this.TH && this.pcY + this.pcH < this.roomHeight + this.THE * 2) {
                if (this.pcX + this.pcW > this.roomWidth + this.TWE && this.pcX + this.pcW < this.roomWidth + this.TWE * 2 && this.pcY + this.pcH > this.roomHeight - this.TH && this.pcY + this.pcH < this.roomHeight + this.THE * 2) {
                    this.tmp = "RIGHT BOTTOM EXIT 1 ";
                    if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT && this.pcR.HasLinkRight()) {
                        this.trrv = this.GetRightRoomViewIndex(this.trv);
                        this.trrvi = this.trrv.getValue();
                        if (this.trrvi != -1) {
                            this.roomViews[this.trrvi].SetMirrorPc(false);
                            GamePanel.PC.SetRoomViewIndex(this.trrv);
                            GamePanel.PC.SetReachedRoomCenter(false);
                            GamePanel.PC.SetX(this.pcX - this.roomWidth);
                            this.roomViews[this.trvi].SetMirrorPc(true);
                            this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetLeftMiddle);
                        }
                        this.tfrv = this.GetFrontRoomViewIndex(this.trrv);
                        this.tfrvi = this.tfrv.getValue();
                        if (this.tfrvi != -1) {
                            this.roomViews[this.tfrvi].SetMirrorPc(true);
                            this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetCenterBottom);
                        }
                        this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                        this.tfrvi = this.tfrv.getValue();
                        if (this.tfrvi != -1) {
                            this.roomViews[this.tfrvi].SetMirrorPc(true);
                            this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetBottomLeftDiag);
                        }
                        this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                        this.trrvi = this.trrv.getValue();
                        if (this.trrvi != -1) {
                            this.roomViews[this.trrvi].SetMirrorPc(true);
                            this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetCenterBottom);
                        }
                    }
                } else if (this.pcX + this.pcW > this.roomWidth - this.TW && this.pcX + this.pcW < this.roomWidth + this.TWE * 2 && this.pcY + this.pcH > this.roomHeight + this.THE && this.pcY + this.pcH < this.roomHeight + this.THE * 2) {
                    this.tmp = "RIGHT BOTTOM EXIT 3 ";
                    if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT && this.pcR.HasLinkBottom()) {
                        this.trrv = this.GetRightRoomViewIndex(this.trv);
                        this.trrvi = this.trrv.getValue();
                        if (this.trrvi != -1) {
                            this.roomViews[this.trrvi].SetMirrorPc(true);
                            this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetTopRightDiag);
                        }
                        this.tfrv = this.GetFrontRoomViewIndex(this.trrv);
                        this.tfrvi = this.tfrv.getValue();
                        if (this.tfrvi != -1) {
                            this.roomViews[this.tfrvi].SetMirrorPc(true);
                            this.roomViews[this.tfrvi].SetMirrorPcOffset(this.offsetRightMiddle);
                        }
                        this.tfrv = this.GetFrontRoomViewIndex(this.trv);
                        this.tfrvi = this.tfrv.getValue();
                        if (this.tfrvi != -1) {
                            this.roomViews[this.tfrvi].SetMirrorPc(false);
                            GamePanel.PC.SetRoomViewIndex(this.tfrv);
                            GamePanel.PC.SetReachedRoomCenter(false);
                            GamePanel.PC.SetY(this.pcY - this.roomHeight);
                            this.roomViews[this.trvi].SetMirrorPc(true);
                            this.roomViews[this.trvi].SetMirrorPcOffset(this.offsetCenterTop);
                        }
                        this.trrv = this.GetRightRoomViewIndex(this.tfrv);
                        this.trrvi = this.trrv.getValue();
                        if (this.trrvi != -1) {
                            this.roomViews[this.trrvi].SetMirrorPc(true);
                            this.roomViews[this.trrvi].SetMirrorPcOffset(this.offsetTopRightDiag);
                        }
                    }
                }
            }
            GamePanel.VAR1 = this.tmp + " PosX: " + this.pcX + " PosY: " + this.pcY;
            GamePanel.VAR2 = GamePanel.VAR2 + " RVI: " + (Object)((Object)GamePanel.PC.GetRoomViewIndex()) + " HRC: " + GamePanel.PC.HasReachedRoomCenter();
            this.mc = 0;
            while (this.mirrorRooms[this.mc] != -1) {
                this.tti = this.mirrorRooms[this.mc];
                if (this.roomViews[this.tti] != null && (this.roomViews[this.tti].IsMirrorPc() || this.roomViews[this.tti].HasPc())) {
                    this.roomViews[this.tti].MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame);
                    if (this.tti == 0) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_TOP);
                    } else if (this.tti == 1) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_TOP);
                    } else if (this.tti == 2) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_TOP);
                    } else if (this.tti == 3) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_MIDDLE);
                    } else if (this.tti == 4) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
                    } else if (this.tti == 5) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_MIDDLE);
                    } else if (this.tti == 6) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_LEFT_BOTTOM);
                    } else if (this.tti == 7) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_CENTER_BOTTOM);
                    } else if (this.tti == 8) {
                        this.DrawScreen(RoomViewIndex.ROOM_VIEW_INDEX_RIGHT_BOTTOM);
                    }
                }
                ++this.mc;
            }
            if (this.lret) {
                this.DrawMenu();
            }
        }
        if (this.drawOneFrame) {
            this.drawOneFrame = false;
            this.SetPaused(true);
        }
        return this.lret;
    }

    public static enum RoomViewIndex {
        ROOM_VIEW_INDEX_LEFT_TOP(0),
        ROOM_VIEW_INDEX_CENTER_TOP(1),
        ROOM_VIEW_INDEX_RIGHT_TOP(2),
        ROOM_VIEW_INDEX_LEFT_MIDDLE(3),
        ROOM_VIEW_INDEX_CENTER_MIDDLE(4),
        ROOM_VIEW_INDEX_RIGHT_MIDDLE(5),
        ROOM_VIEW_INDEX_LEFT_BOTTOM(6),
        ROOM_VIEW_INDEX_CENTER_BOTTOM(7),
        ROOM_VIEW_INDEX_RIGHT_BOTTOM(8),
        ROOM_VIEW_INDEX_NONE(-1),
        ROOM_VIEW_INDEX_ALL(-2);

        private final int id;

        private RoomViewIndex(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }
}

