/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreLinkTable;
import com.middlemindgames.TyreObjects.TyreNpc;
import com.middlemindgames.TyreObjects.TyreObjectSet;
import com.middlemindgames.dat.MmgObject;
import com.middlemindgames.dat.ResourceContainer;
import com.middlemindgames.dat.Search;
import java.awt.Color;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreObject
extends MmgObj {
    private MmgObject datObj;
    private boolean ready;
    private MmgBmp img;
    private TyreNpc tNpc;
    private TyreObjectSet tOs;
    private String imgId;
    private boolean pcFake;
    private MmgRect tr1a;
    private MmgRect tr2a;
    private MmgRect tr1b;
    private MmgRect tr2b;
    private MmgRect tr1c;
    private MmgRect tr2c;
    private MmgRect tr1d;
    private MmgRect tr2d;
    private MmgRect tr1e;
    private MmgRect tr2e;
    private MmgRect tr1f;
    private MmgRect tr2f;
    private MmgRect tr1pd;
    private MmgRect tr2pd;
    private boolean lret;
    private Color dc;
    private int vertOffset;
    private TyreLinkTable owner;
    private boolean altImage;
    private int altImageIndex;
    private boolean pause = false;

    public static TyreObject GetPcPlaceHolder() {
        TyreObject ret = new TyreObject(true, null);
        ret.SetIsVisible(false);
        return ret;
    }

    public TyreObject(boolean b, TyreLinkTable o) {
        this.owner = o;
        this.pcFake = b;
        this.datObj = null;
        this.ready = false;
        this.img = null;
        this.tNpc = null;
        this.tOs = null;
        this.imgId = null;
    }

    public TyreObject(MmgObject t, TyreLinkTable o) {
        this.owner = o;
        this.pcFake = false;
        this.SetDatObj(t);
        this.img = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreObject(MmgObject t, MmgBmp lImg, TyreLinkTable o) {
        this.owner = o;
        this.pcFake = false;
        this.SetDatObj(t);
        this.ready = false;
        this.LoadResources();
        this.img = lImg;
    }

    public final int GetAngle() {
        return this.datObj.angle;
    }

    public final int GetBattleIndex() {
        return this.datObj.battleIndex;
    }

    public final int GetCharIndex() {
        return this.datObj.charIndex;
    }

    public final int GetConversationIndex() {
        return this.datObj.conversationIndex;
    }

    public final int GetDestDir() {
        return this.datObj.destDir;
    }

    public final int GetDestPosX() {
        return this.datObj.destPosX;
    }

    public final int GetDestPosY() {
        return this.datObj.destPosY;
    }

    public final int GetEnemyIndex() {
        return this.datObj.enemyIndex;
    }

    public final int GetFlagDir() {
        return this.datObj.flagDir;
    }

    public final int GetFlagIndex() {
        return this.datObj.flagIndex;
    }

    public final int GetDatHeight() {
        return this.datObj.height;
    }

    public final int GetImageIndex() {
        return this.datObj.imageIndex;
    }

    public final int GetLinkTo() {
        return this.datObj.linkTo;
    }

    public final int GetNpcIndex() {
        return this.datObj.npcIndex;
    }

    public final TyreNpc GetNpc() {
        return this.tNpc;
    }

    public final int GetObjectSetsIndex() {
        return this.datObj.objectSetsIndex;
    }

    public final int GetPosX() {
        return this.datObj.posX;
    }

    public final int GetPosY() {
        return this.datObj.posY;
    }

    public final int GetSearchItem() {
        return this.datObj.searchItem;
    }

    public final int GetStringIndex() {
        return this.datObj.stringIndex;
    }

    public final int GetType() {
        if (this.pcFake) {
            return DatConstants.OBJECT_TYPE_PC;
        }
        return this.datObj.type;
    }

    public final int GetVertOffset() {
        return this.vertOffset;
    }

    public final int GetDatVertOffset() {
        return this.datObj.vertOffset;
    }

    public final int GetDatWidth() {
        return this.datObj.width;
    }

    public static final int GetSearchItemCount(Search srch) {
        int cnt = 0;
        if (!DatConstants.IsBadIndex(srch.item1) && srch.quantity1 > 0) {
            ++cnt;
        }
        if (!DatConstants.IsBadIndex(srch.item2) && srch.quantity2 > 0) {
            ++cnt;
        }
        if (!DatConstants.IsBadIndex(srch.item3) && srch.quantity3 > 0) {
            ++cnt;
        }
        return cnt;
    }

    public final int GetSearchItemCount() {
        if (!DatConstants.IsBadIndex(this.datObj.searchItem)) {
            Search srch = ResourceContainer.searches[this.datObj.searchItem];
            int cnt = 0;
            if (!DatConstants.IsBadIndex(srch.item1) && srch.quantity1 > 0) {
                ++cnt;
            }
            if (!DatConstants.IsBadIndex(srch.item2) && srch.quantity2 > 0) {
                ++cnt;
            }
            if (!DatConstants.IsBadIndex(srch.item3) && srch.quantity3 > 0) {
                ++cnt;
            }
            return cnt;
        }
        return 0;
    }

    public boolean IsAltImage() {
        return this.altImage;
    }

    public void SetAltImage(boolean b) {
        this.altImage = b;
    }

    public int GetAltImageIndex() {
        return this.altImageIndex;
    }

    public void SetAltImageIndex(int i) {
        this.altImageIndex = i;
    }

    public TyreLinkTable GetOwner() {
        return this.owner;
    }

    public void SetOwner(TyreLinkTable o) {
        this.owner = o;
    }

    public final CollisionResult CollidesWithPseudoDepthContained(int x, int y, int w, int h) {
        this.tr1a = this.GetType() == DatConstants.OBJECT_TYPE_NPC ? (this.tNpc != null ? this.tNpc.GetPseudoDepthCollisionRect() : new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - this.GetVertOffset()), this.GetWidth(), this.GetVertOffset())) : new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - this.GetVertOffset()), this.GetWidth(), this.GetVertOffset());
        this.tr2a = new MmgRect(x, y, y + h, x + w);
        if (this.tr1a.GetLeft() >= this.tr2a.GetLeft() && this.tr1a.GetLeft() <= this.tr2a.GetRight() || this.tr1a.GetRight() >= this.tr2a.GetLeft() && this.tr1a.GetRight() <= this.tr2a.GetRight() ? this.tr1a.GetTop() >= this.tr2a.GetTop() && this.tr1a.GetTop() <= this.tr2a.GetBottom() || this.tr1a.GetBottom() >= this.tr2a.GetTop() && this.tr1a.GetBottom() <= this.tr2a.GetBottom() : (this.tr1a.GetTop() >= this.tr2a.GetTop() && this.tr1a.GetTop() <= this.tr2a.GetBottom() || this.tr1a.GetBottom() >= this.tr2a.GetTop() && this.tr1a.GetBottom() <= this.tr2a.GetBottom()) && (this.tr1a.GetLeft() >= this.tr2a.GetLeft() && this.tr1a.GetLeft() <= this.tr2a.GetRight() || this.tr1a.GetRight() >= this.tr2a.GetLeft() && this.tr1a.GetRight() <= this.tr2a.GetRight())) {
            return new CollisionResult(new MmgVector2(0, 0), false, true);
        }
        return new CollisionResult(true);
    }

    public final CollisionResult CollidesWithPseudoDepthContains(int x, int y, int w, int h) {
        this.tr1b = this.GetType() == DatConstants.OBJECT_TYPE_NPC ? (this.tNpc != null ? this.tNpc.GetPseudoDepthCollisionRect() : new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - this.GetVertOffset()), this.GetWidth(), this.GetVertOffset())) : new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - this.GetVertOffset()), this.GetWidth(), this.GetVertOffset());
        this.tr2b = new MmgRect(x, y, y + h, x + w);
        if (this.tr2b.GetLeft() >= this.tr1b.GetLeft() && this.tr2b.GetLeft() <= this.tr1b.GetRight() || this.tr2b.GetRight() >= this.tr1b.GetLeft() && this.tr2b.GetRight() <= this.tr1b.GetRight() ? this.tr2b.GetTop() >= this.tr1b.GetTop() && this.tr2b.GetTop() <= this.tr1b.GetBottom() || this.tr2b.GetBottom() >= this.tr1b.GetTop() && this.tr2b.GetBottom() <= this.tr1b.GetBottom() : (this.tr2b.GetTop() >= this.tr1b.GetTop() && this.tr2b.GetTop() <= this.tr1b.GetBottom() || this.tr2b.GetBottom() >= this.tr1b.GetTop() && this.tr2b.GetBottom() <= this.tr1b.GetBottom()) && (this.tr2b.GetLeft() >= this.tr1b.GetLeft() && this.tr2b.GetLeft() <= this.tr1b.GetRight() || this.tr2b.GetRight() >= this.tr1b.GetLeft() && this.tr2b.GetRight() <= this.tr1b.GetRight())) {
            return new CollisionResult(new MmgVector2(0, 0), false, true);
        }
        return new CollisionResult(true);
    }

    public final CollisionResult CollidesWithContained(int x, int y, int w, int h) {
        this.tr1d = this.GetType() == DatConstants.OBJECT_TYPE_NPC ? (this.tNpc != null ? this.tNpc.GetCollisionRect() : new MmgRect(this.GetPosition(), this.GetWidth(), this.GetHeight())) : new MmgRect(this.GetPosition(), this.GetWidth(), this.GetHeight());
        this.tr2d = new MmgRect(x, y, y + h, x + w);
        if (this.tr1d.GetLeft() >= this.tr2d.GetLeft() && this.tr1d.GetLeft() <= this.tr2d.GetRight() || this.tr1d.GetRight() >= this.tr2d.GetLeft() && this.tr1d.GetRight() <= this.tr2d.GetRight() ? this.tr1d.GetTop() >= this.tr2d.GetTop() && this.tr1d.GetTop() <= this.tr2d.GetBottom() || this.tr1d.GetBottom() >= this.tr2d.GetTop() && this.tr1d.GetBottom() <= this.tr2d.GetBottom() : (this.tr1d.GetTop() >= this.tr2d.GetTop() && this.tr1d.GetTop() <= this.tr2d.GetBottom() || this.tr1d.GetBottom() >= this.tr2d.GetTop() && this.tr1d.GetBottom() <= this.tr2d.GetBottom()) && (this.tr1d.GetLeft() >= this.tr2d.GetLeft() && this.tr1d.GetLeft() <= this.tr2d.GetRight() || this.tr1d.GetRight() >= this.tr2d.GetLeft() && this.tr1d.GetRight() <= this.tr2d.GetRight())) {
            return new CollisionResult(new MmgVector2(0, 0), false, true);
        }
        return new CollisionResult(true);
    }

    public final CollisionResult CollidesWithContains(int x, int y, int w, int h) {
        this.tr1e = this.GetType() == DatConstants.OBJECT_TYPE_NPC ? (this.tNpc != null ? this.tNpc.GetCollisionRect() : new MmgRect(this.GetPosition(), this.GetWidth(), this.GetHeight())) : new MmgRect(this.GetPosition(), this.GetWidth(), this.GetHeight());
        this.tr2e = new MmgRect(x, y, y + h, x + w);
        if (this.tr2e.GetLeft() >= this.tr1e.GetLeft() && this.tr2e.GetLeft() <= this.tr1e.GetRight() || this.tr2e.GetRight() >= this.tr1e.GetLeft() && this.tr2e.GetRight() <= this.tr1e.GetRight() ? this.tr2e.GetTop() >= this.tr1e.GetTop() && this.tr2e.GetTop() <= this.tr1e.GetBottom() || this.tr2e.GetBottom() >= this.tr1e.GetTop() && this.tr2e.GetBottom() <= this.tr1e.GetBottom() : (this.tr2e.GetTop() >= this.tr1e.GetTop() && this.tr2e.GetTop() <= this.tr1e.GetBottom() || this.tr2e.GetBottom() >= this.tr1e.GetTop() && this.tr2e.GetBottom() <= this.tr1e.GetBottom()) && (this.tr2e.GetLeft() >= this.tr1e.GetLeft() && this.tr2e.GetLeft() <= this.tr1e.GetRight() || this.tr2e.GetRight() >= this.tr1e.GetLeft() && this.tr2e.GetRight() <= this.tr1e.GetRight())) {
            return new CollisionResult(new MmgVector2(0, 0), false, true);
        }
        return new CollisionResult(true);
    }

    public final CollisionResult CollidesWith(int x, int y) {
        this.tr1f = this.GetType() == DatConstants.OBJECT_TYPE_NPC ? (this.tNpc != null ? this.tNpc.GetCollisionRect() : new MmgRect(this.GetPosition(), this.GetWidth(), this.GetHeight())) : new MmgRect(this.GetPosition(), this.GetWidth(), this.GetHeight());
        this.tr2f = new MmgRect(x, y, y + 1, x + 1);
        if (this.tr1f.GetLeft() <= this.tr2f.GetLeft() && this.tr2f.GetLeft() <= this.tr1f.GetRight() && this.tr1f.GetTop() <= this.tr2f.GetTop() && this.tr2f.GetTop() <= this.tr1f.GetBottom() || this.tr2f.GetLeft() <= this.tr1f.GetLeft() && this.tr1f.GetLeft() <= this.tr2f.GetRight() && this.tr2f.GetTop() <= this.tr1f.GetTop() && this.tr1f.GetTop() <= this.tr2f.GetBottom()) {
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT) {
                return new CollisionResult(new MmgVector2(this.tr2f.GetRight() - this.tr1f.GetLeft(), this.tr2f.GetTop() - this.tr1f.GetTop()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT) {
                return new CollisionResult(new MmgVector2(this.tr2f.GetLeft() - this.tr1f.GetRight(), this.tr2f.GetTop() - this.tr1f.GetTop()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK) {
                return new CollisionResult(new MmgVector2(this.tr2f.GetLeft() - this.tr1f.GetLeft(), this.tr2f.GetTop() - this.tr1f.GetBottom()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT) {
                return new CollisionResult(new MmgVector2(this.tr2f.GetLeft() - this.tr1f.GetLeft(), this.tr2f.GetBottom() - this.tr1f.GetTop()), false);
            }
        }
        return new CollisionResult(true);
    }

    public final CollisionResult CollidesWithPseudoDepth(int x, int y) {
        this.tr1pd = this.GetType() == DatConstants.OBJECT_TYPE_NPC ? (this.tNpc != null ? this.tNpc.GetPseudoDepthCollisionRect() : new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - this.GetVertOffset()), this.GetWidth(), this.GetVertOffset())) : new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - this.GetVertOffset()), this.GetWidth(), this.GetVertOffset());
        this.tr2pd = new MmgRect(x, y, y + 1, x + 1);
        if (this.tr1pd.GetLeft() <= this.tr2pd.GetLeft() && this.tr2pd.GetLeft() <= this.tr1pd.GetRight() && this.tr1pd.GetTop() <= this.tr2pd.GetTop() && this.tr2pd.GetTop() <= this.tr1pd.GetBottom() || this.tr2pd.GetLeft() <= this.tr1pd.GetLeft() && this.tr1pd.GetLeft() <= this.tr2pd.GetRight() && this.tr2pd.GetTop() <= this.tr1pd.GetTop() && this.tr1pd.GetTop() <= this.tr2pd.GetBottom()) {
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT) {
                return new CollisionResult(new MmgVector2(this.tr2pd.GetRight() - this.tr1pd.GetLeft(), this.tr2pd.GetTop() - this.tr1pd.GetTop()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT) {
                return new CollisionResult(new MmgVector2(this.tr2pd.GetLeft() - this.tr1pd.GetRight(), this.tr2pd.GetTop() - this.tr1pd.GetTop()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK) {
                return new CollisionResult(new MmgVector2(this.tr2pd.GetLeft() - this.tr1pd.GetLeft(), this.tr2pd.GetTop() - this.tr1pd.GetBottom()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT) {
                return new CollisionResult(new MmgVector2(this.tr2pd.GetLeft() - this.tr1pd.GetLeft(), this.tr2pd.GetBottom() - this.tr1pd.GetTop()), false);
            }
        }
        return new CollisionResult(true);
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final MmgObject GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(MmgObject t) {
        this.datObj = t;
        this.vertOffset = MmgHelper.ScaleValue((int)(this.datObj.vertOffset * 2));
    }

    public final String GetImageId() {
        return this.imgId;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    public final MmgRect GetPseudoDepthCollisionRect() {
        return new MmgRect(new MmgVector2(this.GetX(), this.GetY() + this.GetHeight() - this.GetVertOffset()), this.GetWidth(), this.GetVertOffset());
    }

    public final int GetPseudoDepthCollisionY() {
        if (this.datObj.type == DatConstants.OBJECT_TYPE_NPC) {
            return this.tNpc.GetPseudoDepthCollisionY();
        }
        return this.GetY() + this.GetHeight() - this.GetVertOffset();
    }

    public final MmgRect GetCollisionRect() {
        return new MmgRect(new MmgVector2(this.GetX(), this.GetY()), this.GetWidth(), this.GetHeight());
    }

    public final void LoadResources() {
        this.pause = true;
        int x = MmgHelper.ScaleValue((int)(this.GetPosX() * 2));
        int y = MmgHelper.ScaleValue((int)(this.GetPosY() * 2));
        this.SetPosition(new MmgVector2(x, y));
        if (this.datObj.type == DatConstants.OBJECT_TYPE_CAN_WALK_OVER_DYNAMIC) {
            int tmpImageIdx = GameSettings.RENDER_PLANTS_ALL_DEAD ? DatConstants.ForceDeadPlants(this.datObj.imageIndex) : (GameSettings.RENDER_PLANTS_ALL_ALIVE ? DatConstants.ForceAlivePlants(this.datObj.imageIndex) : this.datObj.imageIndex);
            this.altImage = true;
            this.altImageIndex = tmpImageIdx;
            this.imgId = GameSettings.BMP_PREFIX + tmpImageIdx + "";
            this.img = TyreDatGameUtils.GetDatCachedBmp(tmpImageIdx, this.imgId);
        } else if (this.datObj.type == DatConstants.OBJECT_TYPE_OBJECT_SET_CANT_WALK) {
            this.tOs = new TyreObjectSet(ResourceContainer.objectSets[this.GetObjectSetsIndex()], this.owner);
            this.tOs.SetPosition(this.GetPosition());
        } else if (this.datObj.type != DatConstants.OBJECT_TYPE_OBJECT_SET_ROTATION) {
            if (this.datObj.type == DatConstants.OBJECT_TYPE_OBJECT_SET) {
                this.tOs = new TyreObjectSet(ResourceContainer.objectSets[this.GetObjectSetsIndex()], this.owner);
                this.tOs.SetPosition(MmgVector2.GetOriginVec());
            } else if (this.datObj.type == DatConstants.OBJECT_TYPE_CAN_WALK_OVER_ROTATION) {
                int tmpImageIdx = GameSettings.RENDER_PLANTS_ALL_DEAD ? DatConstants.ForceDeadPlants(this.datObj.imageIndex) : (GameSettings.RENDER_PLANTS_ALL_ALIVE ? DatConstants.ForceAlivePlants(this.datObj.imageIndex) : this.datObj.imageIndex);
                this.altImage = true;
                this.altImageIndex = tmpImageIdx;
                this.imgId = GameSettings.BMP_PREFIX + tmpImageIdx + "";
                this.img = TyreDatGameUtils.GetDatCachedBmp(tmpImageIdx, this.imgId);
                this.img = MmgBmpScaler.RotateMmgBmp((MmgBmp)this.img, (int)this.GetAngle(), (boolean)true);
            } else if (this.datObj.type == DatConstants.OBJECT_TYPE_HIDDEN_ITEM) {
                if (TyreLinkTable.SHOW_HIDDEN_ITEMS) {
                    this.imgId = "red_square.png";
                    this.img = TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/red_square.png", this.imgId);
                    this.img = MmgBmpScaler.ScaleMmgBmp((MmgBmp)this.img, (double)0.5, (boolean)true);
                }
            } else if (this.datObj.type == DatConstants.OBJECT_TYPE_NPC) {
                this.tNpc = new TyreNpc(ResourceContainer.npcs[this.GetNpcIndex()], TyreLinkTable.NPC_RENDER_MODE);
                this.tNpc.SetPosition(this.GetPosition());
                this.tNpc.SetNpcRoomView(this.owner);
                if (this.tNpc.GetNpcType() == DatConstants.NPC_TYPE_TREE_FOLK) {
                    this.tNpc.SetTreeFolk(true);
                    this.tNpc.SetCurrentState(DatConstants.NPC_STATE_STILL);
                } else if (this.tNpc.GetNpcType() == DatConstants.NPC_TYPE_ANIMAL) {
                    this.tNpc.SetPiggy(true);
                }
                if (TyreLinkTable.FORCE_NPCS_STILL) {
                    this.tNpc.SetCurrentState(DatConstants.NPC_STATE_STILL);
                }
            } else if (this.datObj.type == DatConstants.OBJECT_TYPE_ENEMY) {
                if (TyreLinkTable.SHOW_HIDDEN_ENEMIES) {
                    this.imgId = "blue_square.png";
                    this.img = TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/blue_square.png", this.imgId);
                    this.img = MmgBmpScaler.ScaleMmgBmp((MmgBmp)this.img, (double)0.5, (boolean)true);
                }
            } else if (this.datObj.type == DatConstants.OBJECT_TYPE_CAN_WALK_OVER_NEGATIVE_POSITION) {
                int tmpImageIdx = GameSettings.RENDER_PLANTS_ALL_DEAD ? DatConstants.ForceDeadPlants(this.datObj.imageIndex) : (GameSettings.RENDER_PLANTS_ALL_ALIVE ? DatConstants.ForceAlivePlants(this.datObj.imageIndex) : this.datObj.imageIndex);
                this.altImage = true;
                this.altImageIndex = tmpImageIdx;
                this.imgId = GameSettings.BMP_PREFIX + tmpImageIdx + "";
                this.img = TyreDatGameUtils.GetDatCachedBmp(tmpImageIdx, this.imgId);
            } else if (this.datObj.type != DatConstants.OBJECT_TYPE_PC) {
                if (this.datObj.type == DatConstants.OBJECT_TYPE_CAN_WALK_UNDER_NEGATIVE_POSITION) {
                    int tmpImageIdx = GameSettings.RENDER_PLANTS_ALL_DEAD ? DatConstants.ForceDeadPlants(this.datObj.imageIndex) : (GameSettings.RENDER_PLANTS_ALL_ALIVE ? DatConstants.ForceAlivePlants(this.datObj.imageIndex) : this.datObj.imageIndex);
                    this.altImage = true;
                    this.altImageIndex = tmpImageIdx;
                    this.imgId = GameSettings.BMP_PREFIX + tmpImageIdx + "";
                    this.img = TyreDatGameUtils.GetDatCachedBmp(tmpImageIdx, this.imgId);
                } else if (this.datObj.type == DatConstants.OBJECT_TYPE_CANT_WALK) {
                    int tmpImageIdx = GameSettings.RENDER_PLANTS_ALL_DEAD ? DatConstants.ForceDeadPlants(this.datObj.imageIndex) : (GameSettings.RENDER_PLANTS_ALL_ALIVE ? DatConstants.ForceAlivePlants(this.datObj.imageIndex) : this.datObj.imageIndex);
                    this.altImage = true;
                    this.altImageIndex = tmpImageIdx;
                    this.imgId = GameSettings.BMP_PREFIX + tmpImageIdx + "";
                    this.img = TyreDatGameUtils.GetDatCachedBmp(tmpImageIdx, this.imgId);
                } else if (this.datObj.type == DatConstants.OBJECT_TYPE_LINK_TABLE && TyreLinkTable.SHOW_HIDDEN_LINKS) {
                    this.imgId = GameSettings.BMP_PREFIX + ResourceContainer.tiles[DatConstants.TILE_DARK_RED].imageIndex + "";
                    this.img = TyreDatGameUtils.GetDatCachedBmp(this.datObj.imageIndex, this.imgId);
                }
            }
        }
        this.ready = true;
        this.pause = false;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.img = null;
        this.imgId = null;
        this.tNpc = null;
        this.ready = false;
    }

    public final boolean IsPcFake() {
        return this.pcFake;
    }

    public final void SetPcFake(boolean b) {
        this.pcFake = b;
    }

    public final boolean IsTreeFolk() {
        if (this.GetType() == DatConstants.OBJECT_TYPE_NPC) {
            return this.tNpc.IsTreeFolk();
        }
        return false;
    }

    public final TyreObject Clone() {
        TyreObject ret = new TyreObject(this.datObj, this.owner);
        ret.SetPosition(this.GetPosition());
        ret.SetPcFake(this.IsPcFake());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            if (this.GetType() == DatConstants.OBJECT_TYPE_NPC) {
                if (this.tNpc != null) {
                    this.tNpc.MmgDraw(p);
                }
            } else if (this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET || this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET_CANT_WALK) {
                if (this.tOs != null) {
                    this.tOs.MmgDraw(p);
                }
            } else if (this.GetType() == DatConstants.OBJECT_TYPE_HIDDEN_ITEM && TyreLinkTable.SHOW_HIDDEN_ITEMS) {
                if (this.img != null) {
                    p.DrawBmp(this.img, this.GetPosition());
                }
            } else if (this.GetType() == DatConstants.OBJECT_TYPE_ENEMY && TyreLinkTable.SHOW_HIDDEN_ENEMIES) {
                if (this.img != null) {
                    p.DrawBmp(this.img, this.GetPosition());
                }
            } else if (this.GetType() == DatConstants.OBJECT_TYPE_LINK_TABLE && TyreLinkTable.SHOW_HIDDEN_LINKS) {
                if (this.img != null) {
                    p.DrawBmp(this.img, this.GetPosition());
                }
            } else if (this.GetType() == DatConstants.OBJECT_TYPE_CANT_WALK) {
                if (this.img != null) {
                    p.DrawBmp(this.img, this.GetPosition());
                }
            } else if (this.img != null) {
                p.DrawBmp(this.img, this.GetPosition());
            }
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        this.lret = false;
        if (this.isVisible) {
            if (this.GetType() == DatConstants.OBJECT_TYPE_NPC) {
                if (this.tNpc.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                    this.lret = true;
                }
            } else if (this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET || this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET_CANT_WALK || this.img == null) {
                // empty if block
            }
        }
        return this.lret;
    }

    public final MmgVector2 GetPosition() {
        if (this.GetType() == DatConstants.OBJECT_TYPE_PC || this.IsPcFake()) {
            if (GamePanel.PC != null) {
                return GamePanel.PC.GetPosition();
            }
            return super.GetPosition();
        }
        return super.GetPosition();
    }

    public final int GetWidth() {
        if (this.GetType() == DatConstants.OBJECT_TYPE_PC) {
            if (GamePanel.PC != null) {
                return GamePanel.PC.GetWidth();
            }
            return 0;
        }
        if (this.GetType() == DatConstants.OBJECT_TYPE_NPC) {
            if (this.tNpc != null) {
                return this.tNpc.GetWidth();
            }
            return 0;
        }
        if (this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET || this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET_CANT_WALK) {
            if (this.tOs != null) {
                return this.tOs.GetWidth();
            }
            return 0;
        }
        if (this.img != null) {
            return this.img.GetWidth();
        }
        return 0;
    }

    public final void SetWidth(int i) {
        if (this.GetType() == DatConstants.OBJECT_TYPE_NPC) {
            if (this.tNpc != null) {
                this.tNpc.SetWidth(i);
            }
        } else if (this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET || this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET_CANT_WALK) {
            if (this.tOs != null) {
                this.tOs.SetWidth(i);
            }
        } else if (this.img != null) {
            this.img.SetWidth(i);
        }
    }

    public final int GetHeight() {
        if (this.GetType() == DatConstants.OBJECT_TYPE_PC) {
            if (GamePanel.PC != null) {
                return GamePanel.PC.GetHeight();
            }
            return 0;
        }
        if (this.GetType() == DatConstants.OBJECT_TYPE_NPC) {
            if (this.tNpc != null) {
                return this.tNpc.GetHeight();
            }
            return 0;
        }
        if (this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET || this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET_CANT_WALK) {
            if (this.tOs != null) {
                return this.tOs.GetHeight();
            }
            return 0;
        }
        if (this.img != null) {
            return this.img.GetHeight();
        }
        return 0;
    }

    public final void SetHeight(int i) {
        if (this.GetType() == DatConstants.OBJECT_TYPE_NPC) {
            if (this.tNpc != null) {
                this.tNpc.SetHeight(i);
            }
        } else if (this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET || this.GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET_CANT_WALK) {
            if (this.tOs != null) {
                this.tOs.SetHeight(i);
            }
        } else if (this.img != null) {
            this.img.SetHeight(i);
        }
    }
}

