/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreObjects.TyreNpc;
import com.middlemindgames.TyreObjects.TyreObjectSet;
import com.middlemindgames.TyreObjects.TyreOverworldView;
import com.middlemindgames.TyreObjects.TyreRoom;
import com.middlemindgames.dat.LinkTable;
import com.middlemindgames.dat.ResourceContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreLinkTable
extends MmgObj {
    private LinkTable datObj;
    private boolean ready;
    private MmgBmp img;
    private TyreRoom room;
    private TyreObjectSet objectSet;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private Color tc;
    private boolean singleRoom = false;
    private boolean lret;
    private TyreOverworldView.RoomViewIndex roomViewIndex = TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE;
    private boolean mirrorPc;
    private MmgVector2 mirrorPcOffset;
    private boolean dirty;
    private final int index;
    private CollisionResult retPc;
    private CollisionResult retNpc;
    public static boolean SHOW_HIDDEN_ITEMS = true;
    public static boolean SHOW_HIDDEN_LINKS = true;
    public static boolean SHOW_HIDDEN_ENEMIES = true;
    public static TyreNpc.NpcRenderMode NPC_RENDER_MODE = TyreNpc.NpcRenderMode.PREVIEW;
    public static boolean SHOW_COLLISION_BOX = true;
    public static boolean SHOW_PSEUDO_DEPTH_COLLISION_BOX = true;
    public static boolean SHOW_PSEUDO_DEPTH_WALK_COLLISION_BOX = true;
    public static boolean SHOW_SEARCH_COLLISION_BOX = true;
    public static boolean SHOW_INVESTIGATE_COLLISION_BOX = true;
    public static boolean SHOW_ROOM_BORDER = true;
    public static boolean FORCE_NPCS_STILL = false;
    public static boolean FORCE_PSEUDO_DEPTH_WALK_COLLISION_BOX = true;

    public TyreLinkTable(LinkTable t, int idx) {
        this.SetDatObj(t);
        this.ready = false;
        this.mirrorPc = false;
        this.dirty = false;
        this.mirrorPcOffset = MmgVector2.GetOriginVec();
        this.index = idx;
        this.LoadResources();
    }

    public TyreLinkTable(LinkTable t, MmgBmp lImg, int idx) {
        this.SetDatObj(t);
        this.ready = false;
        this.mirrorPc = false;
        this.dirty = false;
        this.mirrorPcOffset = MmgVector2.GetOriginVec();
        this.index = idx;
        this.LoadResources();
        this.img = lImg;
    }

    public final int GetEnemyLevel() {
        return this.datObj.enemyLevel;
    }

    public final int GetFlagIndex() {
        return this.datObj.flagIndex;
    }

    public final int GetFrequency() {
        return this.datObj.frequency;
    }

    public final boolean HasLinkTopLeft() {
        if (DatConstants.IsBadIndex(this.datObj.linkLeft) && DatConstants.IsBadIndex(this.datObj.linkTop)) {
            return false;
        }
        if (!DatConstants.IsBadIndex(this.datObj.linkLeft) && DatConstants.IsBadIndex(ResourceContainer.linkTables[this.datObj.linkLeft].linkTop)) {
            return false;
        }
        return DatConstants.IsBadIndex(this.datObj.linkTop) || !DatConstants.IsBadIndex(ResourceContainer.linkTables[this.datObj.linkTop].linkLeft);
    }

    public final boolean HasLinkTopRight() {
        if (DatConstants.IsBadIndex(this.datObj.linkRight) && DatConstants.IsBadIndex(this.datObj.linkTop)) {
            return false;
        }
        if (!DatConstants.IsBadIndex(this.datObj.linkRight) && DatConstants.IsBadIndex(ResourceContainer.linkTables[this.datObj.linkRight].linkTop)) {
            return false;
        }
        return DatConstants.IsBadIndex(this.datObj.linkTop) || !DatConstants.IsBadIndex(ResourceContainer.linkTables[this.datObj.linkTop].linkRight);
    }

    public final boolean HasLinkBottomLeft() {
        if (DatConstants.IsBadIndex(this.datObj.linkLeft) && DatConstants.IsBadIndex(this.datObj.linkBottom)) {
            return false;
        }
        if (!DatConstants.IsBadIndex(this.datObj.linkLeft) && DatConstants.IsBadIndex(ResourceContainer.linkTables[this.datObj.linkLeft].linkBottom)) {
            return false;
        }
        return DatConstants.IsBadIndex(this.datObj.linkBottom) || !DatConstants.IsBadIndex(ResourceContainer.linkTables[this.datObj.linkBottom].linkLeft);
    }

    public final boolean HasLinkBottomRight() {
        if (DatConstants.IsBadIndex(this.datObj.linkRight) && DatConstants.IsBadIndex(this.datObj.linkBottom)) {
            return false;
        }
        if (!DatConstants.IsBadIndex(this.datObj.linkRight) && DatConstants.IsBadIndex(ResourceContainer.linkTables[this.datObj.linkRight].linkBottom)) {
            return false;
        }
        return DatConstants.IsBadIndex(this.datObj.linkBottom) || !DatConstants.IsBadIndex(ResourceContainer.linkTables[this.datObj.linkBottom].linkRight);
    }

    public final boolean HasLinkBottom() {
        return !DatConstants.IsBadIndex(this.datObj.linkBottom);
    }

    public final boolean HasLinkLeft() {
        return !DatConstants.IsBadIndex(this.datObj.linkLeft);
    }

    public final boolean HasLinkTop() {
        return !DatConstants.IsBadIndex(this.datObj.linkTop);
    }

    public final boolean HasLinkRight() {
        return !DatConstants.IsBadIndex(this.datObj.linkRight);
    }

    public final int GetLinkBottom() {
        return this.datObj.linkBottom;
    }

    public final int GetLinkLeft() {
        return this.datObj.linkLeft;
    }

    public final int GetLinkRight() {
        return this.datObj.linkRight;
    }

    public final int GetLinkTop() {
        return this.datObj.linkTop;
    }

    public final int GetObjectSetIndex() {
        return this.datObj.objectSetIndex;
    }

    public final int GetRoomIndex() {
        return this.datObj.roomIndex;
    }

    public final int GetStringIndex() {
        return this.datObj.stringIndex;
    }

    public final boolean GetHasEnemies() {
        return this.datObj.hasEnemies;
    }

    public final TyreObjectSet GetObjectSet() {
        return this.objectSet;
    }

    public final TyreRoom GetRoom() {
        return this.room;
    }

    public final int GetRcIndex() {
        return this.index;
    }

    public final boolean IsMirrorPc() {
        return this.mirrorPc;
    }

    public final void SetMirrorPc(boolean b) {
        this.mirrorPc = b;
        if (this.objectSet != null) {
            this.objectSet.SetMirrorPc(b);
        }
    }

    public final boolean IsDirty() {
        return this.dirty;
    }

    public final void SetDirty(boolean b) {
        this.dirty = b;
        if (this.objectSet != null) {
            this.objectSet.SetDirty(b);
        }
    }

    public final MmgVector2 GetMirrorPcOffset() {
        return this.mirrorPcOffset;
    }

    public final void SetMirrorPcOffset(MmgVector2 mirrorPcOffset) {
        this.mirrorPcOffset = mirrorPcOffset;
        if (this.objectSet != null) {
            this.objectSet.SetMirrorPcOffset(mirrorPcOffset);
        }
    }

    public final TyreOverworldView.RoomViewIndex GetRoomViewIndex() {
        return this.roomViewIndex;
    }

    public final void SetRoomViewIndex(TyreOverworldView.RoomViewIndex v) {
        this.roomViewIndex = v;
        if (this.objectSet != null) {
            this.objectSet.SetRoomViewIndex(v);
        }
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final boolean HasNpc() {
        return this.objectSet.HasNpc();
    }

    public final boolean HasBattle() {
        return this.objectSet.HasBattle();
    }

    public final boolean HasLink() {
        return this.objectSet.HasLink();
    }

    public final boolean HasSearch() {
        return this.objectSet.HasSearch();
    }

    public final boolean HasPc() {
        if (GamePanel.PC == null) {
            return false;
        }
        return GamePanel.PC.GetRoomViewIndex() == this.GetRoomViewIndex() && this.GetRoomViewIndex() != TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE && this.GetRoomViewIndex() != TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_ALL;
    }

    public final LinkTable GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(LinkTable t) {
        this.datObj = t;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    public final boolean IsSingleRoom() {
        return this.singleRoom;
    }

    public final void SetSingleRoom(boolean b) {
        this.singleRoom = b;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, true);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final CollisionResult CollidesWithGeneric(MmgVector2 pos) {
        CollisionResult ret = this.objectSet.CollidesWithPseudoDepth(pos.GetX(), pos.GetY(), true);
        if (ret.CanWalk()) {
            ret = this.room.CollidesWith(pos.GetX(), pos.GetY());
        }
        return ret;
    }

    public final CollisionResult CollidesWithForSearch(MmgRect inRect) {
        if (this.HasSearch()) {
            CollisionResult ret = this.objectSet.CollidesWithForSearchContained(inRect.GetLeft(), inRect.GetTop(), inRect.GetWidth(), inRect.GetHeight());
            if (ret.CanWalk() && (ret = this.objectSet.CollidesWithForSearchContains(inRect.GetLeft(), inRect.GetTop(), inRect.GetWidth(), inRect.GetHeight())).CanWalk() && (ret = this.objectSet.CollidesWithForSearch(inRect.GetLeft(), inRect.GetTop())).CanWalk() && (ret = this.objectSet.CollidesWithForSearch(inRect.GetRight(), inRect.GetTop())).CanWalk() && (ret = this.objectSet.CollidesWithForSearch(inRect.GetLeft(), inRect.GetBottom())).CanWalk()) {
                ret = this.objectSet.CollidesWithForSearch(inRect.GetRight(), inRect.GetBottom());
            }
            return ret;
        }
        return new CollisionResult(false);
    }

    public final CollisionResult CollidesWithForLink(MmgRect inRect) {
        if (this.HasLink()) {
            CollisionResult ret = this.objectSet.CollidesWithForLinkContained(inRect.GetLeft(), inRect.GetTop(), inRect.GetWidth(), inRect.GetHeight());
            if (ret.CanWalk() && (ret = this.objectSet.CollidesWithForLinkContains(inRect.GetLeft(), inRect.GetTop(), inRect.GetWidth(), inRect.GetHeight())).CanWalk() && (ret = this.objectSet.CollidesWithForLink(inRect.GetLeft(), inRect.GetTop())).CanWalk() && (ret = this.objectSet.CollidesWithForLink(inRect.GetRight(), inRect.GetTop())).CanWalk() && (ret = this.objectSet.CollidesWithForLink(inRect.GetLeft(), inRect.GetBottom())).CanWalk()) {
                ret = this.objectSet.CollidesWithForLink(inRect.GetRight(), inRect.GetBottom());
            }
            return ret;
        }
        return new CollisionResult(false);
    }

    public final CollisionResult CollidesWithForBattle(MmgRect inRect) {
        if (this.HasLink()) {
            CollisionResult ret = this.objectSet.CollidesWithForBattleContained(inRect.GetLeft(), inRect.GetTop(), inRect.GetWidth(), inRect.GetHeight());
            if (ret.CanWalk() && (ret = this.objectSet.CollidesWithForBattleContains(inRect.GetLeft(), inRect.GetTop(), inRect.GetWidth(), inRect.GetHeight())).CanWalk() && (ret = this.objectSet.CollidesWithForBattle(inRect.GetLeft(), inRect.GetTop())).CanWalk() && (ret = this.objectSet.CollidesWithForBattle(inRect.GetRight(), inRect.GetTop())).CanWalk() && (ret = this.objectSet.CollidesWithForBattle(inRect.GetLeft(), inRect.GetBottom())).CanWalk()) {
                ret = this.objectSet.CollidesWithForBattle(inRect.GetRight(), inRect.GetBottom());
            }
            return ret;
        }
        return new CollisionResult(false);
    }

    public final CollisionResult CollidesWithForInvestigate(MmgRect inRect) {
        CollisionResult ret = this.objectSet.CollidesWithForInvestigate(inRect.GetLeft(), inRect.GetTop(), true);
        if (ret.CanWalk() && (ret = this.objectSet.CollidesWithForInvestigate(inRect.GetRight(), inRect.GetTop(), true)).CanWalk() && (ret = this.objectSet.CollidesWithForInvestigate(inRect.GetLeft(), inRect.GetBottom(), true)).CanWalk()) {
            ret = this.objectSet.CollidesWithForInvestigate(inRect.GetRight(), inRect.GetBottom(), true);
        }
        return ret;
    }

    public final CollisionResult CollidesWithForPc(MmgRect inRect) {
        this.retPc = this.room.CollidesWith(inRect.GetLeft(), inRect.GetTop());
        if (this.retPc.CanWalk()) {
            this.retPc = this.room.CollidesWith(inRect.GetRight(), inRect.GetTop());
            if (this.retPc.CanWalk()) {
                this.retPc = this.room.CollidesWith(inRect.GetLeft(), inRect.GetBottom());
                if (this.retPc.CanWalk()) {
                    this.retPc = this.room.CollidesWith(inRect.GetRight(), inRect.GetBottom());
                    if (this.retPc.CanWalk()) {
                        this.retPc = this.objectSet.CollidesWithPseudoDepth(inRect.GetLeft(), inRect.GetTop(), true);
                        if (this.retPc.CanWalk()) {
                            this.retPc = this.objectSet.CollidesWithPseudoDepth(inRect.GetRight(), inRect.GetTop(), true);
                            if (this.retPc.CanWalk()) {
                                this.retPc = this.objectSet.CollidesWithPseudoDepth(inRect.GetLeft(), inRect.GetBottom(), true);
                                if (this.retPc.CanWalk()) {
                                    this.retPc = this.objectSet.CollidesWithPseudoDepth(inRect.GetRight(), inRect.GetBottom(), true);
                                    if (this.retPc.CanWalk()) {
                                        this.retPc = this.objectSet.CollidesWithPseudoDepthContains(inRect.GetLeft(), inRect.GetTop(), true, inRect.GetWidth(), inRect.GetHeight());
                                        if (this.retPc.CanWalk()) {
                                            this.retPc = this.objectSet.CollidesWithPseudoDepthContained(inRect.GetLeft(), inRect.GetTop(), true, inRect.GetWidth(), inRect.GetHeight());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.retPc;
    }

    public final CollisionResult CollidesWithForNpc(MmgRect inRect, TyreNpc ignoreNpc) {
        this.retNpc = this.room.CollidesWith(inRect.GetLeft(), inRect.GetTop());
        if (this.retNpc.CanWalk()) {
            this.retNpc = this.room.CollidesWith(inRect.GetRight(), inRect.GetTop());
            if (this.retNpc.CanWalk()) {
                this.retNpc = this.room.CollidesWith(inRect.GetLeft(), inRect.GetBottom());
                if (this.retNpc.CanWalk()) {
                    this.retNpc = this.room.CollidesWith(inRect.GetRight(), inRect.GetBottom());
                    if (this.retNpc.CanWalk()) {
                        this.retNpc = this.objectSet.CollidesWithPseudoDepth(inRect.GetLeft(), inRect.GetTop(), ignoreNpc);
                        if (this.retNpc.CanWalk()) {
                            this.retNpc = this.objectSet.CollidesWithPseudoDepth(inRect.GetRight(), inRect.GetTop(), ignoreNpc);
                            if (this.retNpc.CanWalk()) {
                                this.retNpc = this.objectSet.CollidesWithPseudoDepth(inRect.GetLeft(), inRect.GetBottom(), ignoreNpc);
                                if (this.retNpc.CanWalk()) {
                                    this.retNpc = this.objectSet.CollidesWithPseudoDepth(inRect.GetRight(), inRect.GetBottom(), ignoreNpc);
                                    if (this.retNpc.CanWalk()) {
                                        this.retNpc = this.objectSet.CollidesWithPseudoDepthContains(inRect.GetLeft(), inRect.GetTop(), ignoreNpc, inRect.GetWidth(), inRect.GetHeight());
                                        if (this.retNpc.CanWalk()) {
                                            this.retNpc = this.objectSet.CollidesWithPseudoDepthContained(inRect.GetLeft(), inRect.GetTop(), ignoreNpc, inRect.GetWidth(), inRect.GetHeight());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.retNpc;
    }

    public final void LoadResources() {
        if (this.bgGraphics == null) {
            this.w = MmgHelper.ScaleValue((int)DatConstants.ROOM_WIDTH);
            this.h = MmgHelper.ScaleValue((int)DatConstants.ROOM_HEIGHT);
            this.PrepBuffers(this.w, this.h);
        }
        if (!DatConstants.IsBadIndex(this.GetRoomIndex())) {
            this.room = new TyreRoom(ResourceContainer.rooms[this.GetRoomIndex()], this.bgGraphics, this.bg);
        }
        if (!DatConstants.IsBadIndex(this.GetObjectSetIndex())) {
            this.objectSet = new TyreObjectSet(ResourceContainer.objectSets[this.GetObjectSetIndex()], this.bgGraphics, this.bg, this);
            this.objectSet.SetRoomViewIndex(this.roomViewIndex);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.singleRoom = false;
        if (DatConstants.IsBadIndex(this.GetLinkLeft()) && DatConstants.IsBadIndex(this.GetLinkTop()) && DatConstants.IsBadIndex(this.GetLinkBottom()) && DatConstants.IsBadIndex(this.GetLinkRight())) {
            this.singleRoom = true;
        }
        this.DrawScreen();
        this.ready = true;
    }

    public final void DrawScreen() {
        this.tc = this.bgGraphics.getColor();
        this.bgGraphics.setColor(Color.BLACK);
        this.bgGraphics.fillRect(0, 0, this.w, this.h);
        this.bgGraphics.setColor(this.tc);
        this.dirty = false;
        if (this.room != null) {
            this.room.DrawScreen();
        }
        if (this.objectSet != null) {
            this.objectSet.DrawScreen();
        }
        if (SHOW_ROOM_BORDER) {
            this.tc = this.bgGraphics.getColor();
            this.bgGraphics.setColor(Color.RED);
            this.bgGraphics.drawRect(0, 0, this.w, this.h);
            this.bgGraphics.setColor(this.tc);
        }
        this.img = new MmgBmp((Image)this.bg);
    }

    public final void UnloadResources() {
        this.room = null;
        if (this.objectSet != null) {
            this.objectSet.UnloadResources();
        }
        this.objectSet = null;
        this.bgGraphics = null;
        this.p = null;
        this.bg = null;
        this.ready = false;
    }

    public final TyreLinkTable Clone() {
        TyreLinkTable ret = new TyreLinkTable(this.datObj, this.index);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        ret.SetSingleRoom(this.IsSingleRoom());
        ret.SetRoomViewIndex(this.GetRoomViewIndex());
        ret.SetMirrorPc(this.IsMirrorPc());
        ret.SetMirrorPcOffset(this.GetMirrorPcOffset());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (this.isVisible) {
            p.DrawBmp(this.img, this.GetPosition());
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        this.lret = false;
        if (this.objectSet != null && this.mirrorPc) {
            if (this.objectSet.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                this.lret = true;
            }
            if (this.dirty) {
                this.lret = true;
            }
            if (this.lret) {
                this.DrawScreen();
            }
        } else if (this.objectSet != null && this.objectSet.HasPc()) {
            if (this.objectSet.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                this.lret = true;
            }
            if (this.dirty) {
                this.lret = true;
            }
            if (this.lret) {
                this.DrawScreen();
            }
        }
        return this.lret;
    }

    public final int GetWidth() {
        return this.img.GetWidth();
    }

    public final void SetWidth(int i) {
        this.img.SetWidth(i);
    }

    public final int GetHeight() {
        return this.img.GetHeight();
    }

    public final void SetHeight(int i) {
        this.img.SetHeight(i);
    }
}

