/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.dat.ResourceContainer;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Random;
import javax.imageio.ImageIO;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMediaTracker;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuItem;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreDatGameUtils {
    public static boolean LOGGING = true;
    private static Random rando = new Random(System.currentTimeMillis());

    public static final boolean ProcessFlag(int flagIdx, int flagDir) {
        if (DatConstants.IsBadIndex(flagIdx)) {
            return false;
        }
        ResourceContainer.flags[flagIdx] = flagDir == 1;
        return true;
    }

    public static final boolean IsFlagActive(int flagIdx) {
        if (DatConstants.IsBadIndex(flagIdx)) {
            return true;
        }
        return !ResourceContainer.flags[flagIdx];
    }

    public static final int GetRandomInt(int exclusiveUpperBound) {
        return rando.nextInt(exclusiveUpperBound);
    }

    public static final void wr(String s) {
        LOGGING = true;
        if (true) {
            System.out.println(s);
        }
    }

    public static final void wrErr(Exception e) {
        LOGGING = true;
        if (true) {
            System.err.println(e.getMessage());
            StackTraceElement[] els = e.getStackTrace();
            int len = els.length;
            for (int i = 0; i < len; ++i) {
                System.err.println(els[i].toString());
            }
        }
    }

    public static final void wrErr(String s) {
        LOGGING = true;
        if (true) {
            System.err.println(s);
        }
    }

    public static final MmgBmp GetDatCachedBmp(int imageIndex, String imgId) {
        MmgBmp lval = null;
        if (GameSettings.BMP_CACHE_ON) {
            if (MmgMediaTracker.HasKey((String)imgId)) {
                lval = new MmgBmp(MmgMediaTracker.GetValue((String)imgId));
                lval.SetMmgColor(null);
            } else {
                lval = TyreDatGameUtils.GetBinaryBmp(ResourceContainer.bitmaps[imageIndex].png);
                MmgMediaTracker.CacheImage((String)imgId, (Image)lval.GetImage());
            }
        } else {
            lval = TyreDatGameUtils.GetBinaryBmp(ResourceContainer.bitmaps[imageIndex].png);
        }
        return lval;
    }

    public static final MmgBmp GetDatCachedConsoleBmp(int imageIndex, String imgId) {
        MmgBmp lval = null;
        if (GameSettings.BMP_CACHE_ON) {
            if (MmgMediaTracker.HasKey((String)imgId)) {
                lval = new MmgBmp(MmgMediaTracker.GetValue((String)imgId));
                lval.SetMmgColor(null);
            } else {
                lval = TyreDatGameUtils.GetBinaryBmp(ResourceContainer.consoleBitmaps[imageIndex].png);
                MmgMediaTracker.CacheImage((String)imgId, (Image)lval.GetImage());
            }
        } else {
            lval = TyreDatGameUtils.GetBinaryBmp(ResourceContainer.consoleBitmaps[imageIndex].png);
        }
        return lval;
    }

    public static final MmgBmp GetBasicCachedBmp(String path, String imgId) {
        MmgBmp lval = null;
        if (GameSettings.BMP_CACHE_ON) {
            if (MmgMediaTracker.HasKey((String)imgId)) {
                lval = new MmgBmp(MmgMediaTracker.GetValue((String)imgId));
                lval.SetMmgColor(null);
            } else {
                lval = TyreDatGameUtils.GetBasicBmp(path);
                MmgMediaTracker.CacheImage((String)imgId, (Image)lval.GetImage());
            }
        } else {
            lval = TyreDatGameUtils.GetBasicBmp(path);
        }
        return lval;
    }

    public static final void ListCacheEntries() {
        if (GameSettings.BMP_CACHE_ON) {
            int len = MmgMediaTracker.GetCacheSize();
            Object[] keys = MmgMediaTracker.ms.keySet().toArray();
            for (int i = 0; i < len; ++i) {
                String key = keys[i] + "";
                TyreDatGameUtils.wr(i + " key: " + key);
            }
        }
    }

    public static final MmgBmp GetBasicBmp(String src) {
        Image b = null;
        MmgBmp r = null;
        try {
            b = ImageIO.read(new File(src));
        }
        catch (Exception e) {
            TyreDatGameUtils.wrErr(e);
        }
        if (b != null) {
            b = MmgPen.ScaleImage((Image)b, (MmgVector2)MmgScreenData.GetScale());
            r = new MmgBmp(b);
            r.SetScaling(MmgVector2.GetUnitVec());
            r.SetPosition(MmgVector2.GetOriginVec());
            r.SetOrigin(MmgVector2.GetOriginVec());
            r.SetMmgColor(null);
        }
        return r;
    }

    public static final MmgBmp GetBinaryBmp(byte[] d) {
        Image b = null;
        MmgBmp r = null;
        try {
            b = ImageIO.read(new ByteArrayInputStream(d));
        }
        catch (Exception e) {
            TyreDatGameUtils.wrErr(e);
        }
        if (b != null) {
            b = MmgPen.ScaleImage((Image)b, (MmgVector2)MmgScreenData.GetScale());
            r = new MmgBmp(b);
            r.SetScaling(MmgVector2.GetUnitVec());
            r.SetPosition(MmgVector2.GetOriginVec());
            r.SetOrigin(MmgVector2.GetOriginVec());
            r.SetMmgColor(null);
        }
        return r;
    }

    public static final MmgBmp GetImageBmp(Image b) {
        MmgBmp r = null;
        if (b != null) {
            b = MmgPen.ScaleImage((Image)b, (MmgVector2)MmgScreenData.GetScale());
            r = new MmgBmp(b);
            r.SetScaling(MmgVector2.GetUnitVec());
            r.SetPosition(MmgVector2.GetOriginVec());
            r.SetOrigin(MmgVector2.GetOriginVec());
            r.SetMmgColor(null);
        }
        return r;
    }

    public static final MmgBmp GetImageCacheBmp(Image b) {
        MmgBmp r = null;
        if (b != null) {
            r = new MmgBmp(b);
            r.SetScaling(MmgVector2.GetUnitVec());
            r.SetPosition(MmgVector2.GetOriginVec());
            r.SetOrigin(MmgVector2.GetOriginVec());
            r.SetMmgColor(null);
        }
        return r;
    }

    public static final MmgMenuItem GetBasicMenuItem(MmgEventHandler handler, String name, int eventId, int eventType, MmgBmp img) {
        MmgMenuItem itm = new MmgMenuItem();
        itm.SetNormal((MmgObj)img);
        itm.SetSelected((MmgObj)img);
        itm.SetInactive((MmgObj)img);
        itm.SetPosition(img.GetPosition());
        itm.SetState(0);
        itm.SetEventPress(new MmgEvent(handler, name, eventId, eventType, handler, null));
        itm.SetMmgColor(null);
        return itm;
    }
}

