/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.HandleHelpItemDescEvent;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreItem;
import com.middlemindgames.dat.ResourceContainer;
import java.util.Hashtable;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFontData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgGameScreen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgLabelValuePair;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuItem;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class ScreenHelpItemDesc
extends MmgGameScreen {
    private final GamePanel.GameStates state;
    private MmgBmp menuMore;
    private MmgBmp menuPrev;
    private MmgBmp menuNext;
    private MmgBmp menuHelpMenu;
    private MmgBmp menuTitle;
    private MmgBmp menuTitleLine;
    private MmgBmp menuFooterUrl;
    private MmgBmp itemFrame;
    private MmgBmp blackTile;
    private MmgLabelValuePair itemNameLvp;
    private MmgLabelValuePair itemApLvp;
    private MmgLabelValuePair itemCostLvp;
    private MmgLabelValuePair itemTypeLvp;
    private MmgLabelValuePair itemFlagLvp;
    private MmgLabelValuePair itemDpLvp;
    private MmgLabelValuePair itemTxtLvp;
    private MmgMenuContainer menu;
    private MmgBmp menuCursor;
    private HandleHelpItemDescEvent handleMenuEvent;
    private final GamePanel owner;
    private int itemIndex;
    private int itemIndexMax;
    private TyreItem tItm;
    private int paddingX;
    private int paddingY;
    private int spaceY;
    private final Hashtable<String, String> itemAdvType;
    private boolean dirty = false;
    private boolean lret;
    private int cursorId = DatConstants.CURSOR_CONSOLE_IMG_ID;
    private int cursorOffsetX = MmgHelper.ScaleValue((int)DatConstants.CURSOR_OFFSET_HELP_ITEM_DESC_X);
    private int cursorOffsetY = MmgHelper.ScaleValue((int)DatConstants.CURSOR_OFFSET_HELP_ITEM_DESC_Y);

    public ScreenHelpItemDesc(GamePanel.GameStates State2, GamePanel Owner) {
        this.pause = false;
        this.ready = false;
        this.state = State2;
        this.owner = Owner;
        this.itemIndex = 0;
        this.itemIndexMax = 0;
        this.tItm = null;
        this.itemAdvType = new Hashtable();
        this.itemAdvType.put("Gold Coins", "Misc.");
        this.itemAdvType.put("Pile of Gold", "Misc.");
        this.itemAdvType.put("Injured Guard", "Misc.");
        this.itemAdvType.put("Sapling", "Misc.");
        this.itemAdvType.put("Bag of Stuff", "Misc.");
        this.itemAdvType.put("Antique Sword", "Misc.");
        this.itemAdvType.put("Sapling Life Force", "Misc.");
        this.itemAdvType.put("Restore Potion", "Medicine");
        this.itemAdvType.put("Anti-Poison Orb", "Medicine");
        this.itemAdvType.put("Anti-Stun Orb", "Medicine");
        this.itemAdvType.put("Anti-Sleep Orb", "Medicine");
        this.itemAdvType.put("Herbal Antidote", "Medicine");
        this.itemAdvType.put("Herbal Anti-Sleep", "Medicine");
        this.itemAdvType.put("Healing Herb", "Medicine");
        this.itemAdvType.put("Healing Salve", "Medicine");
        this.itemAdvType.put("Bale Fire Orb", "Special");
        this.itemAdvType.put("New Life Container", "Special");
        this.itemAdvType.put("Magical Warp", "Special");
        this.itemAdvType.put("Blizzard Staff", "Special");
        this.itemAdvType.put("Leather Armor", "Armor");
        this.itemAdvType.put("Chain Mail Armor", "Armor");
        this.itemAdvType.put("Plate Mail Armor", "Armor");
        this.itemAdvType.put("Magic Armor", "Armor");
        this.itemAdvType.put("Wooden Sword", "Sword");
        this.itemAdvType.put("Broad Sword", "Sword");
        this.itemAdvType.put("Long Sword", "Sword");
        this.itemAdvType.put("Magic Sword", "Sword");
        this.itemAdvType.put("Compass", "Navigation");
        this.itemAdvType.put("Torch", "Navigation");
        this.itemAdvType.put("Map", "Navigation");
        this.itemAdvType.put("Herterod's Myths p.41", "Mythos");
        this.itemAdvType.put("Herterod's Myths p.80", "Mythos");
        this.itemAdvType.put("Herterod's Myths p.17", "Mythos");
        this.itemAdvType.put("Herterod's Myths p.23", "Mythos");
        this.itemAdvType.put("Herterod's Myths p.145", "Mythos");
        this.itemAdvType.put("Fern's Letter", "Letters/Notes");
        this.itemAdvType.put("Kalin's Message", "Letters/Notes");
        this.itemAdvType.put("Majik Werks Cert.", "Letters/Notes");
        this.itemAdvType.put("Madeline's List", "Letters/Notes");
        this.itemAdvType.put("Strange Letter", "Letters/Notes");
        this.itemAdvType.put("Christoff's Letter", "Letters/Notes");
        this.itemAdvType.put("Smuggler's Code", "Letters/Notes");
        this.itemAdvType.put("Boffen's Directions", "Letters/Notes");
        this.itemAdvType.put("Bale Fire Orb Specs", "Letters/Notes");
        this.itemAdvType.put("Krysy's Note", "Letters/Notes");
        this.itemAdvType.put("Jimmy's Treasure", "Letters/Notes");
        this.itemAdvType.put("Torn Page", "Letters/Notes");
        this.itemAdvType.put("Wizzardo's Note", "Letters/Notes");
        this.itemAdvType.put("Door Pass #103", "Letters/Notes");
        this.itemAdvType.put("Toll Directions", "Letters/Notes");
        this.itemAdvType.put("Letter", "Letters/Notes");
        this.itemAdvType.put("Carrie's Treasure", "Letters/Notes");
        this.itemAdvType.put("Steve's Note", "Letters/Notes");
        this.itemAdvType.put("MW Ltd. Log Entry 1268", "Letters/Notes");
        this.itemAdvType.put("Hugh's Treasure", "Letters/Notes");
        this.itemAdvType.put("Caerie's Message", "Letters/Notes");
    }

    public final int GetItemIndex() {
        return this.itemIndex;
    }

    public final int IncItemIndex() {
        if (this.itemIndex + 1 < this.itemIndexMax) {
            return ++this.itemIndex;
        }
        return this.itemIndex;
    }

    public final int DecItemIndex() {
        if (this.itemIndex - 1 >= 0) {
            return --this.itemIndex;
        }
        return this.itemIndex;
    }

    public final void SetItemIndex(int i) {
        this.itemIndex = i;
    }

    public final int GetItemIndexMax() {
        return this.itemIndexMax;
    }

    public final void LoadResources() {
        this.pause = true;
        this.SetHeight(MmgScreenData.GetGameHeight());
        this.SetWidth(MmgScreenData.GetGameWidth());
        this.SetPosition(MmgScreenData.GetPosition());
        this.itemIndex = GamePanel.VARS.containsKey("itemIndex") ? (Integer)GamePanel.VARS.get("itemIndex") : 0;
        TyreDatGameUtils.wr("Found item index: " + this.itemIndex);
        MmgBmp tB = null;
        MmgPen p = new MmgPen();
        p.SetCacheOn(false);
        String imgId = "menu_background.png";
        MmgBmp lval = null;
        String path = "../cfg/drawable/menu_background.png";
        tB = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        if (tB != null) {
            this.SetCenteredBackground((MmgObj)tB);
        }
        imgId = "item_descriptions_title.png";
        lval = null;
        path = "../cfg/drawable/item_descriptions_title.png";
        this.menuTitle = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        if (this.menuTitle != null) {
            MmgHelper.CenterHor((MmgObj)this.menuTitle);
            this.menuTitle.GetPosition().SetY(this.GetPosition().GetY() + MmgHelper.ScaleValue((int)60));
            this.AddObj((MmgObj)this.menuTitle);
        }
        imgId = "menu_title_line.png";
        lval = null;
        path = "../cfg/drawable/menu_title_line.png";
        this.menuTitleLine = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        if (this.menuTitleLine != null) {
            MmgHelper.CenterHor((MmgObj)this.menuTitleLine);
            this.menuTitleLine.GetPosition().SetY(this.menuTitle.GetPosition().GetY() + MmgHelper.ScaleValue((int)30));
            this.AddObj((MmgObj)this.menuTitleLine);
        }
        imgId = "mmg_url.png";
        lval = null;
        path = "../cfg/drawable/mmg_url.png";
        this.menuFooterUrl = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        if (this.menuFooterUrl != null) {
            MmgHelper.CenterHor((MmgObj)this.menuFooterUrl);
            this.menuFooterUrl.GetPosition().SetY(this.GetPosition().GetY() + this.GetHeight() - MmgHelper.ScaleValue((int)65));
            this.AddObj((MmgObj)this.menuFooterUrl);
        }
        this.handleMenuEvent = new HandleHelpItemDescEvent(this, this.owner);
        imgId = "command_more.png";
        lval = null;
        path = "../cfg/drawable/command_more.png";
        this.menuMore = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "command_prev.png";
        lval = null;
        path = "../cfg/drawable/command_prev.png";
        this.menuPrev = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "command_next.png";
        lval = null;
        path = "../cfg/drawable/command_next.png";
        this.menuNext = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "command_help_menu.png";
        lval = null;
        path = "../cfg/drawable/command_help_menu.png";
        this.menuHelpMenu = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "item_frame_dark.png";
        lval = null;
        path = "../cfg/drawable/item_frame_dark.png";
        this.itemFrame = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        this.paddingX = MmgHelper.ScaleValue((int)10);
        this.paddingY = MmgHelper.ScaleValue((int)10);
        this.spaceY = MmgHelper.ScaleValue((int)4);
        MmgHelper.CenterHorAndVert((MmgObj)this.itemFrame);
        MmgVector2 lpos = this.itemFrame.GetPosition();
        lpos.SetY(this.menuTitleLine.GetPosition().GetY() + this.menuTitleLine.GetHeight() - this.paddingY / 2);
        lpos.SetX((this.GetWidth() - MmgHelper.ScaleValue((int)420)) / 2 + this.paddingX);
        this.itemFrame.SetPosition(lpos);
        this.itemNameLvp = new MmgLabelValuePair(MmgFontData.GetFontBold(), "Name:", MmgFontData.CreateDefaultNormalFontSm(), "", this.itemFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.itemNameLvp.SetX(this.itemNameLvp.GetX() + this.itemFrame.GetWidth() - this.paddingX);
        this.itemNameLvp.SetY(this.itemNameLvp.GetY() + 2 * this.paddingY + MmgHelper.ScaleValue((int)4));
        this.AddObj((MmgObj)this.itemNameLvp);
        this.itemApLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Attack:", MmgFontData.CreateDefaultNormalFontSm(), "", this.itemFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.itemApLvp.SetX(this.itemApLvp.GetX() + this.itemFrame.GetWidth() - this.paddingX);
        this.itemApLvp.SetY(this.itemNameLvp.GetY() + this.itemNameLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.itemApLvp);
        this.itemDpLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Defense:", MmgFontData.CreateDefaultNormalFontSm(), "", this.itemFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.itemDpLvp.SetX(this.itemDpLvp.GetX() + this.itemFrame.GetWidth() - this.paddingX);
        this.itemDpLvp.SetY(this.itemApLvp.GetY() + this.itemApLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.itemDpLvp);
        this.itemCostLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Cost:", MmgFontData.CreateDefaultNormalFontSm(), "", this.itemFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.itemCostLvp.SetX(this.itemCostLvp.GetX() + this.itemFrame.GetWidth() - this.paddingX);
        this.itemCostLvp.SetY(this.itemDpLvp.GetY() + this.itemDpLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.itemCostLvp);
        this.itemTypeLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Type:", MmgFontData.CreateDefaultNormalFontSm(), "", this.itemFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.itemTypeLvp.SetX(this.itemTypeLvp.GetX() + this.itemFrame.GetWidth() - this.paddingX);
        this.itemTypeLvp.SetY(this.itemCostLvp.GetY() + this.itemCostLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.itemTypeLvp);
        this.itemFlagLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Flag:", MmgFontData.CreateDefaultNormalFontSm(), "", this.itemFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.itemFlagLvp.SetX(this.itemFlagLvp.GetX() + this.itemFrame.GetWidth() - this.paddingX);
        this.itemFlagLvp.SetY(this.itemTypeLvp.GetY() + this.itemTypeLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.itemFlagLvp);
        this.itemTxtLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Text:", MmgFontData.CreateDefaultNormalFontSm(), "", this.itemFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.itemTxtLvp.SetX(this.itemTxtLvp.GetX() + this.itemFrame.GetWidth() - this.paddingX);
        this.itemTxtLvp.SetY(this.itemFlagLvp.GetY() + this.itemFlagLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.itemTxtLvp);
        int val = 50;
        this.blackTile = new MmgBmp(MmgPen.CreateColorTile((int)(this.itemFrame.GetWidth() - MmgHelper.ScaleValue((int)val)), (int)(this.itemFrame.GetHeight() - MmgHelper.ScaleValue((int)val)), (MmgColor)MmgColor.GetBlack()));
        this.blackTile.SetPosition(this.itemFrame.GetPosition().Clone());
        this.blackTile.SetY(this.blackTile.GetY() + MmgHelper.ScaleValue((int)(val / 2)));
        this.blackTile.SetX(this.blackTile.GetX() + MmgHelper.ScaleValue((int)(val / 2)));
        this.AddObj((MmgObj)this.blackTile);
        this.AddObj((MmgObj)this.itemFrame);
        this.itemIndexMax = ResourceContainer.items.length;
        this.menuCursor = lval = TyreDatGameUtils.GetDatCachedConsoleBmp(this.cursorId, "" + this.cursorId);
        this.SetLeftCursor((MmgObj)this.menuCursor);
        this.SetMenuCursorLeftOffsetX(this.cursorOffsetX);
        this.SetMenuCursorLeftOffsetY(this.cursorOffsetY);
        this.dirty = true;
        this.ready = true;
        this.pause = false;
    }

    public final boolean ProcessAClick() {
        int idx = this.GetMenuIdx();
        MmgMenuItem mmi = (MmgMenuItem)this.menu.GetContainer().get(idx);
        if (mmi != null) {
            this.ProcessMenuItemSel(mmi);
            return true;
        }
        return false;
    }

    public final boolean ProcessDpadRelease(int dir) {
        if (dir == DatConstants.NPC_DIR_LEFT || dir == DatConstants.NPC_DIR_RIGHT) {
            return false;
        }
        if (dir == DatConstants.NPC_DIR_BACK) {
            this.MoveMenuSelUp();
        } else if (dir == DatConstants.NPC_DIR_FRONT) {
            this.MoveMenuSelDown();
        }
        return false;
    }

    public final void DrawScreen() {
        int mainY;
        this.pause = true;
        this.menu = new MmgMenuContainer();
        this.menu.SetMmgColor(null);
        this.dirty = false;
        if (this.itemIndex < this.itemIndexMax - 1 && this.menuNext != null) {
            mainY = this.menuFooterUrl.GetY() + this.menuFooterUrl.GetHeight() - this.menuNext.GetHeight() - MmgHelper.ScaleValue((int)15);
            this.menuNext.SetX((this.GetWidth() + MmgHelper.ScaleValue((int)410)) / 2 + this.GetX() - this.menuNext.GetWidth());
            this.menuNext.SetY(mainY);
            this.menu.Add(TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Help Item Desc Next", 1, 0, this.menuNext));
        }
        if (this.itemIndex > 0 && this.menuPrev != null) {
            mainY = this.menuFooterUrl.GetY() + this.menuFooterUrl.GetHeight() - this.menuPrev.GetHeight() - MmgHelper.ScaleValue((int)15);
            this.menuPrev.SetX((this.GetWidth() - MmgHelper.ScaleValue((int)420)) / 2 + this.GetX());
            this.menuPrev.SetY(mainY);
            this.menu.Add(TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Help Item Desc Prev", 0, 0, this.menuPrev));
        }
        if (this.menuHelpMenu != null) {
            mainY = this.menuFooterUrl.GetY() + this.menuFooterUrl.GetHeight() - this.menuHelpMenu.GetHeight() - MmgHelper.ScaleValue((int)15);
            this.menuHelpMenu.SetX((this.GetWidth() - this.menuHelpMenu.GetWidth()) / 2 + this.GetX());
            this.menuHelpMenu.SetY(mainY);
            this.menu.Add(TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Help Item Desc Main Menu", 3, 0, this.menuHelpMenu));
        }
        if (this.tItm == null) {
            this.tItm = new TyreItem(ResourceContainer.items[this.itemIndex]);
            this.tItm.SetPosition(this.itemFrame.GetPosition().Clone());
            this.tItm.SetX(this.tItm.GetX() + MmgHelper.ScaleValue((int)40));
            this.tItm.SetY(this.tItm.GetY() + MmgHelper.ScaleValue((int)30));
            this.tItm.SetMmgColor(MmgColor.GetBlack());
            this.AddObj(this.tItm);
        } else {
            this.tItm.SetDatObj(ResourceContainer.items[this.itemIndex]);
            this.tItm.LoadResources();
        }
        TyreDatGameUtils.wr("Item Type: " + this.tItm.GetItemType());
        TyreDatGameUtils.wr("Item Type Str: " + DatConstants.ItemTypeToString(this.tItm.GetItemType()));
        String lname = this.tItm.GetNameString();
        String ltype = DatConstants.ItemTypeToString(this.tItm.GetItemType());
        String lcost = DatConstants.CleanNegativeOnes(this.tItm.GetCost() + "", "0");
        if (lname != null && lname.length() >= 20) {
            this.itemNameLvp.SetLabelFont(MmgFontData.CreateDefaultBoldFontExtraSm());
        } else {
            this.itemNameLvp.SetLabelFont(MmgFontData.GetFontBold());
        }
        this.itemNameLvp.SetLabelText(lname);
        if (lcost.equals("0")) {
            this.itemCostLvp.SetValueText("n/a");
        } else {
            this.itemCostLvp.SetValueText(lcost + " gc");
        }
        if (this.itemAdvType.containsKey(lname)) {
            ltype = this.itemAdvType.get(lname);
        }
        this.itemTypeLvp.SetValueText(ltype);
        if (ltype.equals("Armor") || ltype.equals("Sword")) {
            this.itemApLvp.SetValueText("??? pts");
            this.itemDpLvp.SetValueText("??? pts");
        } else {
            this.itemApLvp.SetValueText("n/a");
            this.itemDpLvp.SetValueText("n/a");
        }
        if (this.tItm.GetFlagIndex() != DatConstants.NEGATIVE_ONE) {
            this.itemFlagLvp.SetValueText(this.tItm.GetFlagIndex() + " is " + DatConstants.BoolToStringLower(this.tItm.GetFlagState()));
        } else {
            this.itemFlagLvp.SetValueText("No Flag");
        }
        if (this.tItm.GetItemType() == DatConstants.ITEM_TYPE_READABLE && !DatConstants.IsBadIndex(this.tItm.GetReadStringIndex())) {
            this.itemTxtLvp.SetValueText("");
            this.menuMore.SetX(this.itemTxtLvp.GetX() + this.itemTxtLvp.GetWidth() + this.itemTxtLvp.GetPaddingX());
            this.menuMore.SetY(this.itemTxtLvp.GetY());
            this.menu.Add(TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Help Item Desc More", 2, 0, this.menuMore));
            GamePanel.VARS.put("itemDescReadString", this.tItm.GetReadString());
        } else {
            GamePanel.VARS.remove("itemDescReadString");
            this.itemTxtLvp.SetValueText("n/a");
        }
        GamePanel.VARS.put("itemIndex", this.itemIndex);
        this.SetMenuStart(0);
        this.SetMenuStop(this.menu.GetCount() - 1);
        this.SetMenu(this.menu);
        this.SetMenuOn(true);
        this.pause = false;
    }

    public final void UnloadResources() {
        this.dirty = false;
        this.pause = true;
        this.SetIsVisible(false);
        this.SetBackground(null);
        this.SetMenu(null);
        this.ClearObjs();
        this.menuPrev = null;
        this.menuNext = null;
        this.menuHelpMenu = null;
        this.menuTitle = null;
        this.menuTitleLine = null;
        this.menuFooterUrl = null;
        if (this.tItm != null) {
            this.tItm.UnloadResources();
        }
        this.tItm = null;
        this.itemFrame = null;
        this.itemNameLvp = null;
        this.itemApLvp = null;
        this.itemCostLvp = null;
        this.itemTypeLvp = null;
        this.itemFlagLvp = null;
        this.menuCursor = null;
        this.handleMenuEvent = null;
        this.menu = null;
        this.ready = false;
    }

    public final GamePanel.GameStates GetGameState() {
        return this.state;
    }

    public final boolean IsDirty() {
        return this.dirty;
    }

    public final void SetDirty(boolean b) {
        this.dirty = b;
    }

    public final void MakeDirty() {
        this.dirty = true;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.GetIsVisible()) {
            super.MmgDraw(p);
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        this.lret = false;
        if (!this.pause && this.GetIsVisible()) {
            if (super.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                this.lret = true;
            }
            if (this.dirty) {
                this.lret = true;
                this.DrawScreen();
            }
        }
        return this.lret;
    }
}

