/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.HandleHelpEnemyDescEvent;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreEnemy;
import com.middlemindgames.dat.ResourceContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFontData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgGameScreen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgLabelValuePair;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuItem;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class ScreenHelpEnemyDesc
extends MmgGameScreen {
    private final GamePanel.GameStates state;
    private MmgBmp menuPrev;
    private MmgBmp menuNext;
    private MmgBmp menuHelpMenu;
    private MmgBmp menuTitle;
    private MmgBmp menuTitleLine;
    private MmgBmp menuFooterUrl;
    private MmgBmp enemyFrame;
    private MmgBmp blackTile;
    private MmgLabelValuePair enemyNameLvp;
    private MmgLabelValuePair enemyApLvp;
    private MmgLabelValuePair enemyDpLvp;
    private MmgLabelValuePair enemyHpLvp;
    private MmgLabelValuePair enemyMpLvp;
    private MmgLabelValuePair enemyLvLvp;
    private MmgLabelValuePair enemySpeedLvp;
    private MmgLabelValuePair enemyHitTimeLvp;
    private MmgLabelValuePair enemyAiTypeLvp;
    private MmgBmp menuCursor;
    private MmgMenuContainer menu;
    private int cursorId = DatConstants.CURSOR_CONSOLE_IMG_ID;
    private int cursorOffsetX = MmgHelper.ScaleValue((int)DatConstants.CURSOR_OFFSET_HELP_ENEMY_DESC_X);
    private int cursorOffsetY = MmgHelper.ScaleValue((int)DatConstants.CURSOR_OFFSET_HELP_ENEMY_DESC_Y);
    private HandleHelpEnemyDescEvent handleMenuEvent;
    private final GamePanel owner;
    private int enemyIndex;
    private int enemyIndexMax;
    private int enemySubIndex;
    private int enemySubIndexMax;
    private TyreEnemy tEnm;
    private int paddingX;
    private int paddingY;
    private int spaceY;
    private boolean dirty = false;
    private boolean lret;

    public ScreenHelpEnemyDesc(GamePanel.GameStates State2, GamePanel Owner) {
        this.pause = false;
        this.ready = false;
        this.state = State2;
        this.owner = Owner;
        this.enemyIndex = 0;
        this.enemyIndexMax = 0;
        this.enemySubIndex = 0;
        this.enemySubIndexMax = 0;
        this.tEnm = null;
    }

    public final int GetEnemyIndex() {
        return this.enemyIndex;
    }

    public final int GetEnemySubIndex() {
        return this.enemySubIndex;
    }

    public final void IncEnemyIndex() {
        if (this.enemySubIndex + 1 < this.enemySubIndexMax) {
            ++this.enemySubIndex;
        } else if (this.enemyIndex + 1 < this.enemyIndexMax) {
            this.enemySubIndex = 0;
            ++this.enemyIndex;
        }
        TyreDatGameUtils.wr(this.enemyIndex + ": " + this.enemySubIndex);
    }

    public final void DecEnemyIndex() {
        if (this.enemySubIndex - 1 >= 0) {
            --this.enemySubIndex;
        } else if (this.enemyIndex - 1 >= 0) {
            this.enemySubIndex = this.enemySubIndexMax - 1;
            --this.enemyIndex;
        }
    }

    public final void SetEnemyIndex(int i) {
        this.enemyIndex = i;
    }

    public final int GetEnemyIndexMax() {
        return this.enemyIndexMax;
    }

    public final void SetEnemySubIndex(int i) {
        this.enemySubIndex = i;
    }

    public final int GetEnemySubIndexMax() {
        return this.enemySubIndexMax;
    }

    public final void LoadResources() {
        this.pause = true;
        this.SetHeight(MmgScreenData.GetGameHeight());
        this.SetWidth(MmgScreenData.GetGameWidth());
        this.SetPosition(MmgScreenData.GetPosition());
        this.enemyIndex = GamePanel.VARS.containsKey("enemyIndex") ? (Integer)GamePanel.VARS.get("enemyIndex") : 0;
        this.enemySubIndex = GamePanel.VARS.containsKey("enemySubIndex") ? (Integer)GamePanel.VARS.get("enemySubIndex") : 0;
        TyreDatGameUtils.wr("Found enemy index: " + this.enemyIndex + " with sub index: " + this.enemySubIndex);
        MmgBmp tB = null;
        MmgPen p = new MmgPen();
        p.SetCacheOn(false);
        String imgId = "menu_background.png";
        MmgBmp lval = null;
        String path = "../cfg/drawable/menu_background.png";
        tB = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        if (tB != null) {
            this.SetCenteredBackground((MmgObj)tB);
        }
        imgId = "enemy_descriptions_title.png";
        lval = null;
        path = "../cfg/drawable/enemy_descriptions_title.png";
        this.menuTitle = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        if (this.menuTitle != null) {
            MmgHelper.CenterHor((MmgObj)this.menuTitle);
            this.menuTitle.GetPosition().SetY(this.GetPosition().GetY() + MmgHelper.ScaleValue((int)60));
            this.AddObj((MmgObj)this.menuTitle);
        }
        imgId = "menu_title_line.png";
        lval = null;
        path = "../cfg/drawable/menu_title_line.png";
        this.menuTitleLine = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        if (this.menuTitleLine != null) {
            MmgHelper.CenterHor((MmgObj)this.menuTitleLine);
            this.menuTitleLine.GetPosition().SetY(this.menuTitle.GetPosition().GetY() + MmgHelper.ScaleValue((int)30));
            this.AddObj((MmgObj)this.menuTitleLine);
        }
        imgId = "mmg_url.png";
        lval = null;
        path = "../cfg/drawable/mmg_url.png";
        this.menuFooterUrl = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        if (this.menuFooterUrl != null) {
            MmgHelper.CenterHor((MmgObj)this.menuFooterUrl);
            this.menuFooterUrl.GetPosition().SetY(this.GetPosition().GetY() + this.GetHeight() - MmgHelper.ScaleValue((int)65));
            this.AddObj((MmgObj)this.menuFooterUrl);
        }
        this.handleMenuEvent = new HandleHelpEnemyDescEvent(this, this.owner);
        imgId = "command_prev.png";
        lval = null;
        path = "../cfg/drawable/command_prev.png";
        this.menuPrev = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "command_next.png";
        lval = null;
        path = "../cfg/drawable/command_next.png";
        this.menuNext = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "command_help_menu.png";
        lval = null;
        path = "../cfg/drawable/command_help_menu.png";
        this.menuHelpMenu = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        imgId = "enemy_frame_dark.png";
        lval = null;
        path = "../cfg/drawable/enemy_frame_dark.png";
        this.enemyFrame = lval = TyreDatGameUtils.GetBasicCachedBmp(path, imgId);
        this.paddingX = MmgHelper.ScaleValue((int)10);
        this.paddingY = MmgHelper.ScaleValue((int)10);
        this.spaceY = MmgHelper.ScaleValue((int)4);
        MmgHelper.CenterHorAndVert((MmgObj)this.enemyFrame);
        MmgVector2 lpos = this.enemyFrame.GetPosition();
        lpos.SetY(this.menuTitleLine.GetPosition().GetY() + this.menuTitleLine.GetHeight() - this.paddingY / 2);
        lpos.SetX((this.GetWidth() - MmgHelper.ScaleValue((int)420)) / 2 + this.paddingX - MmgHelper.ScaleValue((int)15));
        this.enemyFrame.SetPosition(lpos);
        this.enemyNameLvp = new MmgLabelValuePair(MmgFontData.GetFontBold(), "Name:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemyNameLvp.SetX(this.enemyNameLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemyNameLvp.SetY(this.enemyNameLvp.GetY() + 2 * this.paddingY + MmgHelper.ScaleValue((int)4));
        this.AddObj((MmgObj)this.enemyNameLvp);
        this.enemyApLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Attack Points:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemyApLvp.SetX(this.enemyApLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemyApLvp.SetY(this.enemyNameLvp.GetY() + this.enemyNameLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.enemyApLvp);
        this.enemyDpLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Defense Points:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemyDpLvp.SetX(this.enemyDpLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemyDpLvp.SetY(this.enemyApLvp.GetY() + this.enemyApLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.enemyDpLvp);
        this.enemyHpLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Life Points:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemyHpLvp.SetX(this.enemyHpLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemyHpLvp.SetY(this.enemyDpLvp.GetY() + this.enemyDpLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.enemyHpLvp);
        this.enemyMpLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Magic Points:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemyMpLvp.SetX(this.enemyMpLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemyMpLvp.SetY(this.enemyHpLvp.GetY() + this.enemyHpLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.enemyMpLvp);
        this.enemyLvLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Level:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemyLvLvp.SetX(this.enemyLvLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemyLvLvp.SetY(this.enemyMpLvp.GetY() + this.enemyMpLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.enemyLvLvp);
        this.enemySpeedLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Speed:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemySpeedLvp.SetX(this.enemySpeedLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemySpeedLvp.SetY(this.enemyLvLvp.GetY() + this.enemyLvLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.enemySpeedLvp);
        this.enemyHitTimeLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "Hit Time:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemyHitTimeLvp.SetX(this.enemyHitTimeLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemyHitTimeLvp.SetY(this.enemySpeedLvp.GetY() + this.enemySpeedLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.enemyHitTimeLvp);
        this.enemyAiTypeLvp = new MmgLabelValuePair(MmgFontData.CreateDefaultBoldFontSm(), "AI:", MmgFontData.CreateDefaultNormalFontSm(), "", this.enemyFrame.GetPosition().Clone(), MmgColor.GetBlack());
        this.enemyAiTypeLvp.SetX(this.enemyAiTypeLvp.GetX() + this.enemyFrame.GetWidth() - this.paddingX * 3);
        this.enemyAiTypeLvp.SetY(this.enemyHitTimeLvp.GetY() + this.enemyHitTimeLvp.GetHeight() + this.spaceY);
        this.AddObj((MmgObj)this.enemyAiTypeLvp);
        int val = 50;
        this.blackTile = new MmgBmp(MmgPen.CreateColorTile((int)(this.enemyFrame.GetWidth() - MmgHelper.ScaleValue((int)val) * 2), (int)(this.enemyFrame.GetHeight() - MmgHelper.ScaleValue((int)val) * 1), (MmgColor)MmgColor.GetBlack()));
        this.blackTile.SetPosition(this.enemyFrame.GetPosition().Clone());
        this.blackTile.SetY(this.blackTile.GetY() + MmgHelper.ScaleValue((int)(val / 2)));
        this.blackTile.SetX(this.blackTile.GetX() + MmgHelper.ScaleValue((int)(val / 2)));
        this.AddObj((MmgObj)this.blackTile);
        this.AddObj((MmgObj)this.enemyFrame);
        this.enemyIndexMax = ResourceContainer.enemies.length;
        this.enemySubIndexMax = ResourceContainer.enemies[0].length;
        this.menuCursor = lval = TyreDatGameUtils.GetDatCachedConsoleBmp(this.cursorId, "" + this.cursorId);
        this.SetLeftCursor((MmgObj)this.menuCursor);
        this.SetMenuCursorLeftOffsetX(this.cursorOffsetX);
        this.SetMenuCursorLeftOffsetY(this.cursorOffsetY);
        this.dirty = true;
        this.ready = true;
        this.pause = false;
    }

    public final boolean ProcessAClick() {
        int idx = this.GetMenuIdx();
        MmgMenuItem mmi = (MmgMenuItem)this.menu.GetContainer().get(idx);
        if (mmi != null) {
            this.ProcessMenuItemSel(mmi);
            return true;
        }
        return false;
    }

    public final boolean ProcessDpadRelease(int dir) {
        if (dir == DatConstants.NPC_DIR_LEFT || dir == DatConstants.NPC_DIR_RIGHT) {
            return false;
        }
        if (dir == DatConstants.NPC_DIR_BACK) {
            this.MoveMenuSelUp();
        } else if (dir == DatConstants.NPC_DIR_FRONT) {
            this.MoveMenuSelDown();
        }
        return false;
    }

    public final void DrawScreen() {
        int mainY;
        this.pause = true;
        this.menu = new MmgMenuContainer();
        this.menu.SetMmgColor(null);
        this.dirty = false;
        if ((this.enemyIndex < this.enemyIndexMax - 1 || this.enemySubIndex < this.enemySubIndexMax - 1) && this.menuNext != null) {
            mainY = this.menuFooterUrl.GetY() + this.menuFooterUrl.GetHeight() - this.menuNext.GetHeight() - MmgHelper.ScaleValue((int)15);
            this.menuNext.SetX((this.GetWidth() + MmgHelper.ScaleValue((int)410)) / 2 + this.GetX() - this.menuNext.GetWidth());
            this.menuNext.SetY(mainY);
            this.menu.Add(TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Help Enemy Desc Next", 1, 0, this.menuNext));
        }
        if (this.enemyIndex > 0 && this.menuPrev != null) {
            mainY = this.menuFooterUrl.GetY() + this.menuFooterUrl.GetHeight() - this.menuPrev.GetHeight() - MmgHelper.ScaleValue((int)15);
            this.menuPrev.SetX((this.GetWidth() - MmgHelper.ScaleValue((int)420)) / 2 + this.GetX());
            this.menuPrev.SetY(mainY);
            this.menu.Add(TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Help Enemy Desc Prev", 0, 0, this.menuPrev));
        }
        if (this.menuHelpMenu != null) {
            mainY = this.menuFooterUrl.GetY() + this.menuFooterUrl.GetHeight() - this.menuHelpMenu.GetHeight() - MmgHelper.ScaleValue((int)15);
            this.menuHelpMenu.SetX((this.GetWidth() - this.menuHelpMenu.GetWidth()) / 2 + this.GetX());
            this.menuHelpMenu.SetY(mainY);
            this.menu.Add(TyreDatGameUtils.GetBasicMenuItem(this.handleMenuEvent, "Help Enemy Desc Main Menu", 3, 0, this.menuHelpMenu));
        }
        if (this.tEnm == null) {
            this.tEnm = new TyreEnemy(ResourceContainer.enemies[this.enemyIndex][this.enemySubIndex]);
            this.tEnm.SetPosition(this.enemyFrame.GetPosition().Clone());
            this.tEnm.SetX(this.tEnm.GetX() + MmgHelper.ScaleValue((int)40));
            this.tEnm.SetY(this.tEnm.GetY() + MmgHelper.ScaleValue((int)31));
            this.tEnm.SetMmgColor(MmgColor.GetBlack());
            this.AddObj(this.tEnm);
        } else {
            this.tEnm.SetDatObj(ResourceContainer.enemies[this.enemyIndex][this.enemySubIndex]);
            this.tEnm.LoadResources();
        }
        String lname = this.tEnm.GetNameString();
        String lap = this.tEnm.GetAttackPoints() + "";
        String ldp = this.tEnm.GetDefensePoints() + "";
        String llv = this.tEnm.GetLevel() + "";
        String lhp = this.tEnm.GetHitPoints() + "";
        String lmp = this.tEnm.GetMagicPoints() + "";
        String lspd = this.tEnm.GetSpeed() + "";
        String lht = this.tEnm.GetHitTime() + "";
        String lai = DatConstants.EnemyAiTypeToString(this.tEnm.GetAiType());
        this.enemyNameLvp.SetLabelText(lname);
        this.enemyApLvp.SetValueText(lap);
        this.enemyDpLvp.SetValueText(ldp);
        this.enemyLvLvp.SetValueText(llv);
        this.enemyHpLvp.SetValueText(lhp);
        this.enemyMpLvp.SetValueText(lmp);
        this.enemySpeedLvp.SetValueText(lspd);
        this.enemyHitTimeLvp.SetValueText(lht);
        this.enemyAiTypeLvp.SetValueText(lai);
        GamePanel.VARS.put("enemyIndex", this.enemyIndex);
        GamePanel.VARS.put("enemySubIndex", this.enemySubIndex);
        TyreDatGameUtils.wr("AI Type: " + this.tEnm.GetAiType());
        this.SetMenuStart(0);
        this.SetMenuStop(this.menu.GetCount() - 1);
        this.SetMenu(this.menu);
        this.SetMenuOn(true);
        this.pause = false;
    }

    public final void UnloadResources() {
        this.dirty = false;
        this.pause = true;
        this.SetIsVisible(false);
        this.SetBackground(null);
        this.SetMenu(null);
        this.ClearObjs();
        this.menuPrev = null;
        this.menuNext = null;
        this.menuHelpMenu = null;
        this.menuTitle = null;
        this.menuTitleLine = null;
        this.menuFooterUrl = null;
        if (this.tEnm != null) {
            this.tEnm.UnloadResources();
        }
        this.tEnm = null;
        this.enemyFrame = null;
        this.enemyNameLvp = null;
        this.enemyApLvp = null;
        this.enemyDpLvp = null;
        this.enemyLvLvp = null;
        this.enemyHpLvp = null;
        this.enemyMpLvp = null;
        this.enemySpeedLvp = null;
        this.enemyHitTimeLvp = null;
        this.menuCursor = null;
        this.handleMenuEvent = null;
        this.menu = null;
        this.ready = false;
    }

    public final GamePanel.GameStates GetGameState() {
        return this.state;
    }

    public final boolean IsDirty() {
        return this.dirty;
    }

    public final void SetDirty(boolean b) {
        this.dirty = b;
    }

    public final void MakeDirty() {
        this.dirty = true;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.GetIsVisible()) {
            super.MmgDraw(p);
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        this.lret = false;
        if (!this.pause && this.GetIsVisible()) {
            if (super.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                this.lret = true;
            }
            if (this.dirty) {
                this.lret = true;
                this.DrawScreen();
            }
        }
        return this.lret;
    }
}

