/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.MainFrame;
import com.middlemindgames.TyreGame.TyreDatGameUtils;

public final class RunFrameRate
implements Runnable {
    private final MainFrame mf;
    private final long tFps;
    private final long tFrameTime;
    private long aFps;
    private long rFps;
    private long frameStart;
    private long frameStop;
    private long frameTime;
    private long frameTimeDiff;
    public static boolean PAUSE = false;
    public static boolean RUNNING = true;

    public RunFrameRate(MainFrame Mf, long Fps) {
        this.mf = Mf;
        this.tFps = Fps;
        this.tFrameTime = 1000L / this.tFps;
        TyreDatGameUtils.wr("Target Frame Rate: " + this.tFps);
        TyreDatGameUtils.wr("Target Frame Time: " + this.tFrameTime);
    }

    public static final void Pause() {
        PAUSE = true;
    }

    public static final boolean IsPaused() {
        return PAUSE;
    }

    public static final void UnPause() {
        PAUSE = false;
    }

    public static final void StopRunning() {
        RUNNING = false;
    }

    public static final boolean IsRunning() {
        return RUNNING;
    }

    public static final void StartRunning() {
        RUNNING = true;
    }

    public final long GetActualFrameRate() {
        return this.aFps;
    }

    public final long GetTargetFrameRate() {
        return this.tFps;
    }

    @Override
    public final void run() {
        while (RUNNING) {
            this.frameStart = System.currentTimeMillis();
            if (!PAUSE) {
                this.mf.Redraw();
            }
            this.frameStop = System.currentTimeMillis();
            this.frameTime = this.frameStop - this.frameStart + 1L;
            this.aFps = 1000L / this.frameTime;
            this.frameTimeDiff = this.tFrameTime - this.frameTime;
            if (this.frameTimeDiff > 0L) {
                try {
                    Thread.sleep((int)this.frameTimeDiff);
                }
                catch (Exception e) {
                    TyreDatGameUtils.wrErr(e);
                }
            }
            this.frameStop = System.currentTimeMillis();
            this.frameTime = this.frameStop - this.frameStart + 1L;
            this.rFps = 1000L / this.frameTime;
            this.mf.SetFrameRate(this.aFps, this.rFps);
        }
    }
}

