/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreOverworldView;
import com.middlemindgames.TyreObjects.TyrePc;
import com.middlemindgames.dat.LoadDat;
import com.middlemindgames.dat.LoadDatEntryNotificationHandler;
import com.middlemindgames.dat.LoadDatEntryNotificationMessage;
import com.middlemindgames.dat.LoadDatSectionNotificationHandler;
import com.middlemindgames.dat.LoadDatSectionNotificationMessage;
import com.middlemindgames.dat.LoadDatUpdateHandler;
import com.middlemindgames.dat.LoadDatUpdateMessage;
import com.middlemindgames.dat.ResourceContainer;
import java.io.File;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class RunDatLoad
implements Runnable,
LoadDatUpdateHandler,
LoadDatSectionNotificationHandler,
LoadDatEntryNotificationHandler {
    private LoadDat lDat;
    private boolean readResult;
    private boolean readComplete;
    private int readPos = 0;
    private int readLen;
    private int len;
    private int extraLoadMultiplier = 1000;
    private int extraLoadLen = 341 * this.extraLoadMultiplier;
    private LoadDatUpdateHandler update;

    public RunDatLoad(boolean Thin, byte[] Data) {
        this.readLen = Data.length;
        this.lDat = new LoadDat(Thin);
        LoadDat.stop = false;
        LoadDat.chapter = Data;
        LoadDat.LOGGING = false;
        this.lDat.SetUpdateHandler((LoadDatUpdateHandler)this);
        this.lDat.SetSectionNotificationHandler((LoadDatSectionNotificationHandler)this);
        this.lDat.SetEntryNotificationHandler((LoadDatEntryNotificationHandler)this);
        this.readResult = false;
    }

    public final void SetUpdateHandler(LoadDatUpdateHandler Update) {
        this.update = Update;
    }

    @Override
    public final void run() {
        int i;
        this.readComplete = false;
        this.readResult = this.lDat.readWorkbookGlobals();
        int tmp = this.readPos;
        this.len = ResourceContainer.bitmaps.length;
        for (i = 0; i < this.len; ++i) {
            TyreDatGameUtils.GetDatCachedBmp(i, GameSettings.BMP_PREFIX + i);
            tmp += this.extraLoadMultiplier;
            if (i == 0 || i % 10 != 0 || this.update == null) continue;
            this.update.HandleUpdate(new LoadDatUpdateMessage(tmp, this.readLen));
        }
        this.len = ResourceContainer.consoleBitmaps.length;
        for (i = 0; i < this.len; ++i) {
            TyreDatGameUtils.GetDatCachedConsoleBmp(i, GameSettings.BMP_PREFIX_CONSOLE + i);
            tmp += this.extraLoadMultiplier;
            if (i == 0 || i % 10 != 0 || this.update == null) continue;
            this.update.HandleUpdate(new LoadDatUpdateMessage(tmp, this.readLen));
        }
        try {
            File ald = new File(GameSettings.AUTO_IMAGE_LOAD_DIR);
            File[] files = ald.listFiles();
            if (files != null && files.length > 0) {
                int tlen = files.length;
                this.extraLoadLen += tlen * this.extraLoadMultiplier;
                for (int i2 = 0; i2 < tlen; ++i2) {
                    TyreDatGameUtils.wr("Found auto_load file: " + files[i2].getName() + " Path: " + files[i2].getPath());
                    TyreDatGameUtils.GetBasicCachedBmp(files[i2].getPath(), files[i2].getName());
                    tmp += this.extraLoadMultiplier;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/main_menu_slogan.png", "main_menu_slogan.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/menu_background.png", "menu_background.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/about.png", "about.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/mmg_url.png", "mmg_url.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/start_game.png", "start_game.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/main_menu_title.png", "main_menu_title.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/help.png", "help.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/settings.png", "settings.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/help_title.png", "help_title.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/menu_title_line.png", "menu_title_line.png");
        tmp += this.extraLoadMultiplier;
        if (this.update != null) {
            this.update.HandleUpdate(new LoadDatUpdateMessage(tmp, this.readLen));
        }
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/command_prev.png", "command_prev.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/command_next.png", "command_next.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/command_main_menu.png", "command_main_menu.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/background_story.png", "background_story.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/item_descriptions.png", "item_descriptions.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/enemy_descriptions.png", "enemy_descriptions.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/game_play_overworld.png", "game_play_overworld.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/game_play_battle_mode.png", "game_play_battle_mode.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/characters.png", "characters.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/quests.png", "quests.png");
        tmp += this.extraLoadMultiplier;
        if (this.update != null) {
            this.update.HandleUpdate(new LoadDatUpdateMessage(tmp, this.readLen));
        }
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/room_previews.png", "room_previews.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/command_more.png", "command_more.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/command_cancel.png", "command_cancel.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/about_title.png", "about_title.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/about_text.png", "about_text.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/name_victor_g_brusca.png", "name_victor_g_brusca.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/name_katia_pouleva.png", "name_katia_pouleva.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/name_waltz_music.png", "name_waltz_music.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/command_back.png", "command_back.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/game_play_overworld_title.png", "game_play_overworld_title.png");
        tmp += this.extraLoadMultiplier;
        if (this.update != null) {
            this.update.HandleUpdate(new LoadDatUpdateMessage(tmp, this.readLen));
        }
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/item_descriptions_title.png", "item_descriptions_title.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/command_help_menu.png", "command_help_menu.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/item_frame_dark.png", "item_frame_dark.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/enemy_descriptions_title.png", "enemy_descriptions_title.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/enemy_frame_dark.png", "enemy_frame_dark.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/game_play_battle_mode_title.png", "game_play_battle_mode_title.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/quests_title.png", "quests_title.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/room_previews_title.png", "room_previews_title.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/room_frame_dark.png", "room_frame_dark.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/popup_window_base.png", "popup_window_base.png");
        tmp += this.extraLoadMultiplier;
        TyreDatGameUtils.GetBasicCachedBmp("../cfg/drawable/popup_window_base2.png", "popup_window_base2.png");
        tmp += this.extraLoadMultiplier;
        GamePanel.PC = new TyrePc(ResourceContainer.players[0]);
        GamePanel.PC.SetRoomViewIndex(TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_CENTER_MIDDLE);
        GamePanel.PC.SetPosition(new MmgVector2(MmgHelper.ScaleValue((int)DatConstants.PC_STARTING_X), MmgHelper.ScaleValue((int)DatConstants.PC_STARTING_Y)));
        tmp += this.extraLoadMultiplier;
        if (!LoadDat.stop) {
            this.readComplete = true;
        }
        if (this.update != null) {
            this.update.HandleUpdate(new LoadDatUpdateMessage(tmp, this.readLen));
        }
    }

    public final void HandleUpdate(LoadDatUpdateMessage obj) {
        if (obj != null) {
            obj.SetLen(obj.GetLen() + this.extraLoadLen);
            this.readPos = obj.GetPos();
            this.readLen = obj.GetLen();
            if (this.update != null) {
                this.update.HandleUpdate(obj);
                if (this.GetReadComplete()) {
                    LoadDat.chapter = null;
                    LoadDat.pos = 0;
                    LoadDat.foundEOF = false;
                    LoadDat.stop = false;
                    this.lDat = null;
                }
            }
        }
    }

    public final void StopDatLoad() {
        LoadDat.stop = true;
    }

    public final int GetLen() {
        return this.readLen;
    }

    public final int GetPos() {
        return this.readPos;
    }

    public final boolean GetReadResult() {
        return this.readResult;
    }

    public final boolean GetReadComplete() {
        return this.readComplete;
    }

    public final void HandleSectionNotification(LoadDatSectionNotificationMessage obj) {
        if (obj != null) {
            TyreDatGameUtils.wr("SectionData SectionId: " + obj.GetSectionId() + " PosStart:" + obj.GetPosStart() + " PosEnd:" + obj.GetPosEnd() + " Len:" + obj.GetLen() + " Name:" + obj.GetName() + " Count:" + obj.GetCount());
        }
    }

    public final void HandleEntryNotification(LoadDatEntryNotificationMessage obj) {
        if (obj != null) {
            TyreDatGameUtils.wr("EntryData SectionId: " + obj.GetSectionId() + " PosStart:" + obj.GetPosStart() + " PosEnd:" + obj.GetPosEnd() + " Len:" + obj.GetLen() + " Name:" + obj.GetName());
        }
    }
}

