/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.RunFrameRate;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.dat.ResourceContainer;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;

public final class MainFrame
extends JFrame {
    public GamePanel pnlGame;
    private final int winWidth;
    private final int winHeight;
    private final int myX;
    private final int myY;
    public final int panelWidth;
    public final int panelHeight;

    public MainFrame(int WinWidth, int WinHeight) {
        this.winWidth = WinWidth;
        this.winHeight = WinHeight;
        this.panelWidth = this.winWidth;
        this.panelHeight = this.winHeight;
        this.myX = 0;
        this.myY = 0;
        this.initComponents();
    }

    public MainFrame(int WinWidth, int WinHeight, int PanWidth, int PanHeight) {
        this.winWidth = WinWidth;
        this.winHeight = WinHeight;
        this.panelWidth = PanWidth;
        this.panelHeight = PanHeight;
        this.myX = 0;
        this.myY = 0;
        this.initComponents();
    }

    public final void SetFrameRate(long fr, long rfr) {
        if (this.pnlGame != null) {
            GamePanel.FPS = "Drawing FPS: " + fr + " Actual FPS: " + rfr;
        }
    }

    public final void initComponents() {
        TyreDatGameUtils.wr("MainFrame: Found Screen Dimen: " + this.winWidth + "x" + this.winHeight);
        TyreDatGameUtils.wr("MainFrame: Found Position: " + this.myX + "x" + this.myY);
        this.pnlGame = new GamePanel(this, this.panelWidth, this.panelHeight, (this.winWidth - this.panelWidth) / 2, (this.winHeight - this.panelHeight) / 2);
        this.add(this.pnlGame.canvas);
        this.pnlGame.canvas.setFocusable(true);
        this.pnlGame.canvas.requestFocus();
        this.pnlGame.canvas.requestFocusInWindow();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    TyreDatGameUtils.wr("WindowClosing");
                    if (GamePanel.SCREEN_MAIN_GAME != null && GamePanel.SCREEN_MAIN_GAME.GetOverworldView() != null) {
                        GamePanel.SCREEN_MAIN_GAME.GetOverworldView().SetPaused(true);
                    }
                    if (GamePanel.PC != null && GamePanel.PC.GetInventory() != null) {
                        GamePanel.PC.GetInventory().ExportInventory(GameSettings.SAVE_DIR_INVENTORY);
                    }
                    if (GamePanel.PC != null && GamePanel.PC.GetState() != null) {
                        GamePanel.PC.GetState().ExportState(GameSettings.SAVE_DIR_STATE);
                    }
                    ResourceContainer.ClearAll();
                    GamePanel.PAUSE = true;
                    GamePanel.EXIT = true;
                    RunFrameRate.PAUSE = true;
                    RunFrameRate.RUNNING = false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                MainFrame.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    public final void Redraw() {
        if (this.pnlGame != null) {
            this.pnlGame.RenderGame();
        }
    }
}

