/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreGame;

import com.middlemindgames.TyreGame.DatConstantsEntry;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DatConstantsImporter {
    private Hashtable<String, DatConstantsEntry> values;
    private String version;

    private void RunImportDatConstants(String xmlFile) throws ParserConfigurationException, SAXException, IOException, Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(xmlFile));
        this.values = new Hashtable();
        Node nodeMain = document.getElementsByTagName("datconstants").item(0);
        this.version = nodeMain.getAttributes().getNamedItem("version").getNodeValue();
        NodeList nodeList = nodeMain.getChildNodes();
        if (this.version != null && this.version.equals("1.0")) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("entry")) continue;
                Element elem = (Element)node;
                String key = node.getAttributes().getNamedItem("key").getNodeValue().toUpperCase();
                String val = node.getAttributes().getNamedItem("val").getNodeValue();
                String type = "int";
                if (node.getAttributes().getNamedItem("type") != null) {
                    type = node.getAttributes().getNamedItem("type").getNodeValue().toLowerCase();
                }
                DatConstantsEntry ent = new DatConstantsEntry(key, val, type);
                TyreDatGameUtils.wr("Found Key: " + key + " Value: " + val + " Type: " + type);
                this.values.put(key, ent);
            }
        } else {
            throw new Exception("Currently only supports version 1.0 of data map files.");
        }
    }

    public boolean ImportDatConstants(String xmlFile) {
        boolean res = false;
        try {
            this.RunImportDatConstants(xmlFile);
            res = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    public Hashtable<String, DatConstantsEntry> GetValues() {
        return this.values;
    }

    public void SetValues(Hashtable<String, DatConstantsEntry> v) {
        this.values = v;
    }

    public String GetVersion() {
        return this.version;
    }

    public void SetVersion(String v) {
        this.version = v;
    }
}

