/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgSprite
extends MmgObj {
    public static final int MMG_SPRITE_FRAME_CHANGE_TYPE = 0;
    public static final int MMG_SPRITE_FRAME_CHANGE = 0;
    private MmgVector2 origin;
    private MmgVector2 scaling;
    private MmgRect srcRect;
    private MmgRect dstRect;
    private MmgBmp[] b;
    private float rotation;
    private int frameStart;
    private int frameStop;
    private long frameTime = -1L;
    private long prevFrameTime = -1L;
    private int frameIdx;
    private long msPerFrame;
    public static int DEFAULT_MS_PER_FRAME = 100;
    private boolean simpleRendering;
    private MmgEventHandler onFrameChange;
    private boolean timerOnly;
    private final MmgEvent frameChange = new MmgEvent(null, "frame_changed", 0, 0, null, null);

    public MmgSprite(MmgBmp[] t, MmgRect Src, MmgRect Dst, MmgVector2 Origin, MmgVector2 Scaling, float Rotation) {
        this.SetRotation(Rotation);
        this.SetOrigin(Origin);
        this.SetScaling(Scaling);
        this.SetSrcRect(Src);
        this.SetDstRect(Dst);
        this.SetBmpArray(t);
        this.SetPosition(null);
        if (t != null && t.length >= 1) {
            this.SetWidth(t[0].GetWidth());
            this.SetHeight(t[0].GetHeight());
        }
        this.SetIsVisible(true);
        this.SetSimpleRendering(true);
        this.SetMsPerFrame(DEFAULT_MS_PER_FRAME);
    }

    public MmgSprite(MmgBmp[] t, MmgVector2 Position, MmgVector2 Origin, MmgVector2 Scaling, float Rotation) {
        this.SetRotation(Rotation);
        this.SetOrigin(Origin);
        this.SetScaling(Scaling);
        MmgRect r = new MmgRect(Position, t[0].GetWidth(), t[0].GetHeight());
        this.SetSrcRect(r);
        this.SetDstRect(null);
        this.SetBmpArray(t);
        this.SetPosition(Position);
        if (t != null && t.length >= 1) {
            this.SetWidth(t[0].GetWidth());
            this.SetHeight(t[0].GetHeight());
        }
        this.SetIsVisible(true);
        this.SetSimpleRendering(true);
        this.SetMsPerFrame(DEFAULT_MS_PER_FRAME);
    }

    public MmgSprite(MmgBmp[] t, MmgVector2 Position) {
        this.SetRotation(0.0f);
        this.SetOrigin(MmgVector2.GetOriginVec());
        this.SetScaling(MmgVector2.GetUnitVec());
        this.SetSrcRect(null);
        this.SetDstRect(null);
        this.SetBmpArray(t);
        this.SetPosition(Position);
        if (t != null && t.length >= 1) {
            this.SetWidth(t[0].GetWidth());
            this.SetHeight(t[0].GetHeight());
        }
        this.SetIsVisible(true);
        this.SetSimpleRendering(true);
        this.SetMsPerFrame(DEFAULT_MS_PER_FRAME);
    }

    public MmgSprite(MmgBmp[] t) {
        this.SetRotation(0.0f);
        this.SetOrigin(MmgVector2.GetOriginVec());
        this.SetScaling(MmgVector2.GetUnitVec());
        this.SetSrcRect(null);
        this.SetDstRect(null);
        this.SetBmpArray(t);
        this.SetPosition(MmgVector2.GetOriginVec());
        if (t != null && t.length >= 1) {
            this.SetWidth(t[0].GetWidth());
            this.SetHeight(t[0].GetHeight());
        }
        this.SetIsVisible(true);
        this.SetSimpleRendering(true);
        this.SetMsPerFrame(DEFAULT_MS_PER_FRAME);
    }

    public MmgSprite(MmgSprite spr) {
        this.SetRotation(spr.GetRotation());
        if (spr.GetOrigin() == null) {
            this.SetOrigin(spr.GetOrigin());
        } else {
            this.SetOrigin(spr.GetOrigin().Clone());
        }
        if (spr.GetScaling() == null) {
            this.SetScaling(spr.GetScaling());
        } else {
            this.SetScaling(spr.GetScaling().Clone());
        }
        if (spr.GetSrcRect() == null) {
            this.SetSrcRect(spr.GetSrcRect());
        } else {
            this.SetSrcRect(spr.GetSrcRect().Clone());
        }
        if (spr.GetDstRect() == null) {
            this.SetDstRect(spr.GetDstRect());
        } else {
            this.SetDstRect(spr.GetDstRect().Clone());
        }
        this.SetBmpArray(spr.GetBmpArray());
        if (spr.GetPosition() == null) {
            this.SetPosition(spr.GetPosition());
        } else {
            this.SetPosition(spr.GetPosition().Clone());
        }
        this.SetFrameIdx(spr.GetFrameIdx());
        this.SetFrameStart(spr.GetFrameStart());
        this.SetFrameStop(spr.GetFrameStop());
        this.SetWidth(spr.GetWidth());
        this.SetHeight(spr.GetHeight());
        this.SetIsVisible(spr.GetIsVisible());
        this.SetSimpleRendering(spr.GetSimpleRendering());
        this.SetMsPerFrame(spr.GetMsPerFrame());
    }

    public void SetFrameChangeEventId(int i) {
        if (this.frameChange != null) {
            this.frameChange.SetEventId(i);
        }
    }

    public MmgEventHandler GetOnFrameChange() {
        return this.onFrameChange;
    }

    public void SetOnFrameChange(MmgEventHandler e) {
        this.onFrameChange = e;
    }

    public boolean GetSimpleRendering() {
        return this.simpleRendering;
    }

    public void SetSimpleRendering(boolean s) {
        this.simpleRendering = s;
    }

    public boolean IsTimerOnly() {
        return this.timerOnly;
    }

    public void SetTimerOnly(boolean b) {
        this.timerOnly = b;
    }

    @Override
    public MmgObj Clone() {
        MmgSprite ret = new MmgSprite(this);
        return ret;
    }

    public MmgBmp GetCurrentFrame() {
        return this.b[this.frameIdx];
    }

    public MmgBmp[] GetBmpArray() {
        return this.b;
    }

    public void SetBmpArray(MmgBmp[] d) {
        this.b = d;
        if (this.b != null && this.b.length >= 1) {
            this.SetWidth(this.b[0].GetWidth());
            this.SetHeight(this.b[0].GetHeight());
            this.frameStart = 0;
            this.frameStop = this.b.length - 1;
            this.frameIdx = 0;
        }
    }

    public MmgRect GetSrcRect() {
        return this.srcRect;
    }

    public void SetSrcRect(MmgRect r) {
        this.srcRect = r;
    }

    public MmgRect GetDstRect() {
        return this.dstRect;
    }

    public void SetDstRect(MmgRect r) {
        this.dstRect = r;
    }

    public float GetRotation() {
        return this.rotation;
    }

    public void SetRotation(float r) {
        this.rotation = r;
    }

    public MmgVector2 GetOrigin() {
        return this.origin;
    }

    public void SetOrigin(MmgVector2 v) {
        this.origin = v;
    }

    public MmgVector2 GetScaling() {
        return this.scaling;
    }

    public void SetScaling(MmgVector2 v) {
        this.scaling = v;
    }

    public int GetFrameIdx() {
        return this.frameIdx;
    }

    public void SetFrameIdx(int f) {
        this.frameIdx = f;
    }

    public boolean IsFrameNull(int i) {
        return i < 0 || i >= this.b.length || this.b == null || this.b[i] == null;
    }

    public int GetFrameStart() {
        return this.frameStart;
    }

    public void SetFrameStart(int f) {
        this.frameStart = f;
    }

    public int GetFrameStop() {
        return this.frameStop;
    }

    public void SetFrameStop(int f) {
        this.frameStop = f;
    }

    public long GetMsPerFrame() {
        return this.msPerFrame;
    }

    public void SetMsPerFrame(long f) {
        this.msPerFrame = f;
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible() && this.b[this.frameIdx] != null) {
            if (this.GetSimpleRendering()) {
                p.DrawBmp(this.b[this.frameIdx], this.GetPosition());
            } else if (this.GetSrcRect() == null || this.GetDstRect() == null) {
                if (this.GetOrigin() == null) {
                    if ((double)this.GetRotation() == 0.0) {
                        p.DrawBmp(this.b[this.frameIdx], this.GetPosition());
                    } else {
                        p.DrawBmp(this.b[this.frameIdx], this.GetPosition(), this.GetRotation());
                    }
                } else {
                    p.DrawBmp(this.b[this.frameIdx], this.GetPosition(), this.GetOrigin(), this.GetRotation());
                }
            } else {
                p.DrawBmp(this.b[this.frameIdx], this.GetPosition(), this.GetSrcRect(), this.GetDstRect(), this.GetScaling(), this.GetOrigin(), this.GetRotation());
            }
        }
    }

    @Override
    public boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        boolean ret = false;
        if (this.GetIsVisible()) {
            this.prevFrameTime = this.frameTime;
            this.frameTime += msSinceLastFrame;
            if (this.frameTime >= this.msPerFrame || this.prevFrameTime == -1L) {
                if (this.onFrameChange != null) {
                    this.onFrameChange.MmgHandleEvent(this.frameChange);
                }
                if (!this.timerOnly) {
                    ++this.frameIdx;
                    if (this.frameIdx > this.frameStop) {
                        this.frameIdx = this.frameStart;
                    }
                    this.frameTime = 0L;
                } else {
                    this.frameTime = 0L;
                }
                ret = true;
            }
        }
        return ret;
    }
}

