/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgGameScreen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgUpdateHandler;

public class MmgSplashScreen
extends MmgGameScreen
implements MmgUpdateHandler {
    private int displayTime;
    private MmgUpdateHandler update;
    public final int DEFAULT_DISPLAY_TIME_MS = 3000;

    public MmgSplashScreen(int DisplayTime) {
        this.displayTime = DisplayTime;
    }

    public MmgSplashScreen(MmgSplashScreen mls) {
        super(mls);
        this.SetBackground(mls.GetBackground());
        this.SetFooter(mls.GetFooter());
        this.SetHeader(mls.GetHeader());
        this.SetHeight(mls.GetHeight());
        this.SetIsVisible(mls.GetIsVisible());
        this.SetLeftCursor(mls.GetLeftCursor());
        this.SetRightCursor(mls.GetRightCursor());
        this.SetWidth(mls.GetWidth());
        this.displayTime = 3000;
    }

    public MmgSplashScreen() {
        this.displayTime = 3000;
    }

    public void StartDisplay() {
        MmgSplashScreenTimer s = new MmgSplashScreenTimer(this.displayTime);
        s.SetUpdateHandler(this);
        MmgSplashScreenTimer r = s;
        Thread t = new Thread(r);
        t.start();
    }

    public void SetUpdateHandler(MmgUpdateHandler Update) {
        this.update = Update;
    }

    @Override
    public void MmgHandleUpdate(Object obj) {
        if (this.update != null) {
            this.update.MmgHandleUpdate(obj);
        }
    }

    @Override
    public MmgObj Clone() {
        MmgSplashScreen ret = new MmgSplashScreen(this);
        return ret;
    }

    @Override
    public void SetCenteredBackground(MmgObj b) {
        MmgHelper.CenterHorAndVert(b);
        super.SetBackground(b);
    }

    public int GetDisplayTime() {
        return this.displayTime;
    }

    public void SetDisplayTime(int DisplayTime) {
        this.displayTime = DisplayTime;
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible()) {
            super.MmgDraw(p);
        }
    }

    public class MmgSplashScreenTimer
    implements Runnable {
        private final long displayTime;
        private MmgUpdateHandler update;

        public MmgSplashScreenTimer(long DisplayTime) {
            this.displayTime = DisplayTime;
        }

        public void SetUpdateHandler(MmgUpdateHandler Update) {
            this.update = Update;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.displayTime);
                if (this.update != null) {
                    this.update.MmgHandleUpdate(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

