/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgDebug;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgSizeTween
extends MmgObj {
    public static final int MMG_SIZE_TWEEN_REACH_FINISH = 0;
    public static final int MMG_SIZE_TWEEN_REACH_START = 1;
    public static final int MMG_SIZE_TWEEN_REACH_FINISH_TYPE = 0;
    public static final int MMG_SIZE_TWEEN_REACH_START_TYPE = 1;
    private MmgObj subj;
    private boolean atStart;
    private boolean atFinish;
    private MmgVector2 pixelSizeToChange;
    private float msSizeToChange;
    private float pixelsPerMsToChangeX;
    private float pixelsPerMsToChangeY;
    private MmgVector2 startSize;
    private MmgVector2 finishSize;
    private boolean dirStartToFinish;
    private boolean changing;
    private long msStartChange;
    private MmgVector2 tmpV;
    private MmgEventHandler onReachFinish;
    private MmgEventHandler onReachStart;
    private final MmgEvent reachFinish = new MmgEvent(null, "reach_finish", 0, 0, null, null);
    private final MmgEvent reachStart = new MmgEvent(null, "reach_start", 1, 1, null, null);

    public MmgSizeTween(MmgObj subj, float msTimeToChange, MmgVector2 startSize, MmgVector2 finishSize) {
        MmgDebug.wr("MmgSizeTween Found start pos: " + startSize.ToString() + ", " + msTimeToChange);
        MmgDebug.wr("MmgSizeTween Found end pos: " + finishSize.ToString());
        this.SetSubj(subj);
        this.SetPixelSizeToChange(new MmgVector2(finishSize.GetX() - startSize.GetX(), finishSize.GetY() - startSize.GetY()));
        this.SetMsTimeToChange(msTimeToChange);
        this.SetPixelsPerMsToChangeX((float)this.GetPixelSizeToChange().GetX() / msTimeToChange);
        this.SetPixelsPerMsToChangeY((float)this.GetPixelSizeToChange().GetY() / msTimeToChange);
        this.SetStartSize(startSize);
        this.SetFinishSize(finishSize);
        this.SetWidth(startSize.GetX());
        this.SetHeight(startSize.GetY());
        this.SetDirStartToFinish(true);
        this.SetAtStart(true);
        this.SetAtFinish(false);
        this.SetChanging(false);
        MmgDebug.wr("Found pixels per ms Y: " + this.pixelsPerMsToChangeY);
    }

    public MmgSizeTween(float msTimeToChange, MmgVector2 startSize, MmgVector2 finishSize) {
        MmgDebug.wr("MmgSizeTween Found start pos: " + startSize.ToString() + ", " + msTimeToChange);
        MmgDebug.wr("MmgSizeTween Found end pos: " + finishSize.ToString());
        this.SetSubj(this.subj);
        this.SetPixelSizeToChange(new MmgVector2(finishSize.GetX() - startSize.GetX(), finishSize.GetY() - startSize.GetY()));
        this.SetMsTimeToChange(msTimeToChange);
        this.SetPixelsPerMsToChangeX((float)this.GetPixelSizeToChange().GetX() / msTimeToChange);
        this.SetPixelsPerMsToChangeY((float)this.GetPixelSizeToChange().GetY() / msTimeToChange);
        this.SetStartSize(startSize);
        this.SetFinishSize(finishSize);
        this.SetWidth(startSize.GetX());
        this.SetHeight(startSize.GetY());
        this.SetDirStartToFinish(true);
        this.SetAtStart(true);
        this.SetAtFinish(false);
        this.SetChanging(false);
        MmgDebug.wr("Found pixels per ms Y: " + this.pixelsPerMsToChangeY);
    }

    public void SetFinishEventId(int i) {
        if (this.reachFinish != null) {
            this.reachFinish.SetEventId(i);
        }
    }

    public void SetStartEventId(int i) {
        if (this.reachStart != null) {
            this.reachStart.SetEventId(i);
        }
    }

    public MmgEventHandler GetOnReachFinish() {
        return this.onReachFinish;
    }

    public void SetOnReachFinish(MmgEventHandler o) {
        this.onReachFinish = o;
    }

    public MmgEventHandler GetOnReachStart() {
        return this.onReachStart;
    }

    public void SetOnReachStart(MmgEventHandler o) {
        this.onReachStart = o;
    }

    public long GetMsStartChange() {
        return this.msStartChange;
    }

    public void SetMsStartChange(long l) {
        this.msStartChange = l;
    }

    public float GetPixelsPerMsToChangeX() {
        return this.pixelsPerMsToChangeX;
    }

    public void SetPixelsPerMsToChangeX(float i) {
        this.pixelsPerMsToChangeX = i;
    }

    public float GetPixelsPerMsToChangeY() {
        return this.pixelsPerMsToChangeY;
    }

    public void SetPixelsPerMsToChangeY(float i) {
        this.pixelsPerMsToChangeY = i;
    }

    public boolean GetChanging() {
        return this.changing;
    }

    public void SetChanging(boolean b) {
        this.changing = b;
    }

    public boolean GetDirStartToFinish() {
        return this.dirStartToFinish;
    }

    public void SetDirStartToFinish(boolean b) {
        this.dirStartToFinish = b;
    }

    public MmgVector2 GetStartSize() {
        return this.startSize;
    }

    public void SetStartSize(MmgVector2 v) {
        this.startSize = v;
    }

    public MmgVector2 GetFinishSize() {
        return this.finishSize;
    }

    public void SetFinishSize(MmgVector2 v) {
        this.finishSize = v;
    }

    public MmgVector2 GetPixelSizeToChange() {
        return this.pixelSizeToChange;
    }

    public void SetPixelSizeToChange(MmgVector2 v) {
        this.pixelSizeToChange = v;
    }

    public float GetMsTimeToChange() {
        return this.msSizeToChange;
    }

    public void SetMsTimeToChange(float i) {
        this.msSizeToChange = i;
    }

    public void SetAtStart(boolean b) {
        this.atStart = b;
    }

    public boolean GetAtStart() {
        return this.atStart;
    }

    public void SetAtFinish(boolean b) {
        this.atFinish = b;
    }

    public boolean GetAtFinish() {
        return this.atFinish;
    }

    public void SetSubj(MmgObj b) {
        this.subj = b;
    }

    public MmgObj GetSubj() {
        return this.subj;
    }

    @Override
    public MmgObj Clone() {
        MmgSizeTween ret = new MmgSizeTween(this.GetSubj(), this.GetMsTimeToChange(), this.GetStartSize(), this.GetFinishSize());
        ret.SetAtStart(this.GetAtStart());
        ret.SetAtFinish(this.GetAtFinish());
        ret.SetDirStartToFinish(this.GetDirStartToFinish());
        ret.SetChanging(this.GetChanging());
        ret.SetMsStartChange(this.GetMsStartChange());
        ret.SetPixelsPerMsToChangeX(this.GetPixelsPerMsToChangeX());
        ret.SetPixelsPerMsToChangeY(this.GetPixelsPerMsToChangeY());
        return ret;
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible()) {
            this.subj.MmgDraw(p);
        }
    }

    @Override
    public boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        boolean ret = false;
        if (this.GetIsVisible() && this.GetChanging()) {
            if (this.GetDirStartToFinish()) {
                if ((float)(currentTimeMs - this.msStartChange) >= this.msSizeToChange) {
                    this.SetAtFinish(true);
                    this.SetAtStart(false);
                    this.SetChanging(false);
                    this.SetWidth(this.finishSize.GetX());
                    this.SetHeight(this.finishSize.GetY());
                    if (this.onReachFinish != null) {
                        this.onReachFinish.MmgHandleEvent(this.reachFinish);
                    }
                } else {
                    this.tmpV = new MmgVector2((float)this.startSize.GetX() + this.pixelsPerMsToChangeX * (float)(currentTimeMs - this.msStartChange), (float)this.startSize.GetY() + this.pixelsPerMsToChangeY * (float)(currentTimeMs - this.msStartChange));
                    this.SetWidth(this.tmpV.GetX());
                    this.SetHeight(this.tmpV.GetY());
                }
            } else {
                MmgDebug.wr("changing finish to start " + (currentTimeMs - this.msStartChange) + ", " + this.msSizeToChange);
                if ((float)(currentTimeMs - this.msStartChange) >= this.msSizeToChange) {
                    this.SetAtFinish(false);
                    this.SetAtStart(true);
                    this.SetChanging(false);
                    this.SetWidth(this.startSize.GetX());
                    this.SetHeight(this.startSize.GetY());
                    if (this.onReachStart != null) {
                        this.onReachStart.MmgHandleEvent(this.reachStart);
                    }
                } else {
                    this.tmpV = new MmgVector2((float)this.finishSize.GetX() - this.pixelsPerMsToChangeX * (float)(currentTimeMs - this.msStartChange), (float)this.finishSize.GetY() - this.pixelsPerMsToChangeY * (float)(currentTimeMs - this.msStartChange));
                    this.SetWidth(this.tmpV.GetX());
                    this.SetHeight(this.tmpV.GetY());
                }
            }
        }
        return ret;
    }

    @Override
    public int GetWidth() {
        return this.subj.GetWidth();
    }

    @Override
    public void SetWidth(int w) {
        this.subj.SetWidth(w);
    }

    @Override
    public int GetHeight() {
        return this.subj.GetHeight();
    }

    @Override
    public void SetHeight(int h) {
        this.subj.SetHeight(h);
    }

    @Override
    public MmgVector2 GetPosition() {
        return this.subj.GetPosition();
    }

    @Override
    public void SetPosition(MmgVector2 v) {
        this.subj.SetPosition(v);
    }

    public void SetSize(MmgVector2 v) {
        this.subj.SetWidth(v.GetX());
        this.subj.SetHeight(v.GetY());
    }

    public boolean Equals(MmgSizeTween r) {
        return this.GetSubj().Equals(r.GetSubj()) && this.GetAtStart() == r.GetAtStart() && this.GetAtFinish() == r.GetAtFinish() && this.GetPixelSizeToChange().Equals(r.GetPixelSizeToChange()) && this.GetMsTimeToChange() == r.GetMsTimeToChange() && this.GetPixelsPerMsToChangeX() == r.GetPixelsPerMsToChangeX() && this.GetPixelsPerMsToChangeY() == r.GetPixelsPerMsToChangeY() && this.GetStartSize().Equals(r.GetStartSize()) && this.GetFinishSize().Equals(r.GetFinishSize()) && this.GetDirStartToFinish() == r.GetDirStartToFinish() && this.GetChanging() == r.GetChanging();
    }
}

