/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import java.awt.Rectangle;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgRect {
    private Rectangle rect;

    public MmgRect() {
        this.rect = new Rectangle(0, 0, 0, 0);
    }

    public MmgRect(MmgRect r) {
        this.rect = r.GetRect();
    }

    public MmgRect(int left, int top, int bottom, int right) {
        this.rect = new Rectangle(left, top, right - left, bottom - top);
    }

    public MmgRect(MmgVector2 v, int w, int h) {
        this.rect = new Rectangle(v.GetX(), v.GetY(), w, h);
    }

    public void ShiftRect(int shiftLeftRight, int shiftUpDown) {
        this.rect = new Rectangle(this.rect.x + shiftLeftRight, this.rect.y + shiftUpDown, this.rect.width, this.rect.height);
    }

    public MmgRect ToShiftedRect(int shiftLeftRight, int shiftUpDown) {
        return new MmgRect(this.rect.x + shiftLeftRight, this.rect.y + shiftUpDown, this.rect.width, this.rect.height);
    }

    public MmgRect Clone() {
        return new MmgRect(this.rect.x, this.rect.y, this.rect.y + this.rect.height, this.rect.x + this.rect.width);
    }

    public static MmgRect GetUnitRect() {
        return new MmgRect(0, 0, 1, 1);
    }

    public int GetLeft() {
        return this.rect.x;
    }

    public int GetTop() {
        return this.rect.y;
    }

    public int GetRight() {
        return this.rect.x + this.rect.width;
    }

    public int GetBottom() {
        return this.rect.y + this.rect.height;
    }

    public int GetWidth() {
        return this.rect.width;
    }

    public void SetWidth(int w) {
        this.rect.setSize(w, this.rect.height);
    }

    public int GetHeight() {
        return this.rect.height;
    }

    public void SetHeight(int h) {
        this.rect.setSize(this.rect.width, h);
    }

    public Rectangle GetRect() {
        return this.rect;
    }

    public void SetRect(Rectangle r) {
        this.rect = r;
    }

    public int GetDiffX(MmgRect inRect, int direction, boolean opposite, boolean left2right) {
        if (2 == direction && !opposite) {
            return this.GetLeft() - inRect.GetLeft();
        }
        if (2 == direction && opposite && left2right) {
            return this.GetRight() - inRect.GetLeft();
        }
        if (2 == direction && opposite && !left2right) {
            return inRect.GetLeft() - this.GetRight();
        }
        if (3 == direction && !opposite) {
            return this.GetRight() - inRect.GetRight();
        }
        if (3 == direction && opposite && left2right) {
            return this.GetRight() - inRect.GetLeft();
        }
        if (3 == direction && opposite && !left2right) {
            return inRect.GetLeft() - this.GetRight();
        }
        return 0;
    }

    public int GetDiffX(int x, int direction, boolean opposite, boolean left2right) {
        if (2 == direction && !opposite) {
            return this.GetLeft() - x;
        }
        if (2 == direction && opposite && left2right) {
            return this.GetLeft() - x;
        }
        if (2 == direction && opposite && !left2right) {
            return x - this.GetLeft();
        }
        if (3 == direction && !opposite) {
            return this.GetRight() - x;
        }
        if (3 == direction && opposite && left2right) {
            return this.GetRight() - x;
        }
        if (3 == direction && opposite && !left2right) {
            return x - this.GetRight();
        }
        return 0;
    }

    public int GetDiffY(MmgRect inRect, int direction, boolean opposite, boolean left2right) {
        if (1 == direction && !opposite) {
            return this.GetTop() - inRect.GetTop();
        }
        if (1 == direction && opposite && left2right) {
            return this.GetBottom() - inRect.GetTop();
        }
        if (1 == direction && opposite && !left2right) {
            return inRect.GetTop() - this.GetBottom();
        }
        if (0 == direction && !opposite) {
            return this.GetBottom() - inRect.GetBottom();
        }
        if (0 == direction && opposite && left2right) {
            return this.GetBottom() - inRect.GetTop();
        }
        if (0 == direction && opposite && !left2right) {
            return inRect.GetTop() - this.GetBottom();
        }
        return 0;
    }

    public int GetDiffY(int y, int direction, boolean opposite, boolean left2right) {
        if (1 == direction && !opposite) {
            return this.GetLeft() - y;
        }
        if (1 == direction && opposite && left2right) {
            return this.GetLeft() - y;
        }
        if (1 == direction && opposite && !left2right) {
            return y - this.GetLeft();
        }
        if (0 == direction && !opposite) {
            return this.GetRight() - y;
        }
        if (0 == direction && opposite && left2right) {
            return this.GetRight() - y;
        }
        if (0 == direction && opposite && !left2right) {
            return y - this.GetRight();
        }
        return 0;
    }

    public MmgVector2 GetPosition() {
        return new MmgVector2(this.GetLeft(), this.GetTop());
    }

    public void SetPosition(MmgVector2 v) {
        this.rect.setLocation(v.GetX(), v.GetY());
    }

    public String ToString() {
        return "L: " + this.GetLeft() + " R: " + this.GetRight() + " T: " + this.GetTop() + " B: " + this.GetBottom() + ", W: " + this.GetWidth() + " H: " + this.GetHeight();
    }

    public boolean Equals(MmgRect r) {
        return this.GetLeft() == r.GetLeft() && this.GetRight() == r.GetRight() && this.GetTop() == r.GetTop() && this.GetBottom() == r.GetBottom();
    }
}

