/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgDebug;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEventHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgPositionTween
extends MmgObj {
    public static final int MMG_POSITION_TWEEN_REACH_FINISH = 0;
    public static final int MMG_POSITION_TWEEN_REACH_START = 1;
    public static final int MMG_POSITION_TWEEN_REACH_FINISH_TYPE = 0;
    public static final int MMG_POSITION_TWEEN_REACH_START_TYPE = 1;
    private MmgObj subj;
    private boolean atStart;
    private boolean atFinish;
    private MmgVector2 pixelDistToMove;
    private float msTimeToMove;
    private float pixelsPerMsToMoveX;
    private float pixelsPerMsToMoveY;
    private MmgVector2 startPosition;
    private MmgVector2 finishPosition;
    private boolean dirStartToFinish;
    private boolean moving;
    private long msStartMove;
    private MmgEventHandler onReachFinish;
    private MmgEventHandler onReachStart;
    private final MmgEvent reachFinish = new MmgEvent(null, "reach_finish", 0, 0, null, null);
    private final MmgEvent reachStart = new MmgEvent(null, "reach_start", 1, 1, null, null);

    public MmgPositionTween(MmgObj subj, float msTimeToMove, MmgVector2 startPos, MmgVector2 finishPos) {
        MmgDebug.wr("MmgPositionTween Found start pos: " + startPos.ToString() + ", " + msTimeToMove);
        MmgDebug.wr("MmgPositionTween Found end pos: " + finishPos.ToString());
        this.SetSubj(subj);
        this.SetPixelDistToMove(new MmgVector2(finishPos.GetX() - startPos.GetX(), finishPos.GetY() - startPos.GetY()));
        this.SetMsTimeToMove(msTimeToMove);
        this.SetPixelsPerMsToMoveX((float)this.GetPixelDistToMove().GetX() / msTimeToMove);
        this.SetPixelsPerMsToMoveY((float)this.GetPixelDistToMove().GetY() / msTimeToMove);
        this.SetStartPosition(startPos);
        this.SetFinishPosition(finishPos);
        this.SetPosition(startPos);
        this.SetDirStartToFinish(true);
        this.SetAtStart(true);
        this.SetAtFinish(false);
        this.SetMoving(false);
        MmgDebug.wr("Found pixels per ms Y: " + this.pixelsPerMsToMoveY);
    }

    public MmgPositionTween(float msTimeToMove, MmgVector2 startPos, MmgVector2 finishPos) {
        MmgDebug.wr("MmgPositionTween Found start pos: " + startPos.ToString());
        MmgDebug.wr("MmgPositionTween Found end pos: " + finishPos.ToString());
        this.SetSubj(this.subj);
        this.SetPixelDistToMove(new MmgVector2(finishPos.GetX() - startPos.GetX(), finishPos.GetY() - startPos.GetY()));
        this.SetMsTimeToMove(msTimeToMove);
        this.SetPixelsPerMsToMoveX((int)((float)this.GetPixelDistToMove().GetX() / msTimeToMove));
        this.SetPixelsPerMsToMoveY((int)((float)this.GetPixelDistToMove().GetY() / msTimeToMove));
        this.SetStartPosition(startPos);
        this.SetFinishPosition(finishPos);
        this.SetPosition(startPos);
        this.SetDirStartToFinish(true);
        this.SetAtStart(true);
        this.SetAtFinish(false);
        this.SetMoving(false);
    }

    public void SetFinishEventId(int i) {
        if (this.reachFinish != null) {
            this.reachFinish.SetEventId(i);
        }
    }

    public void SetStartEventId(int i) {
        if (this.reachStart != null) {
            this.reachStart.SetEventId(i);
        }
    }

    public MmgEventHandler GetOnReachFinish() {
        return this.onReachFinish;
    }

    public void SetOnReachFinish(MmgEventHandler o) {
        this.onReachFinish = o;
    }

    public MmgEventHandler GetOnReachStart() {
        return this.onReachStart;
    }

    public void SetOnReachStart(MmgEventHandler o) {
        this.onReachStart = o;
    }

    public long GetMsStartMove() {
        return this.msStartMove;
    }

    public void SetMsStartMove(long l) {
        this.msStartMove = l;
    }

    public float GetPixelsPerMsToMoveX() {
        return this.pixelsPerMsToMoveX;
    }

    public void SetPixelsPerMsToMoveX(float i) {
        this.pixelsPerMsToMoveX = i;
    }

    public float GetPixelsPerMsToMoveY() {
        return this.pixelsPerMsToMoveY;
    }

    public void SetPixelsPerMsToMoveY(float i) {
        this.pixelsPerMsToMoveY = i;
    }

    public boolean GetMoving() {
        return this.moving;
    }

    public void SetMoving(boolean b) {
        this.moving = b;
    }

    public boolean GetDirStartToFinish() {
        return this.dirStartToFinish;
    }

    public void SetDirStartToFinish(boolean b) {
        this.dirStartToFinish = b;
    }

    public MmgVector2 GetStartPosition() {
        return this.startPosition;
    }

    public void SetStartPosition(MmgVector2 v) {
        this.startPosition = v;
    }

    public MmgVector2 GetFinishPosition() {
        return this.finishPosition;
    }

    public void SetFinishPosition(MmgVector2 v) {
        this.finishPosition = v;
    }

    public MmgVector2 GetPixelDistToMove() {
        return this.pixelDistToMove;
    }

    public void SetPixelDistToMove(MmgVector2 v) {
        this.pixelDistToMove = v;
    }

    public float GetMsTimeToMove() {
        return this.msTimeToMove;
    }

    public void SetMsTimeToMove(float i) {
        this.msTimeToMove = i;
    }

    public void SetAtStart(boolean b) {
        this.atStart = b;
    }

    public boolean GetAtStart() {
        return this.atStart;
    }

    public void SetAtFinish(boolean b) {
        this.atFinish = b;
    }

    public boolean GetAtFinish() {
        return this.atFinish;
    }

    public void SetSubj(MmgObj b) {
        this.subj = b;
    }

    public MmgObj GetSubj() {
        return this.subj;
    }

    @Override
    public MmgObj Clone() {
        MmgPositionTween ret = new MmgPositionTween(this.GetSubj(), this.GetMsTimeToMove(), this.GetStartPosition(), this.GetFinishPosition());
        ret.SetAtStart(this.GetAtStart());
        ret.SetAtFinish(this.GetAtFinish());
        ret.SetDirStartToFinish(this.GetDirStartToFinish());
        ret.SetMoving(this.GetMoving());
        ret.SetMsStartMove(this.GetMsStartMove());
        ret.SetPixelsPerMsToMoveX(this.GetPixelsPerMsToMoveX());
        ret.SetPixelsPerMsToMoveY(this.GetPixelsPerMsToMoveY());
        return ret;
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible()) {
            this.subj.MmgDraw(p);
        }
    }

    @Override
    public boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        boolean ret = false;
        if (this.GetIsVisible() && this.GetMoving()) {
            if (this.GetDirStartToFinish()) {
                if ((float)(currentTimeMs - this.msStartMove) >= this.msTimeToMove) {
                    this.SetAtFinish(true);
                    this.SetAtStart(false);
                    this.SetMoving(false);
                    this.SetPosition(this.finishPosition);
                    if (this.onReachFinish != null) {
                        this.onReachFinish.MmgHandleEvent(this.reachFinish);
                    }
                } else {
                    this.SetPosition(new MmgVector2((float)this.startPosition.GetX() + this.pixelsPerMsToMoveX * (float)(currentTimeMs - this.msStartMove), (float)this.startPosition.GetY() + this.pixelsPerMsToMoveY * (float)(currentTimeMs - this.msStartMove)));
                }
            } else {
                MmgDebug.wr("moving finish to start " + (currentTimeMs - this.msStartMove) + ", " + this.msTimeToMove);
                if ((float)(currentTimeMs - this.msStartMove) >= this.msTimeToMove) {
                    this.SetAtFinish(false);
                    this.SetAtStart(true);
                    this.SetMoving(false);
                    this.SetPosition(this.startPosition);
                    if (this.onReachStart != null) {
                        this.onReachStart.MmgHandleEvent(this.reachStart);
                    }
                } else {
                    this.SetPosition(new MmgVector2((float)this.finishPosition.GetX() - this.pixelsPerMsToMoveX * (float)(currentTimeMs - this.msStartMove), (float)this.finishPosition.GetY() - this.pixelsPerMsToMoveY * (float)(currentTimeMs - this.msStartMove)));
                }
            }
        }
        return ret;
    }

    @Override
    public int GetWidth() {
        return this.subj.GetWidth();
    }

    @Override
    public void SetWidth(int w) {
        this.subj.SetWidth(w);
    }

    @Override
    public int GetHeight() {
        return this.subj.GetHeight();
    }

    @Override
    public void SetHeight(int h) {
        this.subj.SetHeight(h);
    }

    @Override
    public MmgVector2 GetPosition() {
        return this.subj.GetPosition();
    }

    @Override
    public void SetPosition(MmgVector2 v) {
        this.subj.SetPosition(v);
    }

    public boolean Equals(MmgPositionTween r) {
        return this.GetSubj().Equals(r.GetSubj()) && this.GetAtStart() == r.GetAtStart() && this.GetAtFinish() == r.GetAtFinish() && this.GetPixelDistToMove().Equals(r.GetPixelDistToMove()) && this.GetMsTimeToMove() == r.GetMsTimeToMove() && this.GetPixelsPerMsToMoveX() == r.GetPixelsPerMsToMoveX() && this.GetPixelsPerMsToMoveY() == r.GetPixelsPerMsToMoveY() && this.GetStartPosition().Equals(r.GetStartPosition()) && this.GetFinishPosition().Equals(r.GetFinishPosition()) && this.GetDirStartToFinish() == r.GetDirStartToFinish() && this.GetMoving() == r.GetMoving();
    }
}

