/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.MmgApiUtils;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFont;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMediaTracker;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgPen {
    private Graphics pen;
    private Color color;
    private Image tmpImg;
    private String tmpIdStr;
    private boolean cacheOn;
    public static boolean ADV_RENDER_HINTS = true;
    private Font tmpF;
    private Color tmpC;

    public MmgPen() {
        this.cacheOn = false;
    }

    public MmgPen(Graphics p) {
        this.pen = p;
        this.cacheOn = false;
    }

    public MmgPen(Graphics p, Color c) {
        this.pen = p;
        this.color = c;
        this.cacheOn = false;
    }

    public void SetCacheOn(boolean b) {
        this.cacheOn = b;
    }

    public boolean GetCacheOn() {
        return this.cacheOn;
    }

    public void DrawText(MmgFont f) {
        this.tmpF = this.pen.getFont();
        this.tmpC = this.pen.getColor();
        this.pen.setColor(f.GetMmgColor().GetColor());
        this.pen.setFont(f.GetFont());
        this.pen.drawString(f.GetText(), f.GetPosition().GetX(), f.GetPosition().GetY());
        this.pen.setFont(this.tmpF);
        this.pen.setColor(this.tmpC);
    }

    public final Image RotateImage(int width, int height, Image img, int angle, int originX, int originY) {
        return MmgPen.RotateImageStatic(width, height, img, angle, originX, originY);
    }

    public static Image RotateImageStatic(int width, int height, Image img, int angle, int originX, int originY) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        if (ADV_RENDER_HINTS) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        AffineTransform at = new AffineTransform();
        if (originX == -1 || originY == -1) {
            at.rotate(Math.toRadians(angle), width / 2, height / 2);
        } else {
            at.rotate(Math.toRadians(angle), originX, originY);
        }
        g.drawImage(img, 0, 0, null);
        AffineTransformOp op = new AffineTransformOp(at, 2);
        bi = op.filter(bi, null);
        g.dispose();
        return bi;
    }

    public final Image ScaleImage(Image img, double scaleX, double scaleY) {
        return MmgPen.ScaleImageStatic(img, scaleX, scaleY);
    }

    public static Image ScaleImage(Image img, MmgVector2 scale) {
        return MmgPen.ScaleImageStatic(img, scale.GetXDouble(), scale.GetYDouble());
    }

    public static Image ScaleImageStatic(Image img, double scaleX, double scaleY) {
        int w = (int)((double)img.getWidth(null) * scaleX);
        int h = (int)((double)img.getHeight(null) * scaleY);
        BufferedImage rImage = new BufferedImage(w, h, 2);
        Graphics2D g = rImage.createGraphics();
        g.drawImage(img, 0, 0, w, h, null);
        if (ADV_RENDER_HINTS) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.dispose();
        return rImage;
    }

    public static Image CreateColorTile(int w, int h, MmgColor c) {
        BufferedImage rImage = new BufferedImage(w, h, 2);
        Graphics2D g = rImage.createGraphics();
        g.setColor(c.GetColor());
        g.fillRect(0, 0, w, h);
        g.dispose();
        return rImage;
    }

    public void SetAdvRenderHints() {
        if (ADV_RENDER_HINTS) {
            Graphics2D g = (Graphics2D)this.pen;
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            MmgApiUtils.wr("ADV_RENDER_HINTS is set to false.");
        }
    }

    public void DrawBmpBasic(String idStr, MmgVector2 position) {
        this.tmpImg = MmgMediaTracker.GetValue(idStr);
        if (this.tmpImg != null) {
            this.DrawBmp(this.tmpImg, position.GetX(), position.GetY());
        }
    }

    public void DrawBmp(Image img, int x, int y) {
        this.pen.drawImage(img, x, y, null);
    }

    public void DrawBmpBasic(MmgBmp b) {
        this.DrawBmp(b, b.GetPosition());
    }

    public void DrawBmpFromCache(MmgBmp b) {
        this.DrawBmpBasic(b.GetBmpIdStr(), b.GetPosition());
    }

    public void DrawBmp(MmgBmp b, MmgVector2 position) {
        if (this.color != null) {
            this.pen.drawImage(b.GetTexture2D(), position.GetX(), position.GetY(), this.color, null);
        } else if (b.GetMmgColor() != null) {
            this.pen.drawImage(b.GetTexture2D(), position.GetX(), position.GetY(), b.GetMmgColor().GetColor(), null);
        } else {
            this.pen.drawImage(b.GetTexture2D(), position.GetX(), position.GetY(), null);
        }
    }

    public void DrawBmp(MmgBmp b, int x, int y) {
        if (this.color != null) {
            this.pen.drawImage(b.GetTexture2D(), x, y, this.color, null);
        } else if (b.GetMmgColor() != null) {
            this.pen.drawImage(b.GetTexture2D(), x, y, b.GetMmgColor().GetColor(), null);
        } else {
            this.pen.drawImage(b.GetTexture2D(), x, y, null);
        }
    }

    public void DrawBmp(MmgBmp b, MmgVector2 position, float rotation) {
        this.DrawBmp(b, position, new MmgVector2(-1.0, -1.0), rotation);
    }

    public void DrawBmp(MmgBmp b, MmgVector2 position, MmgVector2 origin, float rotation) {
        this.tmpIdStr = b.GetIdStr(rotation);
        if (rotation != 0.0f) {
            if (this.cacheOn && MmgMediaTracker.HasKey(this.tmpIdStr)) {
                this.tmpImg = MmgMediaTracker.GetValue(this.tmpIdStr);
            } else {
                this.tmpImg = this.RotateImage(b.GetWidth(), b.GetHeight(), b.GetTexture2D(), (int)rotation, origin.GetX(), origin.GetY());
                if (this.cacheOn) {
                    MmgMediaTracker.CacheImage(this.tmpIdStr, this.tmpImg);
                }
            }
        } else {
            this.tmpImg = b.GetTexture2D();
        }
        if (this.color != null) {
            this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), this.color, null);
        } else if (b.GetMmgColor() != null) {
            this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), b.GetMmgColor().GetColor(), null);
        } else {
            this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), null);
        }
    }

    public void DrawBmp(MmgBmp b, MmgVector2 position, MmgRect srcRect, MmgRect dstRect, MmgVector2 scaling, MmgVector2 origin, float rotation) {
        this.tmpIdStr = rotation != 0.0f && scaling != null && (scaling.GetXDouble() != 1.0 || scaling.GetYDouble() != 1.0) ? b.GetIdStr(rotation, scaling) : (rotation != 0.0f ? b.GetIdStr(rotation) : (scaling != null && (scaling.GetXDouble() != 1.0 || scaling.GetYDouble() != 1.0) ? b.GetIdStr(scaling) : b.GetBmpIdStr()));
        if (this.cacheOn && MmgMediaTracker.HasKey(this.tmpIdStr)) {
            this.tmpImg = MmgMediaTracker.GetValue(this.tmpIdStr);
        } else if (rotation != 0.0f && scaling != null && (scaling.GetXDouble() != 1.0 || scaling.GetYDouble() != 1.0)) {
            if (this.cacheOn && MmgMediaTracker.HasKey(b.GetIdStr(rotation))) {
                this.tmpImg = MmgMediaTracker.GetValue(b.GetIdStr(rotation));
            } else {
                this.tmpImg = this.RotateImage(b.GetWidth(), b.GetHeight(), b.GetTexture2D(), (int)rotation, origin.GetX(), origin.GetY());
                if (this.cacheOn) {
                    MmgMediaTracker.CacheImage(b.GetIdStr(rotation), this.tmpImg);
                }
            }
            this.tmpImg = this.ScaleImage(this.tmpImg, scaling.GetXDouble(), scaling.GetYDouble());
            if (this.cacheOn) {
                MmgMediaTracker.CacheImage(this.tmpIdStr, this.tmpImg);
            }
        } else if (rotation != 0.0f) {
            if (this.cacheOn && MmgMediaTracker.HasKey(this.tmpIdStr)) {
                this.tmpImg = MmgMediaTracker.GetValue(this.tmpIdStr);
            } else {
                this.tmpImg = this.RotateImage(b.GetWidth(), b.GetHeight(), b.GetTexture2D(), (int)rotation, origin.GetX(), origin.GetY());
                if (this.cacheOn) {
                    MmgMediaTracker.CacheImage(this.tmpIdStr, this.tmpImg);
                }
            }
        } else if (scaling != null && (scaling.GetXDouble() != 1.0 || scaling.GetYDouble() != 1.0)) {
            if (this.cacheOn && MmgMediaTracker.HasKey(this.tmpIdStr)) {
                this.tmpImg = MmgMediaTracker.GetValue(this.tmpIdStr);
            } else {
                this.tmpImg = this.ScaleImage(this.tmpImg, scaling.GetXDouble(), scaling.GetYDouble());
                if (this.cacheOn) {
                    MmgMediaTracker.CacheImage(this.tmpIdStr, this.tmpImg);
                }
            }
        } else {
            this.tmpImg = b.GetTexture2D();
        }
        if (dstRect == null) {
            if (srcRect == null) {
                if (this.color != null) {
                    this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), this.color, null);
                } else if (b.GetMmgColor() != null) {
                    this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), b.GetMmgColor().GetColor(), null);
                } else {
                    this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), null);
                }
            } else if (this.color != null) {
                this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), position.GetX() + srcRect.GetWidth(), position.GetY() + srcRect.GetHeight(), srcRect.GetLeft(), srcRect.GetTop(), srcRect.GetRight(), srcRect.GetBottom(), this.color, null);
            } else if (b.GetMmgColor() != null) {
                this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), position.GetX() + srcRect.GetWidth(), position.GetY() + srcRect.GetHeight(), srcRect.GetLeft(), srcRect.GetTop(), srcRect.GetRight(), srcRect.GetBottom(), b.GetMmgColor().GetColor(), null);
            } else {
                this.pen.drawImage(this.tmpImg, position.GetX(), position.GetY(), position.GetX() + srcRect.GetWidth(), position.GetY() + srcRect.GetHeight(), srcRect.GetLeft(), srcRect.GetTop(), srcRect.GetRight(), srcRect.GetBottom(), null);
            }
        } else if (srcRect == null) {
            if (this.color != null) {
                this.pen.drawImage(this.tmpImg, dstRect.GetLeft(), dstRect.GetTop(), dstRect.GetRight(), dstRect.GetBottom(), 0, 0, b.GetWidth(), b.GetHeight(), this.color, null);
            } else if (b.GetMmgColor() != null) {
                this.pen.drawImage(this.tmpImg, dstRect.GetLeft(), dstRect.GetTop(), dstRect.GetRight(), dstRect.GetBottom(), 0, 0, b.GetWidth(), b.GetHeight(), b.GetMmgColor().GetColor(), null);
            } else {
                this.pen.drawImage(this.tmpImg, dstRect.GetLeft(), dstRect.GetTop(), dstRect.GetRight(), dstRect.GetBottom(), 0, 0, b.GetWidth(), b.GetHeight(), null);
            }
        } else if (this.color != null) {
            this.pen.drawImage(this.tmpImg, dstRect.GetLeft(), dstRect.GetTop(), dstRect.GetRight(), dstRect.GetBottom(), srcRect.GetLeft(), srcRect.GetTop(), srcRect.GetRight(), srcRect.GetBottom(), this.color, null);
        } else if (b.GetMmgColor() != null) {
            this.pen.drawImage(this.tmpImg, dstRect.GetLeft(), dstRect.GetTop(), dstRect.GetRight(), dstRect.GetBottom(), srcRect.GetLeft(), srcRect.GetTop(), srcRect.GetRight(), srcRect.GetBottom(), b.GetMmgColor().GetColor(), null);
        } else {
            this.pen.drawImage(this.tmpImg, dstRect.GetLeft(), dstRect.GetTop(), dstRect.GetRight(), dstRect.GetBottom(), srcRect.GetLeft(), srcRect.GetTop(), srcRect.GetRight(), srcRect.GetBottom(), null);
        }
    }

    public void DrawBmp(MmgBmp b) {
        this.DrawBmp(b, b.GetPosition(), b.GetSrcRect(), b.GetDstRect(), b.GetScaling(), b.GetOrigin(), b.GetRotation());
    }

    public void DrawRect(MmgObj obj) {
        this.DrawRect(obj.GetPosition().GetX(), obj.GetPosition().GetY(), obj.GetWidth(), obj.GetHeight());
    }

    public void DrawRect(MmgObj obj, MmgVector2 pos) {
        this.DrawRect(pos.GetX(), pos.GetY(), obj.GetWidth(), obj.GetHeight());
    }

    public void DrawRect(MmgRect r) {
        this.DrawRect(r.GetLeft(), r.GetTop(), r.GetWidth(), r.GetHeight());
    }

    public void DrawRect(int x, int y, int w, int h) {
        this.pen.drawRect(x, y, w, h);
    }

    public Graphics GetSpriteBatch() {
        return this.pen;
    }

    public void SetSpriteBatch(Graphics sp) {
        this.pen = sp;
    }

    public void SetGraphics(Graphics sp) {
        this.SetSpriteBatch(sp);
    }

    public Graphics GetGraphics() {
        return this.GetSpriteBatch();
    }

    public void SetColor(Color c) {
        this.color = c;
    }

    public Color GetColor() {
        return this.color;
    }

    public void SetGraphicsColor(Color c) {
        this.color = c;
        this.pen.setColor(c);
    }

    public Color GetGraphicsColor() {
        return this.pen.getColor();
    }
}

