/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgHelper {
    public static boolean RectCollision(int r1x, int r1y, int w, int h, MmgRect r) {
        int r2x = r.GetLeft();
        int r2y = r.GetTop();
        return MmgHelper.RectCollision(r1x, r1y, w, h, r2x, r2y, r.GetRight() - r.GetLeft(), r.GetBottom() - r.GetTop());
    }

    public static boolean RectCollision(MmgRect src, MmgRect dest) {
        return MmgHelper.RectCollision(src.GetLeft(), src.GetTop(), src.GetWidth(), src.GetHeight(), dest);
    }

    public static boolean RectCollision(int r1x, int r1y, int r1w, int r1h, int r2x, int r2y, int r2w, int r2h) {
        if (r1x >= r2x && r1x <= r2x + r2w && r1y >= r2y && r1y <= r2y + r2h) {
            return true;
        }
        if (r1x + r1w >= r2x && r1x + r1w <= r2x + r2w && r1y >= r2y && r1y <= r2y + r2h) {
            return true;
        }
        if (r1x + r1w >= r2x && r1x + r1w <= r2x + r2w && r1y + r1h >= r2y && r1y + r1h <= r2y + r2h) {
            return true;
        }
        if (r1x >= r2x && r1x <= r2x + r2w && r1y + r1h >= r2y && r1y + r1h <= r2y + r2h) {
            return true;
        }
        if (r2x >= r1x && r2x <= r1x + r1w && r2y >= r1y && r2y <= r1y + r1h) {
            return true;
        }
        if (r2x + r2w >= r1x && r2x + r2w <= r1x + r1w && r2y >= r1y && r2y <= r1y + r1h) {
            return true;
        }
        if (r2x + r2w >= r1x && r2x + r2w <= r1x + r1w && r2y + r2h >= r1y && r2y + r2h <= r1y + r1h) {
            return true;
        }
        return r2x >= r1x && r2x <= r1x + r1w && r2y + r2h >= r1y && r2y + r2h <= r1y + r1h;
    }

    public static int AbsDistance(int x1, int x2, int y1, int y2) {
        return (int)Math.sqrt((y1 - x1) * (y1 - x1) + (y2 - x2) * (y2 - x2));
    }

    public static MmgObj CenterHor(MmgObj obj) {
        MmgVector2 vec = new MmgVector2(MmgScreenData.GetGameLeft() + (MmgScreenData.GetGameWidth() - obj.GetWidth()) / 2, obj.GetPosition().GetY());
        obj.SetPosition(vec);
        return obj;
    }

    public static MmgObj CenterVert(MmgObj obj) {
        MmgVector2 vec = new MmgVector2(obj.GetPosition().GetX(), MmgScreenData.GetGameTop() + (MmgScreenData.GetGameHeight() - obj.GetHeight()) / 2);
        obj.SetPosition(vec);
        return obj;
    }

    public static MmgObj CenterHorAndVert(MmgObj obj) {
        obj = MmgHelper.CenterHor(obj);
        obj = MmgHelper.CenterVert(obj);
        return obj;
    }

    public static MmgObj CenterHorAndTop(MmgObj obj) {
        obj = MmgHelper.CenterHor(obj);
        MmgVector2 pos = obj.GetPosition().Clone();
        pos.SetY(MmgScreenData.GetGameTop());
        obj.SetPosition(pos);
        return obj;
    }

    public static MmgObj CenterHorAndBot(MmgObj obj) {
        obj = MmgHelper.CenterHor(obj);
        MmgVector2 pos = obj.GetPosition().Clone();
        int h = obj.GetHeight();
        pos.SetY(MmgScreenData.GetGameTop() + MmgScreenData.GetGameHeight() - h);
        obj.SetPosition(pos);
        return obj;
    }

    public static MmgObj CenterHorAndMid(MmgObj obj) {
        return MmgHelper.CenterHorAndVert(obj);
    }

    public static MmgObj LeftHorAndTop(MmgObj obj) {
        MmgVector2 pos = obj.GetPosition().Clone();
        pos.SetX(MmgScreenData.GetGameLeft());
        pos.SetY(MmgScreenData.GetGameTop());
        obj.SetPosition(pos);
        return obj;
    }

    public static MmgObj LeftHorAndMid(MmgObj obj) {
        MmgVector2 pos = obj.GetPosition().Clone();
        pos.SetX(MmgScreenData.GetGameLeft());
        obj.SetPosition(pos);
        return MmgHelper.CenterVert(obj);
    }

    public static MmgObj LeftHorAndBot(MmgObj obj) {
        MmgVector2 pos = obj.GetPosition().Clone();
        int h = obj.GetHeight();
        pos.SetY(MmgScreenData.GetGameTop() + MmgScreenData.GetGameHeight() - h);
        pos.SetX(MmgScreenData.GetGameLeft());
        obj.SetPosition(pos);
        return obj;
    }

    public static MmgObj RightHorAndTop(MmgObj obj) {
        MmgVector2 pos = obj.GetPosition().Clone();
        int w = obj.GetWidth();
        pos.SetX(MmgScreenData.GetGameLeft() + MmgScreenData.GetGameWidth() - w);
        pos.SetY(MmgScreenData.GetGameTop());
        obj.SetPosition(pos);
        return obj;
    }

    public static MmgObj RightHorAndMid(MmgObj obj) {
        MmgVector2 pos = obj.GetPosition().Clone();
        int w = obj.GetWidth();
        pos.SetX(MmgScreenData.GetGameLeft() + MmgScreenData.GetGameWidth() - w);
        obj.SetPosition(pos);
        return MmgHelper.CenterVert(obj);
    }

    public static MmgObj RightHorAndBot(MmgObj obj) {
        MmgVector2 pos = obj.GetPosition().Clone();
        int h = obj.GetHeight();
        int w = obj.GetWidth();
        pos.SetY(MmgScreenData.GetGameTop() + MmgScreenData.GetGameHeight() - h);
        pos.SetX(MmgScreenData.GetGameLeft() + MmgScreenData.GetGameWidth() - w);
        obj.SetPosition(pos);
        return obj;
    }

    public static int ScaleValue(int val) {
        return (int)((double)val * MmgScreenData.GetScaleX());
    }

    public static float ScaleValue(float val) {
        return (float)((double)val * MmgScreenData.GetScaleX());
    }

    public static double ScaleValue(double val) {
        return val * MmgScreenData.GetScaleX();
    }
}

