/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgEvent;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgMenuItem;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgScreenData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgUpdateHandler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgGameScreen
extends MmgObj {
    protected boolean pause;
    protected boolean ready;
    private MmgContainer objects;
    private MmgObj background;
    private MmgObj foreground;
    private MmgObj header;
    private MmgObj footer;
    private MmgObj leftCursor;
    private MmgObj rightCursor;
    private MmgObj message;
    private MmgMenuContainer menu;
    private int menuIdx;
    private int menuStart;
    private int menuStop;
    private int menuCursorLeftOffsetX;
    private int menuCursorLeftOffsetY;
    private int menuCursorRightOffsetX;
    private int menuCursorRightOffsetY;
    private MmgUpdateHandler updateHandler;
    private boolean menuOn;

    public MmgGameScreen() {
        this.pause = false;
        this.ready = false;
        this.objects = new MmgContainer();
        this.menu = new MmgMenuContainer();
        this.background = null;
        this.foreground = null;
        this.header = null;
        this.footer = null;
        this.leftCursor = null;
        this.rightCursor = null;
        this.message = null;
        this.menuIdx = 0;
        this.menuStart = 0;
        this.menuStop = 0;
        this.SetMenuOn(false);
        this.SetWidth(MmgScreenData.GetGameWidth());
        this.SetHeight(MmgScreenData.GetGameHeight());
        this.SetPosition(MmgVector2.GetOriginVec());
    }

    public MmgGameScreen(MmgGameScreen gm) {
        this.SetObjects(gm.GetObjects());
        this.SetMenu(gm.GetMenu());
        this.SetBackground(gm.GetBackground());
        this.SetForeground(gm.GetForeground());
        this.SetHeader(gm.GetHeader());
        this.SetFooter(gm.GetFooter());
        this.SetLeftCursor(gm.GetLeftCursor());
        this.SetRightCursor(gm.GetRightCursor());
        this.SetMessage(gm.GetMessage());
        this.SetMenuOn(gm.GetMenuOn());
        this.SetMenuIdx(gm.GetMenuIdx());
        this.SetMenuStart(gm.GetMenuStart());
        this.SetMenuStop(gm.GetMenuStop());
        if (gm.GetPosition() != null) {
            this.SetPosition(gm.GetPosition().Clone());
        } else {
            this.SetPosition(gm.GetPosition());
        }
        this.SetWidth(gm.GetWidth());
        this.SetHeight(gm.GetHeight());
        this.SetMmgColor(gm.GetMmgColor());
    }

    @Override
    public MmgObj Clone() {
        MmgGameScreen ret = new MmgGameScreen(this);
        return ret;
    }

    public int GetMenuCursorLeftOffsetX() {
        return this.menuCursorLeftOffsetX;
    }

    public void SetMenuCursorLeftOffsetX(int i) {
        this.menuCursorLeftOffsetX = i;
    }

    public int GetMenuCursorLeftOffsetY() {
        return this.menuCursorLeftOffsetY;
    }

    public void SetMenuCursorLeftOffsetY(int i) {
        this.menuCursorLeftOffsetY = i;
    }

    public int GetMenuCursorRightOffsetX() {
        return this.menuCursorRightOffsetX;
    }

    public void SetMenuCursorRightOffsetX(int i) {
        this.menuCursorRightOffsetX = i;
    }

    public int GetMenuCursorRightOffsetY() {
        return this.menuCursorRightOffsetY;
    }

    public void SetMenuCursorRightOffsetY(int i) {
        this.menuCursorRightOffsetY = i;
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final void Pause() {
        this.pause = true;
        this.SetIsVisible(false);
    }

    public final void UnPause() {
        this.pause = false;
        this.SetIsVisible(true);
    }

    public final boolean IsPaused() {
        return this.pause;
    }

    public boolean GetMenuOn() {
        return this.menuOn;
    }

    public void SetMenuOn(boolean m) {
        this.menuOn = m;
    }

    public void AddObj(MmgObj obj) {
        if (this.objects != null) {
            this.objects.Add(obj);
        }
    }

    public void RemoveObj(MmgObj obj) {
        if (this.objects != null) {
            this.objects.Remove(obj);
        }
    }

    public void ClearObjs() {
        if (this.objects != null) {
            this.objects.Clear();
        }
    }

    public void EventHandler(MmgEvent e) {
        if (e.GetEventId() == MmgEvent.EVENT_ID_UP) {
            this.MoveMenuSelUp();
        } else if (e.GetEventId() == MmgEvent.EVENT_ID_DOWN) {
            this.MoveMenuSelDown();
        } else if (e.GetEventId() == MmgEvent.EVENT_ID_ENTER) {
            if (this.menu != null) {
                Object[] objs = this.menu.GetArray();
                MmgMenuItem item = null;
                item = (MmgMenuItem)objs[this.menuIdx];
                this.ProcessMenuItemSel(item);
            }
        } else if (e.GetEventId() == MmgEvent.EVENT_ID_SPACE && this.menu != null) {
            Object[] objs = this.menu.GetArray();
            MmgMenuItem item = null;
            item = (MmgMenuItem)objs[this.menuIdx];
            this.ProcessMenuItemSel(item);
        }
    }

    public MmgContainer GetObjects() {
        return this.objects;
    }

    public void SetObjects(MmgContainer c) {
        this.objects = c;
    }

    public MmgObj GetBackground() {
        return this.background;
    }

    public void SetBackground(MmgObj b) {
        this.background = b;
    }

    public void SetCenteredBackground(MmgObj b) {
        MmgHelper.CenterHorAndVert(b);
        this.SetBackground(b);
    }

    public MmgObj GetForeground() {
        return this.foreground;
    }

    public void SetForeground(MmgObj b) {
        this.foreground = b;
    }

    public MmgObj GetHeader() {
        return this.header;
    }

    public void SetHeader(MmgObj m) {
        this.header = m;
        MmgHelper.CenterHorAndTop(this.header);
    }

    public MmgObj GetFooter() {
        return this.footer;
    }

    public void SetFooter(MmgObj m) {
        this.footer = m;
        MmgHelper.CenterHorAndBot(this.footer);
    }

    public MmgObj GetLeftCursor() {
        return this.leftCursor;
    }

    public void SetLeftCursor(MmgObj m) {
        this.leftCursor = m;
    }

    public MmgObj GetRightCursor() {
        return this.rightCursor;
    }

    public void SetRightCursor(MmgObj m) {
        this.rightCursor = m;
    }

    public MmgObj GetMessage() {
        return this.message;
    }

    public void SetMessage(MmgObj m) {
        this.message = m;
    }

    public MmgMenuContainer GetMenu() {
        return this.menu;
    }

    public void SetMenu(MmgMenuContainer m) {
        this.menu = m;
    }

    public int GetMenuIdx() {
        return this.menuIdx;
    }

    public void SetMenuIdx(int i) {
        this.menuIdx = i;
    }

    public int GetMenuStart() {
        return this.menuStart;
    }

    public void SetMenuStart(int i) {
        this.menuStart = i;
    }

    public int GetMenuStop() {
        return this.menuStop;
    }

    public void SetMenuStop(int i) {
        this.menuStop = i;
    }

    public void CenterObjects() {
        if (this.background != null) {
            this.background.SetPosition(new MmgVector2((MmgScreenData.GetGameWidth() - this.background.GetWidth()) / 2, (MmgScreenData.GetGameHeight() - this.background.GetHeight()) / 2));
        }
        if (this.header != null) {
            this.header.SetPosition(new MmgVector2((MmgScreenData.GetGameWidth() - this.header.GetWidth()) / 2, (MmgScreenData.GetGameHeight() - this.header.GetHeight()) / 2));
        }
        if (this.footer != null) {
            this.footer.SetPosition(new MmgVector2((MmgScreenData.GetGameWidth() - this.footer.GetWidth()) / 2, (MmgScreenData.GetGameHeight() - this.footer.GetHeight()) / 2));
        }
        if (this.message != null) {
            this.message.SetPosition(new MmgVector2((MmgScreenData.GetGameWidth() - this.message.GetWidth()) / 2, (MmgScreenData.GetGameHeight() - this.message.GetHeight()) / 2));
        }
        if (this.foreground != null) {
            this.foreground.SetPosition(new MmgVector2((MmgScreenData.GetGameWidth() - this.foreground.GetWidth()) / 2, (MmgScreenData.GetGameHeight() - this.foreground.GetHeight()) / 2));
        }
    }

    public void SetMmgUpdateHandler(MmgUpdateHandler u) {
        this.updateHandler = u;
    }

    public MmgUpdateHandler GetMmgUpdateHandler() {
        return this.updateHandler;
    }

    public void Update(Object data) {
        if (this.updateHandler != null) {
            this.updateHandler.MmgHandleUpdate(data);
        }
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (!this.IsPaused() && this.GetIsVisible()) {
            if (this.background != null) {
                this.background.MmgDraw(p);
            }
            if (this.header != null) {
                this.header.MmgDraw(p);
            }
            if (this.footer != null) {
                this.footer.MmgDraw(p);
            }
            if (this.message != null) {
                this.message.MmgDraw(p);
            }
            if (this.objects != null) {
                this.objects.MmgDraw(p);
            }
            if (this.menuOn) {
                this.DrawMenu(p);
            }
            if (this.foreground != null) {
                this.foreground.MmgDraw(p);
            }
        }
    }

    @Override
    public boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        boolean ret = false;
        if (!this.IsPaused() && this.GetIsVisible()) {
            if (this.message != null && this.message.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                ret = true;
            }
            if (this.objects != null && this.objects.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                ret = true;
            }
            if (this.foreground != null && this.foreground.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                ret = true;
            }
        }
        return ret;
    }

    public boolean ProcessScreenPress(MmgVector2 v) {
        return this.ProcessScreenPress(v.GetX(), v.GetY());
    }

    public boolean ProcessScreenPress(int x, int y) {
        return true;
    }

    public boolean ProcessScreenRelease(MmgVector2 v) {
        return this.ProcessScreenPress(v.GetX(), v.GetY());
    }

    public boolean ProcessScreenRelease(int x, int y) {
        return true;
    }

    public boolean ProcessAClick() {
        return true;
    }

    public boolean ProcessBClick() {
        return true;
    }

    public void ProcessDebugClick() {
    }

    public boolean ProcessDpadPress(int dir) {
        return true;
    }

    public boolean ProcessDpadRelease(int dir) {
        return true;
    }

    public boolean ProcessDpadClick(int dir) {
        return true;
    }

    public boolean ProcessScreenClick(MmgVector2 v) {
        return this.ProcessScreenClick(v.GetX(), v.GetY());
    }

    public boolean ProcessScreenClick(int x, int y) {
        if (this.menuOn && this.menu != null) {
            Object[] objs = this.menu.GetArray();
            MmgMenuItem item = null;
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    item = (MmgMenuItem)objs[i];
                    if (x < item.GetX() || x > item.GetX() + item.GetWidth() || y < item.GetY() || y > item.GetY() + item.GetHeight()) continue;
                    this.menuIdx = i;
                    this.ProcessMenuItemSel(item);
                    return true;
                }
            }
        }
        return false;
    }

    public void ProcessMenuItemSel(MmgMenuItem item) {
        MmgEvent me;
        if (item != null && (me = item.GetEventPress()) != null && me.GetTargetEventHandler() != null) {
            me.GetTargetEventHandler().MmgHandleEvent(me);
        }
    }

    public void MoveMenuSelUp() {
        if (this.menuIdx - 1 >= this.menuStart) {
            --this.menuIdx;
        }
    }

    public void MoveMenuSelDown() {
        if (this.menuIdx + 1 <= this.menuStop) {
            ++this.menuIdx;
        }
    }

    private void DrawMenu(MmgPen p) {
        if (this.menu != null) {
            int padPosY = 5;
            int padPosX = 5;
            Object[] objs = this.menu.GetArray();
            for (int i = 0; i < objs.length; ++i) {
                MmgMenuItem tmp;
                if (objs[i] == null || (tmp = (MmgMenuItem)objs[i]) == null || !tmp.GetIsVisible()) continue;
                if (i == this.menuIdx) {
                    if (tmp.GetState() != 2) {
                        tmp.SetState(1);
                    }
                } else if (tmp.GetState() != 2) {
                    tmp.SetState(0);
                }
                tmp.MmgDraw(p);
                if (this.menuIdx != i) continue;
                if (this.leftCursor != null) {
                    this.leftCursor.SetPosition(new MmgVector2(tmp.GetX() - this.leftCursor.GetWidth() - padPosX + this.menuCursorLeftOffsetX, tmp.GetY() + this.menuCursorLeftOffsetY));
                    this.leftCursor.MmgDraw(p);
                }
                if (this.rightCursor == null) continue;
                this.rightCursor.SetPosition(new MmgVector2(tmp.GetX() + tmp.GetWidth() + padPosX + this.menuCursorRightOffsetY, tmp.GetY() + this.menuCursorRightOffsetY));
                this.rightCursor.MmgDraw(p);
            }
        }
    }
}

