/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgFont
extends MmgObj {
    private Font font;
    private String text;
    private final FontRenderContext frc = new FontRenderContext(null, true, true);

    public MmgFont() {
        this.text = "";
        this.font = null;
        this.SetWidth(0);
        this.SetHeight(0);
    }

    public MmgFont(Font tf) {
        this.text = "";
        this.font = tf;
        this.SetWidth(0);
        this.SetHeight(0);
    }

    public MmgFont(MmgObj obj) {
        super(obj);
        this.text = "";
        this.font = null;
        this.SetWidth(0);
        this.SetHeight(0);
    }

    public MmgFont(MmgFont fnt) {
        this.SetFont(fnt.GetFont());
        this.SetText(fnt.GetText());
        if (fnt.GetPosition() == null) {
            this.SetPosition(fnt.GetPosition());
        } else {
            this.SetPosition(fnt.GetPosition().Clone());
        }
        this.SetIsVisible(fnt.GetIsVisible());
        if (fnt.GetMmgColor() == null) {
            this.SetMmgColor(fnt.GetMmgColor());
        } else {
            this.SetMmgColor(fnt.GetMmgColor().Clone());
        }
    }

    public MmgFont(Font sf, String txt, MmgVector2 pos, MmgColor cl) {
        this.SetFont(sf);
        this.SetText(txt);
        this.SetPosition(pos);
        this.SetIsVisible(true);
        this.SetMmgColor(cl);
    }

    public MmgFont(Font sf, String txt, int x, int y, MmgColor cl) {
        this.SetFont(sf);
        this.SetText(txt);
        this.SetPosition(new MmgVector2(x, y));
        this.SetIsVisible(true);
        this.SetMmgColor(cl);
    }

    @Override
    public MmgFont Clone() {
        MmgFont ret = new MmgFont(this);
        return ret;
    }

    public String GetText() {
        return this.text;
    }

    public void SetText(String s) {
        if (s != null) {
            this.text = s;
            if (!"".equals(this.text)) {
                Rectangle2D r = this.font.getStringBounds(this.text, this.frc);
                Rectangle r2 = r.getBounds();
                this.SetWidth(r2.width);
                this.SetHeight(r2.height);
            } else {
                this.SetWidth(0);
                this.SetHeight(0);
            }
        } else {
            this.text = null;
            this.SetWidth(0);
            this.SetHeight(0);
        }
    }

    public void SetFontSize(int sz) {
        this.font = this.font.deriveFont((float)sz);
    }

    public int GetFontSize() {
        return this.font.getSize();
    }

    public void SetFont(Font tf) {
        this.font = tf;
    }

    public Font GetFont() {
        return this.font;
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible()) {
            p.DrawText(this);
        }
    }

    public boolean Equals(MmgFont r) {
        return this.GetFont().equals(r.GetFont()) && this.GetText().equals(r.GetText());
    }
}

