/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import java.awt.Image;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgBmp
extends MmgObj {
    private static int ID_SRC = 0;
    private MmgVector2 origin;
    private MmgVector2 scaling;
    private MmgRect srcRect;
    private MmgRect dstRect;
    private Image b;
    private float rotation;
    private String idStr;
    private int id;
    public MmgBmpDrawMode DRAW_MODE = MmgBmpDrawMode.DRAW_BMP_BASIC;

    public MmgBmp() {
        this.origin = new MmgVector2(0, 0);
        this.scaling = new MmgVector2(1, 1);
        this.srcRect = new MmgRect(0, 0, 0, 0);
        this.dstRect = new MmgRect(0, 0, 0, 0);
        this.b = null;
        this.rotation = 0.0f;
        this.SetBmpId();
    }

    public MmgBmp(MmgObj obj) {
        super(obj);
        this.origin = new MmgVector2(0, 0);
        this.scaling = new MmgVector2(1, 1);
        this.srcRect = new MmgRect(0, 0, 0, 0);
        this.dstRect = new MmgRect(0, 0, 0, 0);
        this.b = null;
        this.rotation = 0.0f;
        this.SetBmpId();
    }

    public MmgBmp(MmgBmp bmp) {
        this.SetRotation(bmp.GetRotation());
        if (bmp.GetOrigin() == null) {
            this.SetOrigin(bmp.GetOrigin());
        } else {
            this.SetOrigin(bmp.GetOrigin().Clone());
        }
        if (bmp.GetSrcRect() == null) {
            this.SetSrcRect(bmp.GetSrcRect());
        } else {
            this.SetSrcRect(bmp.GetSrcRect().Clone());
        }
        if (bmp.GetDstRect() == null) {
            this.SetDstRect(bmp.GetDstRect());
        } else {
            this.SetDstRect(bmp.GetDstRect().Clone());
        }
        this.SetTexture2D(bmp.GetTexture2D());
        if (bmp.GetPosition() == null) {
            this.SetPosition(bmp.GetPosition());
        } else {
            this.SetPosition(bmp.GetPosition().Clone());
        }
        if (bmp.GetScaling() == null) {
            this.SetScaling(bmp.GetScaling());
        } else {
            this.SetScaling(bmp.GetScaling().Clone());
        }
        this.SetWidth(bmp.GetUnscaledWidth());
        this.SetHeight(bmp.GetUnscaledHeight());
        this.SetIsVisible(bmp.GetIsVisible());
        if (bmp.GetMmgColor() == null) {
            this.SetMmgColor(bmp.GetMmgColor());
        } else {
            this.SetMmgColor(bmp.GetMmgColor().Clone());
        }
        this.SetBmpId();
    }

    public MmgBmp(Image t) {
        this.SetRotation(0.0f);
        this.SetOrigin(MmgVector2.GetOriginVec());
        this.SetScaling(MmgVector2.GetUnitVec());
        MmgRect r = new MmgRect(MmgVector2.GetOriginVec(), t.getWidth(null), t.getHeight(null));
        this.SetSrcRect(r);
        this.SetDstRect(null);
        this.SetTexture2D(t);
        this.SetPosition(MmgVector2.GetOriginVec());
        this.SetWidth(this.b.getWidth(null));
        this.SetHeight(this.b.getHeight(null));
        this.SetIsVisible(true);
        this.SetMmgColor(null);
        this.SetBmpId();
    }

    public MmgBmp(Image t, MmgRect Src, MmgRect Dst, MmgVector2 Origin, MmgVector2 Scaling, float Rotation) {
        this.SetRotation(Rotation);
        this.SetOrigin(Origin);
        this.SetScaling(Scaling);
        this.SetSrcRect(Src);
        this.SetDstRect(Dst);
        this.SetTexture2D(t);
        this.SetPosition(MmgVector2.GetOriginVec());
        this.SetWidth(this.b.getWidth(null));
        this.SetHeight(this.b.getHeight(null));
        this.SetIsVisible(true);
        this.SetMmgColor(null);
        this.SetBmpId();
    }

    public MmgBmp(Image t, MmgVector2 Position, MmgVector2 Origin, MmgVector2 Scaling, float Rotation) {
        this.SetRotation(Rotation);
        this.SetOrigin(Origin);
        this.SetScaling(Scaling);
        MmgRect r = new MmgRect(Position, t.getWidth(null), t.getHeight(null));
        this.SetSrcRect(r);
        this.SetDstRect(null);
        this.SetTexture2D(t);
        this.SetPosition(Position);
        this.SetWidth(this.b.getWidth(null));
        this.SetHeight(this.b.getHeight(null));
        this.SetIsVisible(true);
        this.SetMmgColor(null);
        this.SetBmpId();
    }

    public String GetIdStr(float rotation) {
        return this.idStr + "_" + rotation;
    }

    public String GetIdStr(MmgVector2 scaling) {
        return this.idStr + "_" + scaling.GetXFloat() + "x" + scaling.GetYFloat();
    }

    public String GetIdStr(float rotation, MmgVector2 scaling) {
        return this.idStr + "_" + rotation + "_" + scaling.GetXFloat() + "x" + scaling.GetYFloat();
    }

    public int GetId(float rotation) {
        return Integer.parseInt(this.id + "0" + (int)rotation);
    }

    public int GetId(MmgVector2 scaling) {
        return Integer.parseInt(this.idStr + "0" + (int)(scaling.GetXFloat() * 10.0f) + "0" + (int)(scaling.GetYFloat() * 10.0f));
    }

    public int GetId(float rotation, MmgVector2 scaling) {
        return Integer.parseInt(this.idStr + "0" + (int)rotation + "0" + (int)(scaling.GetXFloat() * 10.0f) + "0" + (int)(scaling.GetYFloat() * 10.0f));
    }

    public String GetBmpIdStr() {
        return this.idStr;
    }

    public void SetBmpIdStr(String IdStr) {
        this.idStr = IdStr;
    }

    public int GetBmpId() {
        return this.id;
    }

    private void SetBmpId() {
        this.id = ID_SRC++;
        this.idStr = this.id + "";
    }

    @Override
    public MmgObj Clone() {
        MmgBmp ret = new MmgBmp(this);
        return ret;
    }

    public Image GetTexture2D() {
        return this.b;
    }

    public void SetTexture2D(Image d) {
        this.b = d;
    }

    public Image GetImage() {
        return this.GetTexture2D();
    }

    public void SetImage(Image d) {
        this.SetTexture2D(d);
    }

    public MmgRect GetSrcRect() {
        return this.srcRect;
    }

    public void SetSrcRect(MmgRect r) {
        this.srcRect = r;
    }

    public MmgRect GetDstRect() {
        return this.dstRect;
    }

    public void SetDstRect(MmgRect r) {
        this.dstRect = r;
    }

    public float GetRotation() {
        return this.rotation;
    }

    public final void SetRotation(float r) {
        this.rotation = r;
    }

    public MmgVector2 GetOrigin() {
        return this.origin;
    }

    public void SetOrigin(MmgVector2 v) {
        this.origin = v;
    }

    public MmgVector2 GetScaling() {
        return this.scaling;
    }

    public void SetScaling(MmgVector2 v) {
        this.scaling = v;
    }

    public double GetScaledHeight() {
        if (this.GetScaling() == null) {
            return super.GetHeight();
        }
        return (double)super.GetHeight() * this.GetScaling().GetXDouble();
    }

    public int GetUnscaledHeight() {
        return super.GetHeight();
    }

    @Override
    public int GetHeight() {
        return (int)this.GetScaledHeight();
    }

    public float GetHeightFloat() {
        return (float)this.GetScaledHeight();
    }

    public int GetUnscaledWidth() {
        return super.GetWidth();
    }

    public double GetScaledWidth() {
        if (this.GetScaling() == null) {
            return super.GetWidth();
        }
        return (double)super.GetWidth() * this.GetScaling().GetYDouble();
    }

    @Override
    public int GetWidth() {
        return (int)this.GetScaledWidth();
    }

    public float GetWidthFloat() {
        return (float)this.GetScaledWidth();
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible()) {
            if (this.DRAW_MODE == MmgBmpDrawMode.DRAW_BMP_FULL) {
                p.DrawBmp(this);
            } else if (this.DRAW_MODE == MmgBmpDrawMode.DRAW_BMP_BASIC) {
                p.DrawBmpBasic(this);
            } else if (this.DRAW_MODE == MmgBmpDrawMode.DRAW_BMP_BASIC_CACHE) {
                p.DrawBmpFromCache(this);
            }
        }
    }

    public boolean Equals(MmgBmp b) {
        if (b != null) {
            if (this.GetOrigin() == null && b.GetOrigin() != null) {
                return false;
            }
            if (this.GetOrigin() != null && b.GetOrigin() == null) {
                return false;
            }
            if (this.GetOrigin() != null && b.GetOrigin() != null && !this.GetOrigin().Equals(b.GetOrigin())) {
                return false;
            }
            if (this.GetScaling() == null && b.GetScaling() != null) {
                return false;
            }
            if (this.GetScaling() != null && b.GetScaling() == null) {
                return false;
            }
            if (this.GetScaling() != null && b.GetScaling() != null && !this.GetScaling().Equals(b.GetScaling())) {
                return false;
            }
            if (this.GetSrcRect() == null && b.GetSrcRect() != null) {
                return false;
            }
            if (this.GetSrcRect() != null && b.GetSrcRect() == null) {
                return false;
            }
            if (this.GetSrcRect() != null && b.GetSrcRect() != null && !this.GetSrcRect().Equals(b.GetSrcRect())) {
                return false;
            }
            if (this.GetDstRect() == null && b.GetDstRect() != null) {
                return false;
            }
            if (this.GetDstRect() != null && b.GetDstRect() == null) {
                return false;
            }
            if (this.GetDstRect() != null && b.GetDstRect() != null && !this.GetDstRect().Equals(b.GetDstRect())) {
                return false;
            }
            if (this.GetImage() == null && b.GetImage() != null) {
                return false;
            }
            if (this.GetImage() != null && b.GetImage() == null) {
                return false;
            }
            if (this.GetImage() != null && b.GetImage() != null && !this.GetImage().equals(b.GetImage())) {
                return false;
            }
            if (this.GetRotation() != b.GetRotation()) {
                return false;
            }
            if (this.GetBmpIdStr().equals(b.GetBmpIdStr())) {
                return false;
            }
            if (this.GetBmpId() == b.GetBmpId()) {
                return false;
            }
            if (this.DRAW_MODE != b.DRAW_MODE) {
                return false;
            }
            MmgBmp o1 = this;
            MmgBmp o2 = b;
            return o1 == null || o2 == null || o1.Equals((MmgObj)o2);
        }
        return false;
    }

    public static enum MmgBmpDrawMode {
        DRAW_BMP_FULL,
        DRAW_BMP_BASIC_CACHE,
        DRAW_BMP_BASIC;

    }
}

